/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.wizard.ExportImportFilterWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportFilterWizardPage
extends ExportImportFilterWizardPage {
    public ImportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterImportPage", aWorkbench, selection);
        this.setTitle(UIMessages._120);
        this.setDescription(UIMessages._121);
        this.setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor("filter_import_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, UIMessages._122);
        this.createDoubleList(composite, UIMessages._123, UIMessages._124);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(HyadesUIPlugin.getID()) + ".pfie0001");
    }

    protected List populateFilterList() {
        String filterFile = this.sourceNameField.getText().trim();
        ArrayList<FilterQueries> list = new ArrayList<FilterQueries>();
        if (new File(filterFile).exists()) {
            FilterResourceFileHandler resource = FilterResourceFileHandler.instance((URI)URI.createFileURI((String)filterFile));
            Object[] filterQueries = resource.toArray();
            int i = 0;
            while (i < filterQueries.length) {
                if (FilterTypesManager.instance().getFilterType(((FilterQueries)filterQueries[i]).type()) != null) {
                    list.add(((FilterQueries)filterQueries[i]).copy());
                }
                ++i;
            }
            resource.unload();
        }
        return list;
    }

    public boolean finish() {
        List filtersToImport = this.getDoubleList().getTargetItems();
        FilterResourceHandler importResourceHandler = FilterResourceHandler.instance();
        int i = 0;
        while (i < filtersToImport.size()) {
            importResourceHandler.addFilter(((FilterQueries)filtersToImport.get(i)).copy());
            ++i;
        }
        importResourceHandler.save();
        return true;
    }

    protected boolean validateLists() {
        List filtersToImport = this.getDoubleList().getTargetItems();
        int i = 0;
        while (i < filtersToImport.size()) {
            FilterQueries fq = (FilterQueries)filtersToImport.get(i);
            if (FilterResourceHandler.instance().filter(fq.name()) != null) {
                this.setErrorMessage(NLS.bind((String)UIMessages._132, (Object)fq.name()));
                return false;
            }
            ++i;
        }
        return true;
    }

    public void modifyText(ModifyEvent e) {
        super.modifyText(e);
        this.initializeValues();
    }
}

