/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.FileSystemStructureProvider;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CreationOperation
implements IRunnableWithProgress {
    private Map editorIdByResourceToOpen;
    private CreationWizard creationWizard;
    private IOverwriteQuery overwriteQuery;
    private IProjectAdjuster adjuster;

    public CreationOperation(CreationWizard creationWizard, IOverwriteQuery overwriteQuery) {
        this.creationWizard = creationWizard;
        this.overwriteQuery = overwriteQuery;
        this.editorIdByResourceToOpen = new HashMap();
    }

    public void dispose() {
        this.editorIdByResourceToOpen.clear();
        this.creationWizard = null;
        this.overwriteQuery = null;
        this.adjuster = null;
    }

    public IProjectAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void setAdjuster(IProjectAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CreationWizardPage[] pages = this.creationWizard.getCreationWizardPages();
            monitor.beginTask(UIMessages._37, pages.length);
            int i = 0;
            while (i < pages.length) {
                this.createProject(pages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public IResource[] getResourcesToOpen() {
        return this.editorIdByResourceToOpen.keySet().toArray(new IResource[this.editorIdByResourceToOpen.keySet().size()]);
    }

    public String getEditorId(IResource resource) {
        return (String)this.editorIdByResourceToOpen.get(resource);
    }

    private void createProject(CreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IConfigurationElement desc = page.getConfigurationElement();
        IConfigurationElement[] imports = desc.getChildren("import");
        IConfigurationElement[] natures = desc.getChildren("nature");
        IConfigurationElement[] references = desc.getChildren("references");
        int nImports = imports == null ? 0 : imports.length;
        int nNatures = natures == null ? 0 : natures.length;
        int nReferences = references == null ? 0 : references.length;
        monitor.beginTask(UIMessages._38, nImports + 1);
        String[] natureIds = new String[nNatures];
        int i = 0;
        while (i < nNatures) {
            natureIds[i] = natures[i].getAttribute("id");
            ++i;
        }
        IProject[] referencedProjects = new IProject[nReferences];
        int i2 = 0;
        while (i2 < nReferences) {
            referencedProjects[i2] = ResourcesPlugin.getWorkspace().getRoot().getProject(references[i2].getAttribute("id"));
            ++i2;
        }
        IProject proj = this.configNewProject(page, natureIds, referencedProjects, monitor);
        int i3 = 0;
        while (i3 < nImports) {
            this.doImports(page, proj, imports[i3], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i3;
        }
        IConfigurationElement[] filesToOpen = desc.getChildren("open");
        int i4 = 0;
        while (i4 < filesToOpen.length) {
            boolean helpFile = false;
            String baseName = filesToOpen[i4].getAttribute("file");
            String editorId = filesToOpen[i4].getAttribute("editorId");
            if (editorId == null || editorId.equals("")) {
                helpFile = true;
            }
            if (baseName != null && baseName.length() > 0) {
                if (helpFile) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(baseName);
                } else {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(page.getProjectName());
                    IFile fileToOpen = project.getFile((IPath)new Path(baseName));
                    UIUtil.openEditor((IFile)fileToOpen, (String)editorId, (boolean)false);
                }
            }
            ++i4;
        }
    }

    private IProject configNewProject(CreationWizardPage page, String[] natureIds, IProject[] referencedProjects, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = page.getProjectHandle();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(project.getName());
            if (Platform.getLocation().equals((Object)page.getLocationPath())) {
                description.setLocation(null);
            } else {
                description.setLocation(page.getLocationPath());
            }
            IConfigurationElement[] buildCommands = page.getConfigurationElement().getChildren("buildCommand");
            if (buildCommands.length > 0) {
                ICommand[] commands = new ICommand[buildCommands.length];
                int i = 0;
                while (i < buildCommands.length) {
                    String name = buildCommands[i].getAttribute("name");
                    commands[i] = description.newCommand();
                    commands[i].setBuilderName(name);
                    ++i;
                }
                description.setBuildSpec(commands);
            }
            description.setNatureIds(natureIds);
            description.setReferencedProjects(referencedProjects);
            if (!project.exists()) {
                project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            return project;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void doImports(CreationWizardPage page, IProject project, IConfigurationElement curr, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block15: {
            try {
                IPath destPath;
                boolean nl1Exists = false;
                String name = curr.getAttribute("dest");
                if (name == null || name.length() == 0) {
                    destPath = project.getFullPath();
                } else {
                    IFolder folder = project.getFolder(name);
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    destPath = folder.getFullPath();
                }
                String importPath = curr.getAttribute("src");
                if (importPath == null) {
                    importPath = "";
                    HyadesUIPlugin.logError(UIMessages._36);
                    return;
                }
                File file = null;
                File nl1Files = null;
                String toChange = File.separator.equals("/") ? "\\" : "/";
                try {
                    String nl1ModuleName;
                    String nl1FullFileName;
                    URL starterURL = new URL(Platform.getBundle((String)curr.getDeclaringExtension().getNamespace()).getEntry("/"), importPath);
                    file = new File(Platform.asLocalURL((URL)starterURL).getFile());
                    String moduleString = Platform.asLocalURL((URL)starterURL).getFile();
                    moduleString = moduleString.substring(0, moduleString.indexOf(importPath));
                    if (moduleString.endsWith("/") || moduleString.endsWith("\\")) {
                        moduleString = moduleString.substring(0, moduleString.length() - 1);
                    }
                    String lastSegment = moduleString.substring(moduleString.lastIndexOf(47));
                    int lastDash = lastSegment.lastIndexOf(95);
                    String version = "";
                    if (lastDash != -1) {
                        version = lastSegment.substring(lastDash);
                        moduleString = moduleString.substring(0, moduleString.indexOf(version));
                    }
                    if ((nl1Files = new File(nl1FullFileName = StringUtil.replace((String)(String.valueOf(nl1ModuleName = String.valueOf(moduleString) + ".nl1" + version) + "/" + importPath), (String)toChange, (String)File.separator))).exists()) {
                        nl1Exists = true;
                    }
                }
                catch (Exception e) {
                    String message = String.valueOf(importPath) + ":" + e.getMessage();
                    Status status = new Status(4, this.creationWizard.getPluginId(), 4, message, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                importPath = String.valueOf(StringUtil.replace((String)importPath, (String)toChange, (String)File.separator)) + File.separator;
                if (file.isFile()) {
                    this.importFilesFromZip(page, file, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (nl1Exists) {
                        this.importFilesFromZip(page, nl1Files, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    break block15;
                }
                if (file.isDirectory()) {
                    this.importFilesFromDir(page, file, destPath, importPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (nl1Exists) {
                        this.importFilesFromDir(page, nl1Files, destPath, importPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    break block15;
                }
                FileNotFoundException e = new FileNotFoundException(file.getAbsolutePath());
                String message = String.valueOf(importPath) + ":" + e.getMessage();
                Status status = new Status(4, this.creationWizard.getPluginId(), 4, message, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private void importFilesFromDir(CreationWizardPage page, File srcDir, IPath destPath, String importPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        File auxDir;
        if (this.adjuster != null && (auxDir = this.adjuster.adjust(this.creationWizard.getCreationWizardPages(), page, srcDir)) != null && !srcDir.equals(auxDir)) {
            srcDir = auxDir;
            importPath = srcDir.getAbsolutePath();
            String toChange = File.separator.equals("/") ? "\\" : "/";
            importPath = String.valueOf(StringUtil.replace((String)importPath, (String)toChange, (String)File.separator)) + File.separator;
        }
        try {
            ImportOperation op = new ImportOperation(destPath, (Object)srcDir, (IImportStructureProvider)new FileSystemStructureProvider(importPath), this.overwriteQuery);
            op.run(monitor);
        }
        finally {
            if (this.adjuster != null) {
                this.adjuster.finished(page, srcDir);
            }
        }
    }

    private void importFilesFromZip(CreationWizardPage page, File srcFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        ZipFile auxFile;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile);
        }
        catch (Exception e) {
            String message = e.getMessage();
            Status status = new Status(4, this.creationWizard.getPluginId(), 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (this.adjuster != null && (auxFile = this.adjuster.adjust(this.creationWizard.getCreationWizardPages(), page, zipFile)) != null) {
            zipFile = auxFile;
        }
        try {
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.overwriteQuery);
            op.run(monitor);
        }
        finally {
            if (this.adjuster != null) {
                this.adjuster.finished(page, zipFile);
            }
        }
    }
}

