/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.hyades.ui.util.Container;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class TreeSelector
extends Container
implements ICheckStateListener,
ITreeViewerListener {
    private Tree tree;
    protected CheckboxTreeViewer treeViewer;
    protected Object input;
    protected ITreeContentProvider contentProvider;
    private final ILabelProvider labelProvider;
    protected List alreadyExpandedItems;
    private HashMap numberOfCheckedChildren;
    private HashMap numberOfGrayedChildren;

    public TreeSelector(Composite parent, Object input, ITreeContentProvider contentProvider, ILabelProvider labelProvider, int style) {
        this.input = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.init();
        this.initMap();
        this.createContents(parent, style);
    }

    private void init() {
        this.alreadyExpandedItems = new ArrayList();
    }

    private void initMap() {
        this.numberOfCheckedChildren = new HashMap();
        this.numberOfGrayedChildren = new HashMap();
        Object[] children = this.contentProvider.getChildren(this.input);
        int i = 0;
        while (i < children.length) {
            this.numberOfCheckedChildren.put(children[i], new Integer(0));
            this.numberOfGrayedChildren.put(children[i], new Integer(0));
            ++i;
        }
    }

    public void setInput(Object input) {
        this.input = input;
        this.init();
        this.initMap();
        if (this.treeViewer != null) {
            this.treeViewer.setInput(input);
        }
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        if (this.treeViewer != null) {
            this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        }
    }

    public void clear() {
        if (this.treeViewer == null) {
            return;
        }
        ViewerFilter eraser = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return false;
            }
        };
        this.treeViewer.addFilter(eraser);
        this.init();
        this.initMap();
        this.treeViewer.removeFilter(eraser);
    }

    protected void createContents(Composite parent, int style) {
        this.tree = new Tree(parent, 0x20 | style);
        GridData data = new GridData(1808);
        this.tree.setLayoutData((Object)data);
        this.tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput(this.input);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TreeSelector.this.checkElement(event.getElement(), event.getChecked());
            }
        });
        this.contentsChanged();
    }

    protected void checkElement(Object element, boolean isChecked) {
        Integer nb = (Integer)this.numberOfCheckedChildren.get(this.contentProvider.getParent(element));
        if (this.contentProvider.getParent(element) != this.input) {
            this.numberOfCheckedChildren.put(this.contentProvider.getParent(element), nb == null ? new Integer(isChecked ? 1 : 0) : new Integer(isChecked ? nb + 1 : (nb >= 1 ? nb - 1 : 0)));
        }
        this.setGrayed(element, false, this.treeViewer.getGrayed(element));
        this.updateTreeItems(element, isChecked);
    }

    private void updateTreeItems(Object element, boolean state) {
        this.setChildrenChecked(element, state);
        this.updateParent(element, state);
    }

    private void updateParent(Object element, boolean state) {
        Object parentElem = this.contentProvider.getParent(element);
        while (parentElem != this.input && parentElem != null) {
            Integer nbChecked = (Integer)this.numberOfCheckedChildren.get(parentElem);
            if (nbChecked == null) {
                nbChecked = new Integer(0);
            }
            boolean oldIsCkecked = this.treeViewer.getChecked(parentElem);
            boolean oldIsGrayed = this.treeViewer.getGrayed(parentElem);
            Integer nbGrayed = (Integer)this.numberOfGrayedChildren.get(parentElem);
            if (nbGrayed == null) {
                nbGrayed = new Integer(0);
            }
            boolean isChecked = nbChecked > 0;
            boolean isGrayed = nbGrayed > 0 || nbChecked > 0 && nbChecked < this.contentProvider.getChildren(parentElem).length;
            this.setWhiteChecked(parentElem, isChecked, isChecked ^ oldIsCkecked);
            this.setGrayed(parentElem, isGrayed, isGrayed ^ oldIsGrayed);
            parentElem = this.contentProvider.getParent(parentElem);
        }
    }

    private void expandTreeItem(final Object item) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!TreeSelector.this.alreadyExpandedItems.contains(item)) {
                    TreeSelector.this.alreadyExpandedItems.add(item);
                    Object[] children = TreeSelector.this.contentProvider.getChildren(item);
                    int i = 0;
                    while (i < children.length) {
                        Object child = children[i];
                        if (TreeSelector.this.treeViewer.getChecked(item)) {
                            TreeSelector.this.setWhiteChecked(child, true, true);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked, boolean withMapUpdate) {
        this.setGrayed(treeElement, false, false);
        this.treeViewer.setChecked(treeElement, isWhiteChecked);
        if (!withMapUpdate || this.contentProvider.getParent(treeElement) == this.input) {
            return;
        }
        Integer nb = (Integer)this.numberOfCheckedChildren.get(this.contentProvider.getParent(treeElement));
        if (isWhiteChecked) {
            this.numberOfCheckedChildren.put(this.contentProvider.getParent(treeElement), nb == null ? new Integer(1) : new Integer(nb + 1));
        } else {
            this.numberOfCheckedChildren.put(this.contentProvider.getParent(treeElement), nb != null && nb > 0 ? new Integer(nb - 1) : new Integer(0));
        }
    }

    private void setGrayed(Object elem, boolean isGrayed, boolean withMapUpdate) {
        this.treeViewer.setGrayed(elem, isGrayed);
        if (!withMapUpdate || this.contentProvider.getParent(elem) == this.input) {
            return;
        }
        Integer nb = (Integer)this.numberOfGrayedChildren.get(this.contentProvider.getParent(elem));
        if (isGrayed) {
            this.treeViewer.setChecked(elem, true);
            this.numberOfGrayedChildren.put(this.contentProvider.getParent(elem), nb == null ? new Integer(1) : new Integer(nb + 1));
        } else {
            this.numberOfGrayedChildren.put(this.contentProvider.getParent(elem), nb != null && nb > 0 ? new Integer(nb - 1) : new Integer(0));
        }
    }

    public void setAllSelections(final boolean b) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements = TreeSelector.this.contentProvider.getElements(TreeSelector.this.input);
                int i = 0;
                while (i < elements.length) {
                    TreeSelector.this.setWhiteChecked(elements[i], b, false);
                    TreeSelector.this.setChildrenChecked(elements[i], b);
                    ++i;
                }
            }
        });
        this.contentsChanged();
    }

    protected void setChildrenChecked(Object element, boolean state) {
        if (!this.alreadyExpandedItems.contains(element)) {
            return;
        }
        Object[] children = this.contentProvider.getChildren(element);
        if (element != this.input) {
            this.numberOfCheckedChildren.put(element, state ? new Integer(children.length) : new Integer(0));
            this.numberOfGrayedChildren.put(element, new Integer(0));
        }
        int i = 0;
        while (i < children.length) {
            this.setWhiteChecked(children[i], state, false);
            this.setChildrenChecked(children[i], state);
            ++i;
        }
    }

    public void setInitialCheckedRootElements(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            this.treeViewer.setChecked(objects[i], true);
            ++i;
        }
    }

    public void setInitialCheckedElements(List elements) {
        if (elements == null) {
            return;
        }
        for (Object obj : elements) {
            Object parentElem = this.contentProvider.getParent(obj);
            while (parentElem != this.input && parentElem != null) {
                this.expandTreeItem(parentElem);
                parentElem = this.contentProvider.getParent(parentElem);
            }
            this.treeViewer.expandToLevel(obj, 0);
            this.checkElement(obj, true);
            this.treeViewer.setChecked(obj, true);
        }
    }

    public List getSelectedElements() {
        return this.getChildrenChecked(this.input);
    }

    public List getSelectedElements(Class filter) {
        return this.getChildrenChecked(this.input, filter, false);
    }

    private List getChildrenChecked(Object element, Class filter, boolean whiteChecked) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (element != this.input) {
            if (!whiteChecked && !this.treeViewer.getChecked(element)) {
                return ret;
            }
            if (!this.treeViewer.getGrayed(element) && this.treeViewer.isExpandable(element)) {
                whiteChecked = true;
            }
            if (filter.isAssignableFrom(element.getClass())) {
                ret.add(element);
            }
        }
        Object[] children = this.contentProvider.getChildren(element);
        int i = 0;
        while (i < children.length) {
            ret.addAll(this.getChildrenChecked(children[i], filter, whiteChecked));
            ++i;
        }
        return ret;
    }

    private List getChildrenChecked(Object element) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (element != this.input) {
            if (!this.treeViewer.getGrayed(element) && this.treeViewer.getChecked(element)) {
                ret.add(element);
                return ret;
            }
            if (!this.treeViewer.getGrayed(element) && !this.treeViewer.getChecked(element)) {
                return new ArrayList();
            }
        }
        Object[] children = this.contentProvider.getChildren(element);
        int i = 0;
        while (i < children.length) {
            ret.addAll(this.getChildrenChecked(children[i]));
            ++i;
        }
        return ret;
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Control getControl() {
        return this.tree;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expandTreeItem(event.getElement());
    }
}

