/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher.graphs;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.hyades.ui.widgets.grapher.BasicGraph;
import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.grapher.VisiblePointsCache;
import org.eclipse.hyades.ui.widgets.grapher.graphs.LineGraph;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class HighlighterGraph
extends BasicGraph
implements Graph,
BasicGraphSource,
MouseListener,
MouseMoveListener {
    private boolean highlight = false;
    private int currentx;
    private int currenty;
    private double nearestx;
    private double nearesty;
    private boolean nearestvalid;
    private double truex;
    private double truey;
    private DecimalFormat decFormat;
    private GraphCanvas gw;
    private TimeZoomSlider xslider;
    private ZoomSlider yslider;
    private ArrayList disposables = new ArrayList();
    private static Color WHITE = null;
    protected int radius = 10;
    protected int target = 130;
    private static final int roundBuffer = 3;
    private static final int minRadius = 6;
    private static final int LINE_BUFF = 3;
    private static final int LINE_SIDE_BUF = 10;
    private static final int ARC_HEIGHT = 8;
    private static final int ARC_WIDTH = 8;

    public HighlighterGraph() {
        this.getDecFormat();
    }

    private void getDecFormat() {
        NumberFormat format = DecimalFormat.getNumberInstance();
        if (format instanceof DecimalFormat) {
            this.decFormat = (DecimalFormat)format;
        }
        this.decFormat.setMaximumFractionDigits(4);
    }

    protected void setActive(boolean b) {
        this.highlight = b;
    }

    protected boolean getActive() {
        return this.highlight;
    }

    public void setCoordinates(int x, int y) {
        this.currentx = x;
        this.currenty = y;
    }

    public BasicGraphSource getGraphSource() {
        return this;
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return 0.0;
    }

    private Color adjust(Color c) {
        int max = c.getRed();
        max = Math.max(c.getBlue(), max);
        max = Math.max(c.getGreen(), max);
        float multi = (float)this.target / (float)max;
        return this.adjust(c, multi);
    }

    private Color adjust(Color c, float multi) {
        int r = (int)((float)c.getRed() * multi);
        int b = (int)((float)c.getBlue() * multi);
        int g = (int)((float)c.getGreen() * multi);
        Color newCol = new Color((Device)this.gw.getDisplay(), r, g, b);
        return newCol;
    }

    private Font setBold(boolean bold, GC gc) {
        FontData[] data = gc.getFont().getFontData();
        int i = 0;
        while (i < data.length) {
            int style = data[i].getStyle();
            if (bold) {
                data[i].setStyle(style | 1);
            } else {
                data[i].setStyle(style & 0xFFFFFFFE);
            }
            ++i;
        }
        Font f = new Font((Device)this.gw.getDisplay(), data);
        gc.setFont(f);
        return f;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        if (this.highlight) {
            String miscString;
            String valString;
            ArrayList graphs;
            LineGraph g;
            if (this.decFormat == null) {
                this.getDecFormat();
            }
            if ((g = this.locateNearestGraph(graphs = this.gw.getGraphs(), this.currentx, this.currenty)) == null) {
                return;
            }
            int width = this.gw.getSize().x;
            int height = this.gw.getSize().y;
            this.truex = g.getXSlider().pixel2Value(this.nearestx);
            if (this.nearestvalid) {
                this.truey = g.getYSlider().pixel2Value(this.nearesty - 15.0);
                valString = this.decFormat.format(this.truey);
            } else {
                this.truey = Double.NaN;
                valString = "" + this.truey;
            }
            Date date = new Date((long)this.truex);
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String dateString = " (" + dateFormat.format(date) + ")";
            String nameString = g.getName();
            String misc = miscString = g.getMisc();
            Font f = this.setBold(true, gc);
            Point valExtent = gc.textExtent(valString, 3);
            Font f2 = this.setBold(false, gc);
            Point nameExtent = gc.textExtent(nameString, 3);
            Point dateExtent = gc.textExtent(dateString, 3);
            Point miscExtent = gc.textExtent(misc, 3);
            Point lineExtent = new Point(0, 6 + g.getLineWidth());
            Point extent = new Point(Math.max(Math.max(valExtent.x + dateExtent.x, miscExtent.x), nameExtent.x), Math.max(nameExtent.y, dateExtent.y) + miscExtent.y + nameExtent.y + lineExtent.y);
            int drawx = (int)this.nearestx + 2 * this.radius;
            int drawy = (int)this.nearesty - extent.y - 2 * this.radius;
            if (drawx + extent.x > width) {
                drawx = Math.max(0, drawx - extent.x - 4 * this.radius);
            }
            if (drawy < 0) {
                drawy = Math.min(height - extent.y, drawy + extent.y + 4 * this.radius);
            }
            this.radius = 2 * g.getLineWidth();
            if (this.radius < 6) {
                this.radius = 6;
            }
            int linewidth = g.getLineWidth();
            Color newCol = this.adjust(g.getForeground());
            gc.setForeground(newCol);
            gc.setBackground(WHITE);
            gc.setLineStyle(1);
            int tempLineWidth = 2;
            gc.setLineWidth(tempLineWidth);
            gc.drawRoundRectangle(drawx - 3, drawy - 3, extent.x + 6, extent.y + 6, 8, 8);
            tempLineWidth = 1;
            gc.fillRoundRectangle(drawx - 3 + tempLineWidth, drawy - 3 + tempLineWidth, extent.x + 6 - 2 * tempLineWidth, extent.y + 6 - 2 * tempLineWidth, 8, 8);
            gc.setLineWidth(Math.max(linewidth - 1, 1));
            gc.drawOval((int)(this.nearestx - (double)this.radius), (int)(this.nearesty - (double)this.radius), 2 * this.radius, 2 * this.radius);
            this.setBold(true, gc);
            gc.drawText(valString, drawx, drawy, 3);
            this.setBold(false, gc);
            gc.drawText(dateString, drawx + valExtent.x, drawy, 3);
            gc.drawText(nameString, drawx, drawy + Math.max(valExtent.y, dateExtent.y), 3);
            gc.drawText(misc, drawx, drawy + Math.max(valExtent.y, dateExtent.y) + nameExtent.y + lineExtent.y, 3);
            gc.drawLine(0, (int)this.nearesty, (int)(this.nearestx - (double)this.radius), (int)this.nearesty);
            gc.drawLine((int)this.nearestx, (int)(this.nearesty + (double)this.radius), (int)this.nearestx, height);
            gc.setLineStyle(g.getLineStyle());
            gc.setLineWidth(g.getLineWidth());
            gc.setForeground(g.getForeground());
            gc.drawLine(drawx + 10, drawy + Math.max(valExtent.y, dateExtent.y) + lineExtent.y / 2 + nameExtent.y, drawx + extent.x - 10, drawy + Math.max(valExtent.y, dateExtent.y) + lineExtent.y / 2 + nameExtent.y);
            gc.setForeground(g.getForeground());
            gc.setLineStyle(g.getLineStyle());
            gc.setLineWidth(g.getLineWidth());
            f.dispose();
            f2.dispose();
            newCol.dispose();
        }
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setForeground(Color col) {
    }

    public Color getForeground() {
        return null;
    }

    public void setLineWidth(int w) {
    }

    public int getLineWidth() {
        return 0;
    }

    public void setLineStyle(int swt_line_style) {
    }

    public int getLineStyle() {
        return 0;
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 0.0;
    }

    public int getPlottingType() {
        return 0;
    }

    public void setPlottingType(int type) {
    }

    public int getNoDataBehaviour() {
        return 0;
    }

    public void setNoDataBehaviour(int behaviour) {
    }

    public void setPlottingPeriod(int type, double value) {
    }

    public int getPlottingPeriodType() {
        return 0;
    }

    public double getPlottingPeriodValue() {
        return 0.0;
    }

    public void setXOffset(double millis) {
    }

    public double getXOffset() {
        return 0.0;
    }

    public void setYOffset(double millis) {
    }

    public double getYOffset() {
        return 0.0;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 0.0;
    }

    private LineGraph locateNearestGraph(ArrayList graphList, int mousex, int mousey) {
        LineGraph nearest = null;
        double dist = -1.0;
        int i = 0;
        while (i < graphList.size()) {
            Object obj = graphList.get(i);
            if (obj instanceof LineGraph) {
                LineGraph tempGraph = (LineGraph)obj;
                VisiblePointsCache pc = tempGraph.getPointsCache();
                double[] xvalues = pc.getXValues();
                double[] yvalues = pc.getYValues();
                boolean[] isvalid = pc.getValidValues();
                int index = 0;
                while (index < pc.getLength()) {
                    double x = xvalues[index];
                    double y = yvalues[index];
                    boolean valid = isvalid[index];
                    double newdist = ((double)mousex - x) * ((double)mousex - x) + ((double)mousey - y) * ((double)mousey - y);
                    if (dist == -1.0 || newdist < dist) {
                        this.nearestx = x;
                        this.nearesty = y;
                        this.nearestvalid = valid;
                        nearest = tempGraph;
                        dist = newdist;
                    }
                    ++index;
                }
            }
            ++i;
        }
        return nearest;
    }

    public void setName(String name) {
    }

    public String getName() {
        return null;
    }

    public void setDescription(String description) {
    }

    public String getDescription() {
        return null;
    }

    public void setMisc(String misc) {
    }

    public String getMisc() {
        return null;
    }

    public void setGraphCanvas(GraphCanvas gc) {
        this.gw = gc;
        if (WHITE == null) {
            WHITE = new Color((Device)this.gw.getDisplay(), 255, 255, 255);
            this.disposables.add(WHITE);
        }
        if (!this.gw.isDisposed()) {
            this.gw.addMouseListener(this);
        }
        if (!this.gw.isDisposed()) {
            this.gw.addMouseMoveListener(this);
        }
    }

    public GraphCanvas getGraphCanvas() {
        return this.gw;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.setActive(true);
            this.setCoordinates(e.x, e.y);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1) {
            this.setActive(false);
        }
    }

    public void mouseMove(MouseEvent e) {
        this.setCoordinates(e.x, e.y);
        if (this.getActive()) {
            this.gw.redraw();
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.disposables.size()) {
            Object o = this.disposables.get(i);
            if (o instanceof Color) {
                ((Color)o).dispose();
            }
            ++i;
        }
    }

    public void setXDelta(double millis) {
    }

    public double getXDelta() {
        return 0.0;
    }

    public void setYDelta(double millis) {
    }

    public double getYDelta() {
        return 0.0;
    }
}

