/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher.graphs;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.grapher.TextGraph;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class IndicatorLineGraph
implements TextGraph,
IndicatorSource {
    private int type = 0;
    private TimeZoomSlider xslider;
    private ZoomSlider yslider;
    private Color black_color;
    private Color fg_col;
    private int line_width = 1;
    private int line_style = 1;
    private static DateFormat df = DateFormat.getDateInstance((int)1);
    private static DateFormat tf = DateFormat.getTimeInstance();
    private double source_val = Double.MAX_VALUE;

    public IndicatorLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.xslider = xslider;
        this.yslider = yslider;
        this.fg_col = col;
    }

    public BasicGraphSource getGraphSource() {
        return null;
    }

    public double getXMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getXMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public int getSourceType() {
        return this.type;
    }

    public void setSourceType(int type) {
        this.type = type;
    }

    public void setIndicatorLocation(double time) {
        this.source_val = time;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        this.paintGraph(gc, x, y, w, h, 0);
    }

    public int paintGraph(GC gc, int x, int y, int w, int h, int yoffset) {
        int fheight = gc.getFontMetrics().getHeight();
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        int xval = (int)this.source_val;
        long t = (long)this.xslider.pixel2Value(xval);
        if (this.type == 0) {
            xval = (int)this.xslider.value2Pixel(this.source_val);
            t = (long)this.source_val;
        }
        if (xval < w) {
            gc.drawLine(xval, y, xval, y + h);
            Date d = new Date(t);
            String dateString = df.format(d);
            String timeString = tf.format(d);
            int dateExtent = gc.textExtent((String)dateString).y;
            gc.setForeground(this.yslider.getDisplay().getSystemColor(15));
            gc.drawString(dateString.toString(), xval + 4, yoffset + y + 1, true);
            gc.drawString(timeString.toString(), xval + 4, yoffset + y + 1 + dateExtent, true);
            try {
                gc.setForeground(this.yslider.getDisplay().getSystemColor(2));
            }
            catch (Throwable throwable) {
                if (this.black_color == null) {
                    this.black_color = new Color((Device)this.yslider.getDisplay(), 0, 0, 0);
                }
                gc.setForeground(this.black_color);
            }
            gc.drawString(dateString.toString(), xval + 3, yoffset + y, true);
            gc.drawString(timeString.toString(), xval + 3, yoffset + y + dateExtent, true);
            if ((yoffset += fheight) + fheight > h) {
                yoffset = 0;
            }
        }
        return yoffset;
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 1.0;
    }

    public int getPlottingType() {
        return 0;
    }

    public void setPlottingType(int type) {
    }

    public void setPlottingPeriod(int type, double value) {
    }

    public int getPlottingPeriodType() {
        return 0;
    }

    public double getPlottingPeriodValue() {
        return 1.0;
    }

    public void setXOffset(double millis) {
    }

    public double getXOffset() {
        return 0.0;
    }

    public void setYOffset(double millis) {
    }

    public double getYOffset() {
        return 0.0;
    }

    public int getNoDataBehaviour() {
        return 0;
    }

    public void setNoDataBehaviour(int i) {
    }

    public void setName(String name) {
    }

    public String getName() {
        return null;
    }

    public void setDescription(String description) {
    }

    public String getDescription() {
        return null;
    }

    public void setMisc(String misc) {
    }

    public String getMisc() {
        return null;
    }

    public void setGraphCanvas(GraphCanvas gc) {
    }

    public GraphCanvas getGraphCanvas() {
        return null;
    }

    public void dispose() {
    }

    public double getIndicatorLocation() {
        return this.source_val;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public void setXDelta(double millis) {
    }

    public double getXDelta() {
        return 0.0;
    }

    public void setYDelta(double millis) {
    }

    public double getYDelta() {
        return 0.0;
    }
}

