/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher.graphs;

import org.eclipse.hyades.ui.widgets.grapher.BasicGraph;
import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.GraphSource;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.grapher.VisiblePointsCache;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomIndicator;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderTick;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineGraph
extends BasicGraph
implements Graph {
    private static final boolean DRAW_ONLY_IF_DATA = true;
    private static final int PLOTTING_TYPE_STDDEV_AVERAGE_PLUS = -9990;
    private static final int PLOTTING_TYPE_STDDEV_AVERAGE_MINUS = -9991;
    private String name;
    private String description;
    private String misc;
    private Color fg_col;
    private int line_width = 2;
    private int line_style = 1;
    private int nodata = 1;
    private int plotting_type = 0;
    private int plotting_period_type = 0;
    private double plotting_period_value = 1.0;
    private double xoffset = 0.0;
    private double yoffset = 0.0;
    private double xdelta = 0.0;
    private double ydelta = 0.0;
    private double scaling = 1.0;
    private double last_drawn_value = 0.0;
    private double recentMaxValue = Double.MIN_VALUE;
    private double tmpMaxValue = 0.0;
    protected boolean use_indicators = true;
    protected ZoomIndicator indicator;
    protected IndicatorSource isource;
    protected GraphSource source;
    protected ZoomSlider yslider;
    protected TimeZoomSlider xslider;
    protected VisiblePointsCache pointsCache;

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.plotting_period_type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        this.pointsCache = new VisiblePointsCache(this);
        this.init();
    }

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean pixel_perfect, boolean use_indicators) {
        this.plotting_period_type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        if (pixel_perfect) {
            this.plotting_period_type = 2;
            this.plotting_period_value = 1.0;
        } else {
            this.plotting_period_type = 0;
            this.plotting_period_value = 1.0;
        }
        this.use_indicators = use_indicators;
        this.pointsCache = new VisiblePointsCache(this);
        this.init();
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    private void init() {
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setIndicatorSource(IndicatorSource source) {
        this.isource = source;
    }

    public void setShown(boolean b) {
        if (this.use_indicators && !b) {
            if (!this.yslider.isDisposed()) {
                this.yslider.removeIndicator(this.indicator);
            }
            this.indicator.dispose();
        } else if (this.use_indicators && b && !this.yslider.isDisposed()) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color col) {
        this.fg_col = col;
        if (this.use_indicators) {
            this.indicator.setColor(col);
        }
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public int getNoDataBehaviour() {
        return this.nodata;
    }

    public void setNoDataBehaviour(int behaviour) {
        this.nodata = behaviour;
    }

    public double getRecentMaxValue() {
        return this.recentMaxValue;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        gc.setLineCap(2);
        this.tmpMaxValue = Double.MIN_VALUE;
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        ZoomSliderTick tick_start = this.xslider.getFirstTick();
        ZoomSliderTick tick_end = this.xslider.getLastTick();
        if (tick_start == null || tick_end == null) {
            return;
        }
        double res = this.xslider.getIncrement();
        double start = tick_start.getValue() - res;
        double end = tick_end.getValue() + res;
        if (this.plotting_period_type == 0) {
            res = this.xslider.getIncrement();
            res *= this.plotting_period_value;
        } else if (this.plotting_period_type == 2) {
            res = this.xslider.pixel2Value(1.0) - this.xslider.pixel2Value(0.0);
            res *= this.plotting_period_value;
        } else if (this.plotting_period_type == 1) {
            res = this.plotting_period_value;
            if (res < 10.0) {
                res = 10.0;
            }
        } else if (this.plotting_period_type == 3) {
            res = 10.0;
        }
        start -= start % res;
        if (this.plotting_type == 3) {
            this.paintGraph(gc, x, y, start, end, res, 1, w, h);
            this.paintGraph(gc, x, y, start, end, res, 2, w, h);
        } else if (this.plotting_type == 4) {
            this.paintGraph(gc, x, y, start, end, res, 1, w, h);
            this.paintGraph(gc, x, y, start, end, res, 2, w, h);
            this.paintGraph(gc, x, y, start, end, res, 0, w, h);
        } else if (this.plotting_type == 9) {
            this.paintGraph(gc, x, y, start, end, res, -9990, w, h);
            this.paintGraph(gc, x, y, start, end, res, -9991, w, h);
            this.paintGraph(gc, x, y, start, end, res, 0, w, h);
        } else {
            this.paintGraph(gc, x, y, start, end, res, this.plotting_type, w, h);
        }
    }

    public void paintGraph(GC gc, int xorigin, int yorigin, double start, double end, double res, int plot_type, int width, int height) {
        boolean found_indicator = false;
        double indicator_loc = 0.0;
        int indicator_type = 0;
        if (this.isource != null) {
            indicator_loc = this.isource.getIndicatorLocation();
            indicator_type = this.isource.getSourceType();
        }
        double indicator_val = this.last_drawn_value;
        boolean first = true;
        double px = 0.0;
        double py = 0.0;
        double last_clean_cx = 0.0;
        double last_clean_cy = 0.0;
        double last_cy = 0.0;
        this.pointsCache.reset();
        boolean empty = false;
        double i = start;
        while (i <= end) {
            double cx = i;
            double cx_shifted = cx - this.xoffset - this.xdelta;
            if (!(cx_shifted > this.source.getMax() + res) && !(cx_shifted < this.source.getMin() - res)) {
                double pixel_y;
                double pixel_x;
                double cy = 0.0;
                cy = plot_type == 6 ? this.source.getValueAt(cx_shifted) : (plot_type == 0 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) : (plot_type == 5 ? this.source.getSumBetween(cx_shifted - res, cx_shifted) : (plot_type == 1 ? this.source.getMinBetween(cx_shifted - res, cx_shifted) : (plot_type == 2 ? this.source.getMaxBetween(cx_shifted - res, cx_shifted) : (plot_type == 7 ? this.source.getCountBetween(cx_shifted - res, cx_shifted) : (plot_type == 8 ? this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : (plot_type == -9990 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) + this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : (plot_type == -9991 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) - this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : (plot_type == 10 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) : this.source.getAverageBetween(cx_shifted - res, cx_shifted))))))))));
                if (first) {
                    first = false;
                    empty = Double.isNaN(cy);
                    if (empty && this.nodata == 3) {
                        first = true;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = py;
                    } else if (empty && this.nodata == 0) {
                        first = true;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = py;
                    } else {
                        if (empty && this.nodata == 2) {
                            cy = last_clean_cy;
                        } else if (empty && this.nodata == 1) {
                            cy = 0.0;
                        }
                        last_clean_cx = cx;
                        last_clean_cy = cy;
                        cy += this.yoffset + this.ydelta;
                        last_cy = cy *= this.scaling;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = this.yslider.value2Pixel(cy);
                        if (cy > this.tmpMaxValue) {
                            this.tmpMaxValue = cy;
                        }
                        this.drawLine(gc, xorigin + (int)pixel_x, yorigin + (int)pixel_y, xorigin + (int)pixel_x, yorigin + (int)pixel_y);
                    }
                } else {
                    boolean emptyPrevious = empty;
                    empty = Double.isNaN(cy);
                    if (empty && this.nodata == 0) {
                        first = true;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = py;
                        if (this.isource != null) {
                            if (indicator_type == 0 && indicator_loc > cx - res && indicator_loc < cx) {
                                found_indicator = true;
                                indicator_val = 0.0;
                            }
                            if (indicator_type == 1 && indicator_loc > px && indicator_loc < pixel_x) {
                                found_indicator = true;
                                indicator_val = 0.0;
                            }
                        }
                        if (!emptyPrevious) {
                            this.drawLine(gc, xorigin + (int)px, yorigin + (int)py, xorigin + (int)pixel_x, yorigin + (int)py);
                        }
                    } else {
                        boolean valid = true;
                        if (empty && this.nodata == 2) {
                            cy = last_clean_cy;
                        } else if (empty && this.nodata == 1) {
                            valid = false;
                            cy = -this.yoffset - this.ydelta;
                        } else if (this.nodata == 3) {
                            if (!empty) {
                                last_clean_cx = cx;
                                last_clean_cy = cy;
                            } else {
                                cx = last_clean_cx;
                                cy = last_clean_cy;
                                valid = false;
                            }
                        }
                        if (plot_type == 10) {
                            double deltay = cy - last_clean_cy;
                            double deltax = (cx - last_clean_cx) / 1000.0;
                            last_clean_cx = cx;
                            last_clean_cy = cy;
                            cy = deltay / deltax;
                        } else {
                            last_clean_cy = cy;
                        }
                        cy += this.yoffset;
                        cy += this.ydelta;
                        cy *= this.scaling;
                        if (this.isource != null && indicator_type == 0 && indicator_loc > cx - res && indicator_loc < cx) {
                            found_indicator = true;
                            indicator_val = cy;
                        }
                        last_cy = cy;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = this.yslider.value2Pixel(cy);
                        if (cy > this.tmpMaxValue) {
                            this.tmpMaxValue = cy;
                        }
                        if (this.isource != null && indicator_type == 1 && indicator_loc > px && indicator_loc < pixel_x) {
                            found_indicator = true;
                            indicator_val = cy;
                        }
                        if (!empty || this.nodata != 3) {
                            this.drawLine(gc, xorigin + (int)px, yorigin + (int)py, xorigin + (int)pixel_x, yorigin + (int)pixel_y, valid);
                        }
                    }
                }
                px = pixel_x;
                py = pixel_y;
            }
            i += res;
        }
        double startpx = px;
        double endpx = Math.min(this.xslider.value2Pixel(this.source.getSessionMax() + this.xoffset + this.xdelta), (double)width);
        if (this.nodata == 2 && last_clean_cx != 0.0) {
            this.drawLine(gc, xorigin + (int)px, yorigin + (int)py, xorigin + (int)endpx, yorigin + (int)py);
            startpx = endpx;
        }
        if (endpx > px) {
            double endy = this.yslider.value2Pixel(0.0);
            int oldStyle = gc.getLineStyle();
            gc.setLineStyle(3);
            this.drawLine(gc, xorigin + (int)startpx, yorigin + (int)endy, xorigin + (int)endpx, yorigin + (int)endy, false);
            gc.setLineStyle(oldStyle);
        }
        this.last_drawn_value = last_cy;
        this.recentMaxValue = this.tmpMaxValue;
        if (this.use_indicators) {
            if (this.isource == null || !found_indicator) {
                this.indicator.setBaseValue(this.yoffset + this.ydelta);
                this.indicator.setValue(this.last_drawn_value);
            } else {
                this.indicator.setBaseValue(this.yoffset + this.ydelta);
                this.indicator.setValue(indicator_val);
            }
        }
        this.yslider.updateIndicators();
    }

    private void drawLine(GC gc, int startx, int starty, int endx, int endy) {
        this.drawLine(gc, startx, starty, endx, endy, true);
    }

    private void drawLine(GC gc, int startx, int starty, int endx, int endy, boolean valid) {
        gc.drawLine(startx, starty, endx, endy);
        this.pointsCache.addPoint(endx, endy, valid);
    }

    public int getPlottingType() {
        return this.plotting_type;
    }

    public void setPlottingType(int type) {
        this.plotting_type = type;
    }

    public void setPlottingPeriod(int type, double value) {
        this.plotting_period_type = type;
        this.plotting_period_value = value;
    }

    public int getPlottingPeriodType() {
        return this.plotting_period_type;
    }

    public double getPlottingPeriodValue() {
        return this.plotting_period_value;
    }

    public void setXOffset(double millis) {
        this.xoffset = millis;
    }

    public double getXOffset() {
        return this.xoffset;
    }

    public void setYOffset(double millis) {
        this.yoffset = millis;
    }

    public double getYOffset() {
        return this.yoffset;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        if (this.use_indicators) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        }
        this.yslider = slider;
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setStaticScaling(double mult) {
        this.scaling = mult;
    }

    public double getStaticScaling() {
        return this.scaling;
    }

    public VisiblePointsCache getPointsCache() {
        return this.pointsCache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMisc(String misc) {
        this.misc = misc;
    }

    public String getMisc() {
        return this.misc;
    }

    public void setGraphCanvas(GraphCanvas gc) {
    }

    public GraphCanvas getGraphCanvas() {
        return null;
    }

    public void dispose() {
    }

    public void setUseIndicators(boolean useIndicators) {
        this.use_indicators = useIndicators;
    }

    public boolean getUseIndicators() {
        return this.use_indicators;
    }

    public void setXDelta(double millis) {
        this.xdelta = millis;
    }

    public double getXDelta() {
        return this.xdelta;
    }

    public void setYDelta(double millis) {
        this.ydelta = millis;
    }

    public double getYDelta() {
        return this.ydelta;
    }
}

