/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import java.util.Vector;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomControlBar;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderUtilities;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomControlBarsCollection {
    private ZoomSlider slider;
    private Vector bars = new Vector();
    private boolean selected;
    private boolean primed;
    private boolean moved;

    public ZoomControlBarsCollection(ZoomSlider slider) {
        this.slider = slider;
    }

    public void add(ZoomControlBar bar) {
        if (bar != null && !this.bars.contains(bar)) {
            this.bars.addElement(bar);
        }
    }

    public void remove(ZoomControlBar bar) {
        if (bar != null && this.bars.contains(bar)) {
            this.bars.removeElement(bar);
        }
        this.selected = false;
    }

    public boolean hasBars() {
        return !this.bars.isEmpty();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void paint(Image buffer, GC gBuffer, GC g, boolean indicatorsChanged) {
        if (!this.selected) {
            int i = 0;
            while (i < this.bars.size()) {
                ((ZoomControlBar)this.bars.elementAt(i)).paint(gBuffer);
                ++i;
            }
            g.drawImage(buffer, 0, 0);
        } else {
            if (!this.primed || indicatorsChanged) {
                int i = 0;
                while (i < this.bars.size() - 1) {
                    ((ZoomControlBar)this.bars.elementAt(i)).paint(gBuffer);
                    ++i;
                }
                this.primed = true;
            }
            ((ZoomControlBar)this.bars.elementAt(this.bars.size() - 1)).hide(buffer, gBuffer);
            g.drawImage(buffer, 0, 0);
            ((ZoomControlBar)this.bars.elementAt(this.bars.size() - 1)).paint(g);
        }
    }

    public boolean mouseDown(MouseEvent event) {
        this.selected = false;
        this.primed = false;
        this.moved = false;
        ZoomControlBar bar = this.getZoomControlBarContaining(event.x, event.y);
        if (bar != null) {
            this.selected = true;
            this.bars.removeElement(bar);
            this.bars.addElement(bar);
            if (event.button == 1) {
                this.slider.updateScale();
                this.slider.redraw();
                this.primed = false;
            }
            return true;
        }
        return false;
    }

    public boolean mouseUp(MouseEvent event) {
        if (this.selected) {
            ZoomControlBar last = (ZoomControlBar)this.bars.elementAt(this.bars.size() - 1);
            last.sprayZoomControlBarEvent(true);
            this.selected = false;
            this.primed = false;
            if (!this.moved) {
                int pix = (int)this.slider.value2Pixel(last.getValue());
                int i = this.bars.size() - 2;
                while (i >= 0) {
                    ZoomControlBar previous = (ZoomControlBar)this.bars.elementAt(i);
                    int prevPix = (int)this.slider.value2Pixel(previous.getValue());
                    if (prevPix > pix - 3 && prevPix < pix + 3) {
                        this.bars.removeElement(last);
                        this.bars.insertElementAt(last, 0);
                        this.bars.removeElement(previous);
                        this.bars.addElement(previous);
                        break;
                    }
                    --i;
                }
            }
            this.moved = false;
            this.slider.redraw();
            return true;
        }
        return false;
    }

    public boolean mouseMove(MouseEvent event) {
        if (this.primed) {
            this.moved = true;
            ZoomControlBar bar = (ZoomControlBar)this.bars.elementAt(this.bars.size() - 1);
            double oldValue = bar.getValue();
            if (this.slider.getOrientation() == 0) {
                bar.setValue(ZoomSliderUtilities.round(this.slider.pixel2Value(event.y), this.slider.getUnitIncrement()));
            } else {
                bar.setValue(ZoomSliderUtilities.round(this.slider.pixel2Value(event.x), this.slider.getUnitIncrement()));
            }
            this.slider.redraw();
            if (oldValue != bar.getValue()) {
                bar.sprayZoomControlBarEvent(false);
            }
        }
        return false;
    }

    public ZoomControlBar getZoomControlBarContaining(int x, int y) {
        if (this.bars.size() > 0) {
            int i = this.bars.size() - 1;
            while (i >= 0 && !((ZoomControlBar)this.bars.elementAt(i)).inside(x, y)) {
                --i;
            }
            if (i >= 0) {
                return (ZoomControlBar)this.bars.elementAt(i);
            }
        }
        return null;
    }

    public Vector getZoomControlBars() {
        return this.bars;
    }

    public void dispose() {
        int i = 0;
        while (i < this.bars.size() - 1) {
            ((ZoomControlBar)this.bars.elementAt(i)).dispose();
            ++i;
        }
    }
}

