/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.extensions.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;
import org.eclipse.hyades.test.ui.extensions.ExtensionsImages;
import org.eclipse.hyades.test.ui.extensions.ExtensionsPlugin;
import org.eclipse.hyades.test.ui.extensions.internal.resources.ExtensionsPluginResourceBundle;
import org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRecordRepositoryProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRepositoryRecordListener;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TestLogBugzillaProvider
implements IRecordRepositoryProvider {
    private ListenerList recordListeners = new ListenerList();
    private TPFExecutionEvent input = null;
    private IManagedForm mForm = null;
    private Composite parent = null;
    private Section defectSection = null;
    private Composite defectSectionClient = null;
    private List recordIDs = null;
    private Composite recordParent = null;
    private IWorkbenchBrowserSupport browserSupport = null;

    public void addRecordListener(IRepositoryRecordListener listener) {
        this.recordListeners.add((Object)listener);
    }

    public void removeRecordListener(IRepositoryRecordListener listener) {
        this.recordListeners.remove((Object)listener);
    }

    public void createContent(final IManagedForm mForm, final Composite parent) {
        this.mForm = mForm;
        this.parent = parent;
        this.defectSection = FormsUtil.createSection((IManagedForm)mForm, (Composite)parent, (String)ExtensionsPluginResourceBundle.TestLogViewer_Defects, (String)"");
        this.defectSectionClient = (Composite)this.defectSection.getClient();
        GridLayout layout = new GridLayout(2, false);
        this.defectSectionClient.setLayout((Layout)layout);
        TableWrapLayout tLayout = new TableWrapLayout();
        tLayout.numColumns = 3;
        tLayout.makeColumnsEqualWidth = true;
        this.recordParent = mForm.getToolkit().createComposite(this.defectSectionClient);
        this.recordParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.recordParent.setLayout((Layout)tLayout);
        this.recordIDs = new ArrayList();
        mForm.getToolkit().paintBordersFor(this.defectSectionClient);
        Composite actionParent = new Composite(this.defectSectionClient, 0);
        actionParent.setLayoutData((Object)new GridData(130));
        actionParent.setLayout((Layout)new GridLayout());
        Button add = mForm.getToolkit().createButton(actionParent, ExtensionsPluginResourceBundle.WORD_ADD_DOT, 8);
        add.setLayoutData((Object)new GridData(770));
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (((BaseFormEditor)((FormPage)mForm.getContainer()).getEditor()).isReadOnly()) {
                    e.doit = false;
                } else {
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), ExtensionsPluginResourceBundle.TestLogViewer_addDefectTitle, ExtensionsPluginResourceBundle.TestLogViewer_enterBugzillaNumber, null, new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText != null && newText.trim().length() > 0) {
                                try {
                                    Integer.parseInt(newText);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return NLS.bind((String)ExtensionsPluginResourceBundle.TestLogViewer_invalidBugzillaNumber, (Object)newText);
                                }
                                if (TestLogBugzillaProvider.this.recordIDs.contains(newText.trim())) {
                                    return NLS.bind((String)ExtensionsPluginResourceBundle.TestLogViewer_alreadyExists, (Object)newText);
                                }
                            } else {
                                return "";
                            }
                            return null;
                        }
                    });
                    if (dialog.open() == 0) {
                        String value = dialog.getValue().trim();
                        TPFRepositoryRecord record = Common_TestprofileFactory.eINSTANCE.createTPFRepositoryRecord();
                        record.setID(value);
                        record.setURI(String.valueOf(ExtensionsPlugin.getPreference("bugzillaOpenURL")) + value);
                        record.setLabel(value);
                        record.setType("org.bugzilla");
                        TestLogBugzillaProvider.this.fireRecordChanged(record, true);
                        TestLogBugzillaProvider.this.createRecordHyperLink(record);
                        TestLogBugzillaProvider.this.recordIDs.add(record.getID());
                        TestLogBugzillaProvider.this.recordParent.layout();
                        TestLogBugzillaProvider.this.defectSectionClient.layout();
                        parent.layout();
                    }
                }
            }
        });
        Button submit = mForm.getToolkit().createButton(actionParent, ExtensionsPluginResourceBundle.TestLogViewer_Submit, 8);
        submit.setLayoutData((Object)new GridData(770));
        submit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TestLogBugzillaProvider.this.openURL(ExtensionsPlugin.getPreference("bugzillaSubmitURL"), "org.eclipse.hyades.test.ui.extensions", ExtensionsPluginResourceBundle.TestLogViewer_NewBug, "");
            }
        });
        Button search = mForm.getToolkit().createButton(actionParent, ExtensionsPluginResourceBundle.TestLogViewer_Search, 8);
        search.setLayoutData((Object)new GridData(770));
        search.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TestLogBugzillaProvider.this.openURL(ExtensionsPlugin.getPreference("bugzillaSearchURL"), "org.eclipse.hyades.test.ui.extensions", ExtensionsPluginResourceBundle.TestLogViewer_SearchForBugs, "");
            }
        });
        mForm.getToolkit().paintBordersFor(this.defectSectionClient);
    }

    public void setInput(TPFExecutionEvent event) {
        if (event == null || event.equals(this.input)) {
            return;
        }
        this.input = event;
        if (this.recordParent != null && !this.recordParent.isDisposed()) {
            Control[] children = this.recordParent.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (children[i] != null && !children[i].isDisposed()) {
                        children[i].dispose();
                        children[i] = null;
                    }
                    ++i;
                }
            }
            if (this.recordIDs == null) {
                this.recordIDs = new ArrayList();
            } else {
                this.recordIDs.clear();
            }
            EList records = event.getDefectRecords();
            if (records != null) {
                int i = 0;
                while (i < records.size()) {
                    TPFRepositoryRecord record = (TPFRepositoryRecord)records.get(i);
                    String type = record.getType();
                    if (type != null && type.equals("org.bugzilla")) {
                        this.createRecordHyperLink(record);
                        this.recordIDs.add(record.getID());
                    }
                    ++i;
                }
            }
            this.recordParent.layout();
            this.mForm.getToolkit().paintBordersFor(this.recordParent);
            this.defectSectionClient.layout();
            this.defectSection.redraw();
        }
    }

    protected void fireRecordChanged(TPFRepositoryRecord record, boolean isAdd) {
        Object[] listeners = this.recordListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (isAdd) {
                ((IRepositoryRecordListener)listeners[i]).recordAdded(record);
            } else {
                ((IRepositoryRecordListener)listeners[i]).recordRemoved(record);
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof TPFExecutionEvent) {
            this.setInput((TPFExecutionEvent)selection.getFirstElement());
        }
    }

    private void openURL(String url, String browserId, String title, String tooltip) {
        IWebBrowser browser = null;
        int flags = 0;
        if (this.browserSupport == null) {
            this.browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        }
        flags = this.browserSupport.isInternalWebBrowserAvailable() ? 38 : 134;
        try {
            browser = this.browserSupport.createBrowser(flags, browserId, title, tooltip);
            browser.openURL(new URL(url));
        }
        catch (Exception e) {
            ExtensionsPlugin.logError(e);
        }
    }

    private void createRecordHyperLink(TPFRepositoryRecord record) {
        TableWrapLayout tablewrapLayout = new TableWrapLayout();
        tablewrapLayout.numColumns = 2;
        tablewrapLayout.makeColumnsEqualWidth = false;
        tablewrapLayout.horizontalSpacing = 0;
        Composite recordLinkParent = this.mForm.getToolkit().createComposite(this.recordParent);
        recordLinkParent.setLayoutData((Object)new TableWrapData(256, 32));
        recordLinkParent.setLayout((Layout)tablewrapLayout);
        ImageHyperlink recordLink = this.mForm.getToolkit().createImageHyperlink(recordLinkParent, 0);
        recordLink.setLayoutData((Object)new TableWrapData(8, 32));
        recordLink.setText(record.getLabel());
        recordLink.setImage(ExtensionsImages.INSTANCE.getImage("bug.gif"));
        recordLink.setData((Object)record);
        recordLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                TPFRepositoryRecord repositoryRecord = (TPFRepositoryRecord)hyperlinkEvent.widget.getData();
                String url = String.valueOf(ExtensionsPlugin.getPreference("bugzillaOpenURL")) + repositoryRecord.getLabel();
                if (url != null && url.trim().length() > 0) {
                    TestLogBugzillaProvider.this.openURL(url, "org.eclipse.hyades.test.ui.extensions", repositoryRecord.getLabel(), "");
                }
            }
        });
        ImageHyperlink removeRecordLink = this.mForm.getToolkit().createImageHyperlink(recordLinkParent, 0);
        removeRecordLink.setLayoutData((Object)new TableWrapData(2, 32));
        removeRecordLink.setImage(ExtensionsImages.INSTANCE.getImage("remove_bug.gif"));
        removeRecordLink.setData((Object)record);
        removeRecordLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                if (!((BaseFormEditor)((FormPage)TestLogBugzillaProvider.this.mForm.getContainer()).getEditor()).isReadOnly()) {
                    TPFRepositoryRecord repositoryRecord = (TPFRepositoryRecord)hyperlinkEvent.widget.getData();
                    if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)ExtensionsPluginResourceBundle.TestLogViewer_removeDefectConfirmTitle, (String)NLS.bind((String)ExtensionsPluginResourceBundle.TestLogViewer_removeDefectConfirmMessage, (Object)repositoryRecord.getLabel()))) {
                        ((ImageHyperlink)hyperlinkEvent.getSource()).getParent().dispose();
                        TestLogBugzillaProvider.this.fireRecordChanged(repositoryRecord, false);
                        TestLogBugzillaProvider.this.recordIDs.remove(repositoryRecord.getID());
                        TestLogBugzillaProvider.this.recordParent.layout();
                        TestLogBugzillaProvider.this.parent.layout();
                    }
                }
            }
        });
        recordLinkParent.layout();
    }
}

