/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.UserFactory;
import org.eclipse.hyades.security.internal.util.IConnectUtilUI;
import org.eclipse.hyades.security.internal.util.IConnectUtilUser;
import org.eclipse.hyades.security.internal.util.ITPTPSecureStorageProvider;
import org.eclipse.hyades.security.internal.util.NullConnectUtilUI;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.security.internal.util.UntrustedCertificateAgentControllerException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class BaseConnectUtil {
    private static final String TPTPECLIPSE_SECURE_STORAGE_SECURITY_PROVIDER = "TPTPEclipseSecureStorageSecurityProvider";
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    public static final int CONNECTION_SECURITY_NOT_SUPPORTED = 4;
    public static final int CONNECTION_SECURITY_REQUIRED = 5;
    public static final int CONNECTION_AUTHENTICATION_SUCCESS = 6;
    public static final int CONNECTION_AUTHENTICATION_FAILED = 7;
    public static final int CONNECTION_UNTRUSTED = 8;
    public static final int AUTHENTICATION_SUCCESS = 0;
    public static final int AUTHENTICATION_FAILED = 1;
    public static final int AUTHENTICATION_ABORTED = 2;
    protected static int CERTIFICATE_UNKNOWN = 0;
    protected static int CERTIFICATE_SAVED = 1;
    protected static int CERTIFICATE_BYPASSED = 2;
    protected static int CERTIFICATE_CANCELLED = 3;
    public static final String PLUGIN_ID = "org.eclipse.hyades.ui";
    public static final String COMMON_UI_PLUGIN_ID = "org.eclipse.tptp.platform.common.ui";
    protected Application _app;
    protected String _port;
    protected String _hostName;
    protected InetAddress _hostAddr;
    protected String _userId;
    protected String _userPw;
    protected Node _node;
    protected ConnectErrorMsg _connectErrorMessage;
    protected String _keyStoreDir;
    protected String _keyStorePassword;
    protected SecureConnectionRequiredException _secureConnectionRequiredException = null;
    protected IConnectUtilUI connectionUI;

    public BaseConnectUtil(String hostName, String port, Application app) {
        this(hostName, port, null, app);
    }

    public BaseConnectUtil(String hostName, String port, String userId, Application app) {
        this(hostName, port, userId, app, null, null);
    }

    public BaseConnectUtil(String hostName, String port, String userId, Application app, String keyStoreDir, String keyStorePassword) {
        this._hostName = hostName;
        this._port = port;
        this._userId = userId;
        this._app = app;
        this.connectionUI = this.createConnectUI();
        this._connectErrorMessage = null;
        this._keyStoreDir = keyStoreDir;
        this._keyStorePassword = keyStorePassword;
    }

    public BaseConnectUtil(InetAddress hostAddr, String port, Application app) {
        this(hostAddr, port, null, app);
    }

    public BaseConnectUtil(InetAddress hostAddr, String port, String userId, Application app) {
        this.connectionUI = this.createConnectUI();
        this._hostAddr = hostAddr;
        this._hostName = this._hostAddr.getHostName();
        this._port = port;
        this._userId = userId;
        this._app = app;
        if (this._keyStoreDir == null) {
            this._keyStoreDir = CommonPlugin.getKeyStoreLocation();
        }
    }

    protected IConnectUtilUI createConnectUI() {
        return new NullConnectUtilUI();
    }

    protected ISecureClientParameters getClientParms() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        ISecureClientParameters parameters = this.getClientParms(extensionRegistry.getConfigurationElementsFor(PLUGIN_ID, "JSSESecurityProviders"));
        parameters = parameters == null ? this.getClientParms(extensionRegistry.getConfigurationElementsFor(COMMON_UI_PLUGIN_ID, "JSSESecurityProviders")) : parameters;
        return parameters;
    }

    protected ISecureClientParameters getClientParms(IConfigurationElement[] config) {
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String classAttr = elem.getAttribute("class");
            if (classAttr != null) {
                try {
                    Object realization = elem.createExecutableExtension("class");
                    if (realization instanceof ISecureClientParameters) {
                        return (ISecureClientParameters)realization;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++idx;
        }
        return null;
    }

    protected void showErrorDialogForConnect(ConnectErrorMsg message) {
        if (message != null) {
            this.openErrorDialog(SecurityMessages._41, message.getErrorMessage(), (IStatus)message.getErrorStatus());
        }
    }

    public void showErrorDialogForConnect() {
        this.showErrorDialogForConnect(this._connectErrorMessage);
    }

    public final int connect() {
        return this.connect(true);
    }

    public final int connect(String password, boolean showErrorMsgs) {
        int rc_authenticate;
        int rc_connect;
        block35: {
            rc_connect = 2;
            rc_authenticate = 1;
            try {
                if (this._hostAddr == null) {
                    this._hostAddr = InetAddress.getByName(this._hostName);
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (showErrorMsgs) {
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._43, (Object)this._hostName), null);
                    this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                }
                return 2;
            }
            if (this._node == null) {
                try {
                    this._node = NodeFactory.createNode((InetAddress)this._hostAddr, (Principal)this._app);
                }
                catch (UnknownHostException exc) {
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._43, (Object)this._hostName), (Throwable)exc);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                    return 2;
                }
            }
            if (!this._node.isConnected() || this._node.getConnection().getPort() != Integer.parseInt(this._port)) {
                rc_connect = this.insecureConnect(showErrorMsgs);
                if (rc_connect == 5) {
                    if (this._secureConnectionRequiredException != null) {
                        try {
                            rc_connect = this.secureConnect(showErrorMsgs);
                            if (rc_connect != 0) {
                                return rc_connect;
                            }
                        }
                        catch (UntrustedCertificateAgentControllerException e) {
                            if (this.saveCertificateUI(e.getKeyStore(), e.getCertificate())) {
                                try {
                                    rc_connect = this.secureConnect(showErrorMsgs);
                                    if (rc_connect != 0) {
                                        return rc_connect;
                                    }
                                    break block35;
                                }
                                catch (UntrustedCertificateAgentControllerException e1) {
                                    e1.printStackTrace();
                                }
                                break block35;
                            }
                            this.resetConnection();
                            return 2;
                        }
                    }
                } else if (rc_connect == 0) {
                    return 0;
                }
            } else {
                rc_connect = 0;
                if (!(this._node.getConnection() instanceof SecureConnectionImpl)) {
                    return 0;
                }
            }
        }
        if (rc_connect != 0) {
            return rc_connect;
        }
        if (this._node.getConnection() instanceof SecureConnectionImpl) {
            if (!((NodeImpl)this._node).isUserAuthenticated()) {
                rc_authenticate = this.authenticateUser(this._userId, this._userPw);
                if (rc_authenticate != 0) {
                    StringBuffer preferenceUserPw;
                    StringBuffer preferenceUserId;
                    boolean preferenceCred;
                    this._userPw = password;
                    rc_authenticate = this.authenticateUser(this._userId, this._userPw);
                    if (rc_authenticate != 0 && (preferenceCred = this.getPreferenceCredentials(this._hostName, preferenceUserId = new StringBuffer(), preferenceUserPw = new StringBuffer()))) {
                        rc_authenticate = this.authenticateUser(preferenceUserId.toString(), preferenceUserPw.toString());
                    }
                    if (rc_authenticate != 0) {
                        int retry = 0;
                        do {
                            IConnectUtilUser user;
                            if ((user = this.connectionUI.promptAuthentication(this.getHostName(), this._userId)) == null) {
                                rc_authenticate = 2;
                                break;
                            }
                            this._userId = user.getName();
                            this._userPw = user.getPassword();
                            rc_authenticate = this.authenticateUser(this._userId, this._userPw);
                        } while (rc_authenticate != 0 && ++retry < 3);
                    }
                }
            } else {
                rc_authenticate = 0;
            }
            if (rc_authenticate == 1) {
                if (showErrorMsgs) {
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._52, (Object)this._hostName), null);
                    this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                }
                return 7;
            }
        }
        if (rc_connect == 0) {
            if (rc_authenticate == 0) {
                return 0;
            }
            return 7;
        }
        return 2;
    }

    private boolean getPreferenceCredentials(String hostname, StringBuffer preferenceUserId, StringBuffer preferenceUserPw) {
        boolean found = false;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor(COMMON_UI_PLUGIN_ID, TPTPECLIPSE_SECURE_STORAGE_SECURITY_PROVIDER);
        int i = 0;
        while (i < elements.length && !found) {
            IConfigurationElement configurationElement = elements[i];
            if (configurationElement.getAttribute("class") != null) {
                try {
                    ITPTPSecureStorageProvider provider = (ITPTPSecureStorageProvider)configurationElement.createExecutableExtension("class");
                    found = provider.getCredentialsForHost(hostname, preferenceUserId, preferenceUserPw);
                }
                catch (CoreException e) {
                    CommonPlugin.getLogger().logError(e);
                    return false;
                }
            }
            ++i;
        }
        return found;
    }

    public final int reconnect(String password, boolean showErrorMsgs) {
        return this.connect(password, showErrorMsgs);
    }

    public final int connectConnection(String password, boolean showErrorMsgs) {
        return this.connect(password, showErrorMsgs);
    }

    protected int insecureConnect(boolean showErrorMsgs) {
        try {
            this._node.setUser(null);
            this._node.setSecurityParameters(null);
            this._node.connect(Integer.parseInt(this._port));
        }
        catch (SecureConnectionRequiredException exc) {
            this._secureConnectionRequiredException = exc;
            return 5;
        }
        catch (UntrustedAgentControllerException exc) {
            exc.printStackTrace();
            return 5;
        }
        catch (AgentControllerUnavailableException exc) {
            this.resetConnection();
            if (showErrorMsgs) {
                this.showConnectionError((Exception)((Object)exc));
            }
            return 1;
        }
        catch (NumberFormatException exc) {
            this.resetConnection();
            if (showErrorMsgs) {
                Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._44, (Object)String.valueOf(this._port)), (Throwable)exc);
                this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
            }
            return 3;
        }
        return 0;
    }

    protected boolean loadKeyStore(boolean showErrorMsgs) {
        block13: {
            IKeystoreManager km;
            ISecureClientParameters param;
            if (this._node != null && (param = this._node.getSecurityParameters()) != null && (km = param.getKeystoreManager()) != null) {
                try {
                    km.loadKeystore(this._keyStoreDir, this._keyStorePassword);
                    return true;
                }
                catch (IOException e) {
                    this.resetConnection();
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._69, null), (Throwable)e);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                }
                catch (CertificateException e) {
                    this.resetConnection();
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._46, (Object)this._keyStoreDir), (Throwable)e);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                }
                catch (KeyManagementException e) {
                    this.resetConnection();
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._48, (Object)this._keyStoreDir), (Throwable)e);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                }
                catch (KeyStoreException e) {
                    this.resetConnection();
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._49, (Object)this._keyStoreDir), (Throwable)e);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    this.resetConnection();
                    if (showErrorMsgs) {
                        Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._47, (Object)this._keyStoreDir), (Throwable)e);
                        this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                    }
                }
                catch (UnrecoverableKeyException e) {
                    this.resetConnection();
                    if (!showErrorMsgs) break block13;
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._50, (Object)this._keyStoreDir), (Throwable)e);
                    this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                }
            }
        }
        return false;
    }

    protected void showConnectionError(Exception exc) {
        try {
            if (this._hostName.equals("localhost") || InetAddress.getByName(this._hostName).equals(InetAddress.getLocalHost())) {
                Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._67, (Object)"localhost"), (Throwable)exc);
                this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                return;
            }
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._67, (Object)this._hostName), (Throwable)exc);
            this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
        }
        catch (Exception exec) {
            exec.printStackTrace();
        }
    }

    protected int secureConnect(boolean showErrorMsgs) throws UntrustedCertificateAgentControllerException {
        int securedPort;
        block11: {
            ISecureClientParameters parms;
            String keyStorePassword;
            String keyStoreDir;
            block12: {
                keyStoreDir = null;
                keyStorePassword = null;
                securedPort = (int)this._secureConnectionRequiredException.getSecurePort();
                if (this._node.getSecurityParameters() != null) break block11;
                parms = this.getClientParms();
                if (parms != null) break block12;
                this.resetConnection();
                if (showErrorMsgs) {
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._71, (Object)this._hostName), null);
                    this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
                }
                return 4;
            }
            this._node.setSecurityParameters(parms);
            try {
                keyStoreDir = this._node.getSecurityParameters().getKeystoreFileName();
                keyStorePassword = this._node.getSecurityParameters().getKeystoreFilepassword();
                this._keyStoreDir = keyStoreDir;
                this._keyStorePassword = keyStorePassword;
            }
            catch (RuntimeException runtimeException) {}
            if (this.loadKeyStore(showErrorMsgs)) break block11;
            return 2;
        }
        try {
            this._node.setUser(UserFactory.getUser((Application)this._app, (String)this._userId));
            this._node.connect(securedPort);
        }
        catch (SecureConnectionRequiredException e) {
            e.printStackTrace();
            return 4;
        }
        catch (UntrustedAgentControllerException e) {
            throw this.updateCertificateException(e);
        }
        catch (NumberFormatException e) {
            this.resetConnection();
            if (showErrorMsgs) {
                Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._44, (Object)String.valueOf(securedPort)), (Throwable)e);
                this.showErrorDialogForConnect(new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err));
            }
            return 2;
        }
        catch (AgentControllerUnavailableException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public final int connect(boolean showErrorMsgs) {
        return this.connect(null, showErrorMsgs);
    }

    public String getUserId() {
        return this._userId;
    }

    public Node getNode() {
        return this._node;
    }

    public void resetConnection() {
        if (this._userId != null) {
            UserFactory.removeUser((Application)this._app, (String)this._userId);
        }
        if (this._node != null) {
            this._node.setSecurityParameters(null);
        }
    }

    public int authenticateUser(String userId, String userPw) {
        User user = null;
        if (userId != null && !userId.equals("")) {
            user = UserFactory.getUser((Application)this._app, (String)userId);
            if (UserFactory.getUser((Application)this._app, (String)userId) != null) {
                UserFactory.removeUser((Application)this._app, (String)userId);
            }
            try {
                user = UserFactory.createUser((Application)this._app, (String)userId, (String)userPw);
            }
            catch (DuplicateUserException e) {
                e.printStackTrace();
            }
        }
        if (user == null || userPw == null) {
            return 2;
        }
        user.setPassword(userPw);
        if (user == null) {
            // empty if block
        }
        this._node.setUser(user);
        if (this._node instanceof NodeImpl) {
            boolean status = ((NodeImpl)this._node).authenticateUser();
            if (status) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    protected UntrustedCertificateAgentControllerException updateCertificateException(UntrustedAgentControllerException exc) {
        TrustManager[] tManagers = this._node.getSecurityParameters().getKeystoreManager().getTrustManagers();
        X509Certificate cert = null;
        try {
            int i = 0;
            while (i < tManagers.length) {
                Method getReceivedCerts = tManagers[i].getClass().getMethod("getReceivedCerts", null);
                Object certs = getReceivedCerts.invoke((Object)tManagers[i], null);
                if (certs != null) {
                    cert = (X509Certificate)((Object[])certs)[0];
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        KeyStore keyStore = this.creatKeyStore();
        UntrustedCertificateAgentControllerException newExc = new UntrustedCertificateAgentControllerException((Exception)((Object)exc));
        newExc.setCertificate(cert);
        newExc.setKeyStore(keyStore);
        return newExc;
    }

    public KeyStore creatKeyStore() {
        try {
            return KeystoreHelper.createKeyStore((String)this._keyStoreDir, (String)this._keyStorePassword);
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._57, (Object)this._keyStoreDir), (Throwable)exc);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._59, (IStatus)err);
        }
        catch (NoSuchAlgorithmException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)this._keyStoreDir), (Throwable)e);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._59, (IStatus)err);
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._46, (Object)this._keyStoreDir), (Throwable)exc);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._59, (IStatus)err);
        }
        catch (NoSuchProviderException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, SecurityMessages._58, (Throwable)e);
            this.connectionUI.openErrorDialog(SecurityMessages._41, NLS.bind((String)SecurityMessages._57, (Object)this._keyStoreDir), (IStatus)err);
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._61, (Object)this._keyStoreDir), (Throwable)e);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._59, (IStatus)err);
        }
        return null;
    }

    public IStatus saveCertificate(KeyStore ks, String alias, X509Certificate cert) {
        try {
            ks.setCertificateEntry(alias, cert);
            KeystoreHelper.persistKeyStore((KeyStore)ks, (String)this._keyStoreDir, (String)this._keyStorePassword);
            this.loadKeyStore(true);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._54, (Object)this._keyStoreDir), (Throwable)e);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._53, (IStatus)err);
            return err;
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._55, (Object)this._keyStoreDir), (Throwable)exc);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._53, (IStatus)err);
            return err;
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._56, (Object)this._keyStoreDir), (Throwable)exc);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._53, (IStatus)err);
            return err;
        }
        catch (NoSuchAlgorithmException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)this._keyStoreDir), (Throwable)exc2);
            this.connectionUI.openErrorDialog(SecurityMessages._41, SecurityMessages._53, (IStatus)err);
            return err;
        }
    }

    protected boolean saveCertificateUI(KeyStore keyStore, X509Certificate cert) {
        int rc = 0;
        int status = CERTIFICATE_UNKNOWN;
        boolean ok = false;
        do {
            ISecureClientParameters params;
            String[] btnLabels = new String[]{SecurityMessages._32, SecurityMessages._33, SecurityMessages._34};
            rc = this.openQuestionDialog(SecurityMessages._41, NLS.bind((String)SecurityMessages._70, (Object)this._hostName), btnLabels);
            if (rc == 0) {
                ok = this.openSaveCertificateDialog(keyStore);
                if (ok) {
                    this.saveCertificate(keyStore, this.connectionUI.getAlias(), cert);
                    status = CERTIFICATE_SAVED;
                    continue;
                }
                boolean bl = ok = this.openQuestionDialog(SecurityMessages._17, SecurityMessages._76, null) == 0;
                if (ok) {
                    params = this._node.getSecurityParameters();
                    if (params != null) {
                        params.disableServerAuthentication();
                    }
                    status = CERTIFICATE_BYPASSED;
                    continue;
                }
                status = CERTIFICATE_CANCELLED;
                continue;
            }
            if (rc == 1) {
                boolean bl = ok = this.openQuestionDialog(SecurityMessages._17, SecurityMessages._76, null) == 0;
                if (ok) {
                    params = this._node.getSecurityParameters();
                    if (params != null) {
                        params.disableServerAuthentication();
                    }
                    status = CERTIFICATE_BYPASSED;
                    continue;
                }
                status = CERTIFICATE_CANCELLED;
                continue;
            }
            this.openCertificateDetailDialog(cert);
        } while (status == CERTIFICATE_UNKNOWN);
        return status != CERTIFICATE_CANCELLED;
    }

    public static boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equalsIgnoreCase(hostname)) {
            return true;
        }
        try {
            InetAddress a1 = InetAddress.getByName(hostname);
            InetAddress a2 = InetAddress.getLocalHost();
            return a1.getHostAddress().equals(a2.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    protected void openCertificateDetailDialog(X509Certificate certificate) {
        this.connectionUI.openCertificateDetailDialog(certificate);
    }

    protected int openQuestionDialog(String title, String msg, String[] btnLabels) {
        return this.connectionUI.openQuestionDialog(title, msg, btnLabels);
    }

    protected boolean openSaveCertificateDialog(KeyStore ks) {
        return this.connectionUI.openSaveCertificateDialog(ks);
    }

    protected void openErrorDialog(String title, String message, IStatus err) {
        this.connectionUI.openErrorDialog(title, message, err);
    }

    public IConnectUtilUI getConnectionUI() {
        return this.connectionUI;
    }

    public void setConnectionUI(IConnectUtilUI connectionUI) {
        this.connectionUI = connectionUI;
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getPort() {
        return this._port;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setUserPassword(String userPw) {
        this._userPw = userPw;
    }

    protected class ConnectErrorMsg {
        protected String _errorMessage;
        protected Status _status;

        public ConnectErrorMsg(String errorMessage, Status status) {
            this._errorMessage = errorMessage;
            this._status = status;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }

        public Status getErrorStatus() {
            return this._status;
        }
    }
}

