/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim().replace('\\', '/')).endsWith("/") && !path.endsWith("//")) {
            path = path.substring(0, path.length() - "/".length());
        }
        return path;
    }

    public static String appendPath(String path1, String path2) {
        path1 = FileUtil.normalizePath(path1);
        path2 = FileUtil.normalizePath(path2);
        if (path1 == null || path1.trim().length() == 0) {
            return path2;
        }
        if (path2 == null || path2.trim().length() == 0) {
            return path1;
        }
        if (path1.endsWith("//")) {
            if (path2.startsWith("/") && path2.length() > 1) {
                path2 = path2.substring(1);
            }
        } else if (!path2.startsWith("/")) {
            path2 = "/" + path2;
        }
        return String.valueOf(path1) + path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int totalBytes = 0;
                int length = 0;
                byte[] buffer = new byte[256];
                while ((length = inputStream.read(buffer)) != -1) {
                    totalBytes += length;
                    outputStream.write(buffer, 0, length);
                }
                return totalBytes;
            }
        }
    }

    public static String removeLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String getLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index >= 0) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static File getValidFileOrDirectory(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean writeToFile(String encoding, File file, boolean append, String text) {
        File validFile;
        if (file == null) {
            return false;
        }
        if (!append && (validFile = FileUtil.getValidFileOrDirectory(file)) != null && file.isFile() && file.exists()) {
            validFile.delete();
            file = validFile;
        }
        if (text == null || text.length() == 0) {
            return true;
        }
        try {
            return FileUtil.writeToOutputStream(encoding, new FileOutputStream(file.toString(), append), text);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean writeToOutputStream(String encoding, OutputStream outputStream, String text) {
        try {
            OutputStreamWriter out = null;
            try {
                out = encoding != null ? new OutputStreamWriter(outputStream, encoding) : new OutputStreamWriter(outputStream);
                out.write(text);
                ((Writer)out).flush();
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static String readFromFile(String encoding, File file, boolean keepOpen) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileUtil.readFromInputStream(encoding, new FileInputStream(file), keepOpen);
    }

    public static String readFromInputStream(String encoding, InputStream inputStream, boolean keepOpen) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = null;
            isr = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (!keepOpen && inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Map getZipEntryDataByZipEntryName(String zipFileName) {
        Hashtable<String, Integer> entrySizeByEntryName = new Hashtable<String, Integer>();
        Hashtable<String, byte[]> entryDataByEntryName = new Hashtable<String, byte[]>();
        try {
            ZipEntry entry;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(zipFileName);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    entry = e.nextElement();
                    entrySizeByEntryName.put(entry.getName(), new Integer((int)entry.getSize()));
                }
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFileName)));
                entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        int size = (int)entry.getSize();
                        if (size == -1) {
                            size = (Integer)entrySizeByEntryName.get(entry.getName());
                        }
                        byte[] data = new byte[size];
                        int offset = 0;
                        int ret = 0;
                        while (size - offset > 0) {
                            ret = zipInputStream.read(data, offset, size - offset);
                            if (ret == -1) break;
                            offset += ret;
                        }
                        entryDataByEntryName.put(entry.getName(), data);
                    }
                    entry = zipInputStream.getNextEntry();
                }
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
        catch (Exception exception) {}
        return entryDataByEntryName;
    }

    public static String getFileExtension(File file) {
        if (file == null || file.isDirectory()) {
            return "";
        }
        return FileUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String file) {
        if (file == null) {
            return "";
        }
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        if (index == file.length() - 1) {
            return "";
        }
        return file.substring(index + 1);
    }

    public static boolean isParent(File parentCandidate, File fileToAnalyse) {
        if (fileToAnalyse == null || parentCandidate == null) {
            return false;
        }
        parentCandidate = parentCandidate.getAbsoluteFile();
        fileToAnalyse = fileToAnalyse.getAbsoluteFile();
        while (fileToAnalyse != null) {
            if (parentCandidate.equals(fileToAnalyse)) {
                return true;
            }
            fileToAnalyse = fileToAnalyse.getParentFile();
        }
        return false;
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static int delete(File file) {
        if (file.isFile()) {
            return file.delete() ? 1 : 0;
        }
        if (file.isDirectory()) {
            int counter = 0;
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                counter += FileUtil.delete(files[i]);
                ++i;
            }
            return counter += file.delete() ? 1 : 0;
        }
        return 0;
    }

    public static int copyFiles(File[] files, File toDirectory, boolean overwrite) throws IOException {
        if (files == null || files.length == 0 || toDirectory == null) {
            return 0;
        }
        if (toDirectory.exists()) {
            if (!toDirectory.isDirectory()) {
                return 0;
            }
        } else {
            toDirectory.mkdirs();
        }
        int copyCount = 0;
        int i = 0;
        int max = files.length;
        while (i < max) {
            block12: {
                File newFile;
                block14: {
                    block13: {
                        if (files[i] == null || !files[i].exists() || !files[i].isFile()) break block12;
                        newFile = new File(toDirectory, files[i].getName());
                        if (newFile.exists() && newFile.isFile()) break block13;
                        newFile.createNewFile();
                        break block14;
                    }
                    if (!overwrite) break block12;
                }
                FileInputStream inputStream = new FileInputStream(files[i]);
                FileOutputStream outputStream = new FileOutputStream(newFile);
                try {
                    FileUtil.streamCopy(inputStream, outputStream);
                    ++copyCount;
                }
                finally {
                    inputStream.close();
                    outputStream.close();
                }
            }
            ++i;
        }
        return copyCount;
    }
}

