/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.Stack;

public class ServiceRegistry
extends Stack {
    private static final int INITIAL_REGISTRY_SIZE = 5;
    private static final int INCREMENT_REGISTRY_SIZE = 5;
    private static ServiceRegistry registry;

    private ServiceRegistry() {
        super(5, 5);
    }

    public static synchronized ServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new ServiceRegistry();
        }
        return registry;
    }

    public synchronized IApplication[] getApplications() {
        IApplication[] applications = new IApplication[this.stack.length];
        int counter = 0;
        while (counter < this.stack.length) {
            applications[counter] = (IApplication)this.stack[counter];
            ++counter;
        }
        return applications;
    }

    public synchronized IApplication getApplicationById(int id) {
        int i = 0;
        while (i <= this.top) {
            IApplication registered = (IApplication)this.stack[i];
            if (registered.getId() == id) {
                return registered;
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean registerApplication(IApplication application) {
        if (this.getApplicationById(application.getId()) == null) {
            this.push(application);
            return true;
        }
        return false;
    }

    public synchronized boolean deregisterApplication(IApplication application) {
        int i = 0;
        while (i <= this.top) {
            IApplication registered = (IApplication)this.stack[i];
            if (registered == application) {
                this.stack[i] = this.stack[this.top--];
                return true;
            }
            ++i;
        }
        return false;
    }
}

