/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal;

import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.log.ui.internal.OpenLogAgentWizard;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.internal.dbresource.DBResourceSupportUICommon;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.PlatformUI;

public class OpenLogAgentPage
extends WizardPage
implements ModifyListener {
    protected TraceLocationUI _locationUI;
    protected Text _agentPath;
    protected Text _agentType;
    protected Text _agentName;
    protected INavigator fViewer;
    protected Combo _sign;
    protected Text _hour;
    protected Text _min;
    protected Text _sec;
    protected Text _micsec;
    protected Group deltaTime;
    protected Group connectionInfoGroup;
    protected int hourValue = 0;
    protected int minValue = 0;
    protected int secValue = 0;
    protected int micsecValue = 0;
    protected Properties connectionInfoProperties;
    protected DBResourceSupportUICommon connectionInfoUI;
    protected URI aURI;

    public OpenLogAgentPage(String name, INavigator viewer) {
        super(name);
        this.setTitle(LogMessages.LG_AGT);
        this.fViewer = viewer;
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        this.connectionInfoProperties = null;
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        gd.widthHint = 500;
        gd.heightHint = 400;
        content.setLayoutData((Object)gd);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(content);
        this._locationUI.setEnabled(false);
        Composite nameGrp = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        nameGrp.setLayout((Layout)layout);
        nameGrp.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(nameGrp, 0);
        label.setText(LogMessages.LG_TYPE);
        this._agentType = new Text(nameGrp, 2048);
        this._agentType.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._agentType.setEnabled(false);
        label = new Label(nameGrp, 0);
        label.setText(LogMessages.LG_PATH);
        this._agentPath = new Text(nameGrp, 2048);
        this._agentPath.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._agentPath.setEnabled(false);
        label = new Label(nameGrp, 0);
        label.setText(LogMessages.DISPLAY_NAME);
        this._agentName = new Text(nameGrp, 2048);
        this._agentName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime = new Group(content, 0);
        layout = new GridLayout();
        layout.numColumns = 9;
        layout.verticalSpacing = 5;
        this.deltaTime.setLayout((Layout)layout);
        this.deltaTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime.setText(LogMessages.SNCH_NDT);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(CommonUITraceMessages.DLT_TM);
        this._sign = new Combo((Composite)this.deltaTime, 2056);
        this._sign.add("+");
        this._sign.add("-");
        this._sign.select(0);
        this._hour = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 40;
        this._hour.setLayoutData((Object)gd);
        this._hour.setTextLimit(4);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._min = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._min.setLayoutData((Object)gd);
        this._min.setTextLimit(3);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._sec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._sec.setLayoutData((Object)gd);
        this._sec.setTextLimit(3);
        this._micsec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this._micsec.setLayoutData((Object)gd);
        this._micsec.setTextLimit(7);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(CommonUITraceMessages.DLT_HMS);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(CommonUITraceMessages.DLT_MIS);
        gd = new GridData();
        gd.horizontalSpan = 8;
        label.setLayoutData((Object)gd);
        this._hour.addModifyListener((ModifyListener)this);
        this._min.addModifyListener((ModifyListener)this);
        this._sec.addModifyListener((ModifyListener)this);
        this._micsec.addModifyListener((ModifyListener)this);
        TRCAgentProxy agentProxy = ((OpenLogAgentWizard)this.getWizard()).getAgent();
        if (agentProxy != null) {
            TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            this.aURI = EcoreUtil.getURI((EObject)agent);
            if (Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(this.aURI.fileExtension()) instanceof HyadesExtendedResourceFactory) {
                this.connectionInfoProperties = HyadesExtendedResourceFactory.getPropertiesFromURI((URI)this.aURI);
            }
        }
        if (this.aURI != null && this.connectionInfoProperties != null) {
            this.connectionInfoGroup = new Group(content, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            this.connectionInfoGroup.setLayout((Layout)layout);
            this.connectionInfoGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.connectionInfoGroup.setText(TraceWizardMessages.JDBC_INF);
            this.connectionInfoUI = new DBResourceSupportUICommon(){

                public void initializeValues(boolean defaultValue) {
                    if (OpenLogAgentPage.this.connectionInfoProperties != null) {
                        if (OpenLogAgentPage.this.connectionInfoProperties.getProperty("location") != null) {
                            this.location.setText(OpenLogAgentPage.this.connectionInfoProperties.getProperty("location"));
                        }
                        if (OpenLogAgentPage.this.connectionInfoProperties.getProperty("user") != null) {
                            this.username.setText(OpenLogAgentPage.this.connectionInfoProperties.getProperty("user"));
                        }
                        if (OpenLogAgentPage.this.connectionInfoProperties.getProperty("password") != null) {
                            this.password.setText(OpenLogAgentPage.this.connectionInfoProperties.getProperty("password"));
                        }
                        if (OpenLogAgentPage.this.connectionInfoProperties.getProperty("largeResourceSupportJDBCLocation") != null) {
                            this.jdbcLocation.setText(OpenLogAgentPage.this.connectionInfoProperties.getProperty("largeResourceSupportJDBCLocation"));
                        }
                        if (OpenLogAgentPage.this.connectionInfoProperties.getProperty("largeResourceSupportStoreType") != null) {
                            this.storeType.add(OpenLogAgentPage.this.connectionInfoProperties.getProperty("largeResourceSupportStoreType"));
                            this.storeType.select(0);
                        }
                    }
                    this.jdbcLocation.setEditable(false);
                    this.jdbcBrowse.setEnabled(false);
                    this.storeType.setEnabled(false);
                }

                public boolean storeValues() {
                    if (OpenLogAgentPage.this.connectionInfoProperties != null) {
                        boolean save = false;
                        if (this.location.getText() != OpenLogAgentPage.this.connectionInfoProperties.getProperty("location")) {
                            OpenLogAgentPage.this.connectionInfoProperties.setProperty("location", this.location.getText());
                            save = true;
                        }
                        if (this.username.getText() != OpenLogAgentPage.this.connectionInfoProperties.getProperty("user")) {
                            OpenLogAgentPage.this.connectionInfoProperties.setProperty("user", this.username.getText());
                            save = true;
                        }
                        if (this.password.getText() != OpenLogAgentPage.this.connectionInfoProperties.getProperty("password")) {
                            OpenLogAgentPage.this.connectionInfoProperties.setProperty("password", this.password.getText());
                            save = true;
                        }
                        if (save) {
                            HyadesExtendedResourceFactory.savePropertiesToURI((URI)OpenLogAgentPage.this.aURI, (Properties)OpenLogAgentPage.this.connectionInfoProperties);
                        }
                    }
                    return true;
                }

                protected void validateUserInput(boolean skipJDBCcheck) {
                }

                public void enableJDBCInputs() {
                }

                protected void enableJDBCTestConnection() {
                }
            };
            this.connectionInfoUI.populateGroupControl((Composite)this.connectionInfoGroup);
        }
        this.setControl((Control)content);
        this.populateData();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.tptp.platform.common.ui.trace.olap0000");
    }

    public boolean finish() {
        TRCAgentProxy agent = ((OpenLogAgentWizard)this.getWizard()).getAgent();
        if (agent != null) {
            agent.setDeltaTime(this.getDeltaTime());
            if (this.connectionInfoUI != null) {
                this.connectionInfoUI.storeValues();
            }
            String name = agent.getName();
            String agName = HyadesUtil.codeLogAgentName((String)this._agentType.getText().trim(), (String)this._agentPath.getText().trim(), (String)this._agentName.getText().trim());
            if (name != null && name.equals(agName)) {
                return true;
            }
            agent.setName(agName);
            try {
                SaveUtil.saveResource(null, (Resource)agent.eResource());
            }
            catch (Exception exc) {
                CommonPlugin.logError((Throwable)exc);
                exc.printStackTrace();
            }
            ProfileEvent profEvent = TraceUIManager.getTraceUIManager().getProfileEvent();
            profEvent.setType(4608);
            profEvent.setSource((Object)agent);
            TraceUIManager.getTraceUIManager().notifyProfileEventListener(profEvent);
        }
        return true;
    }

    public double getDeltaTime() {
        int hours = 0;
        try {
            hours = Integer.parseInt(this._hour.getText());
        }
        catch (Exception exception) {}
        int min = 0;
        try {
            min = Integer.parseInt(this._min.getText());
        }
        catch (Exception exception) {}
        int sec = 0;
        try {
            sec = Integer.parseInt(this._sec.getText());
        }
        catch (Exception exception) {}
        int micsec = 0;
        try {
            micsec = Integer.parseInt(this._micsec.getText());
        }
        catch (Exception exception) {}
        return this._sign.getText().equals("+") ? ((double)hours * 3600.0 + (double)(min * 60) + (double)sec) * 1000000.0 + (double)micsec : -(((double)hours * 3600.0 + (double)(min * 60) + (double)sec) * 1000000.0 + (double)micsec);
    }

    public void setDeltaTime(double delta) {
        try {
            int micsec = (int)(Math.abs(delta) % 1000000.0);
            double absDelta = Math.abs(delta) / 1000000.0;
            int hour = (int)(absDelta / 3600.0);
            int min = (int)(absDelta % 3600.0 / 60.0);
            int sec = (int)(absDelta % 3600.0 % 60.0);
            this.hourValue = hour;
            this.minValue = min;
            this.secValue = sec;
            this.micsecValue = micsec;
            if (delta >= 0.0) {
                this._sign.select(0);
            } else {
                this._sign.select(1);
            }
            this._hour.setText(this.hourValue == 0 ? "" : String.valueOf(this.hourValue));
            this._min.setText(this.minValue == 0 ? "" : String.valueOf(this.minValue));
            this._sec.setText(this.secValue == 0 ? "" : String.valueOf(this.secValue));
            this._micsec.setText(this.micsecValue == 0 ? "" : String.valueOf(this.micsecValue));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void populateData() {
        TRCAgentProxy agent;
        IResource sel = HyadesUtil.getSelectionFolder((INavigator)this.fViewer);
        if (sel != null) {
            this._locationUI.setLocation(sel.getFullPath().toOSString());
        }
        if ((agent = ((OpenLogAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());
        String name = agent.getName();
        if (name != null) {
            this._agentName.setText(HyadesUtil.resolveLogAgentDisplayName((String)name));
            this._agentType.setText(HyadesUtil.resolveLogAgentType((String)name));
            this._agentPath.setText(HyadesUtil.resolveLogAgentPath((String)name));
        }
        if (agent.getDeltaTime() != 0.0) {
            this.setDeltaTime(agent.getDeltaTime());
        }
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this._hour) {
            try {
                this.hourValue = Integer.parseInt(this._hour.getText().trim());
                this.setErrorMessage(null);
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._hour.getText().trim().equals("")) {
                    this.hourValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = LogMessages.INVDELT_FMT;
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        } else if (event.widget == this._min) {
            try {
                this.minValue = Integer.parseInt(this._min.getText().trim());
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._min.getText().trim().equals("")) {
                    this.minValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = LogMessages.INVDELT_FMT;
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        } else if (event.widget == this._sec) {
            try {
                this.secValue = Integer.parseInt(this._sec.getText().trim());
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._sec.getText().trim().equals("")) {
                    this.secValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = LogMessages.INVDELT_FMT;
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        } else if (event.widget == this._micsec) {
            try {
                this.micsecValue = Integer.parseInt(this._micsec.getText().trim());
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._micsec.getText().trim().equals("")) {
                    this.micsecValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = LogMessages.INVDELT_FMT;
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
    }

    protected boolean canCompletePage() {
        return this.isHourValid() && this.isMinValid() && this.isSecValid() && this.isMicsecValid();
    }

    protected boolean isHourValid() {
        String hour;
        block3: {
            hour = this._hour.getText().trim();
            try {
                this.hourValue = Integer.parseInt(hour);
            }
            catch (Exception exception) {
                if (hour.equals("")) break block3;
                this.setErrorMessage(LogMessages.INVDELT_FMT);
                return false;
            }
        }
        if (!hour.equals("") && this.hourValue < 0) {
            this.setErrorMessage(LogMessages.INVDELT_VAL);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMinValid() {
        String hour;
        block3: {
            hour = this._hour.getText().trim();
            String min = this._min.getText().trim();
            try {
                this.minValue = Integer.parseInt(min);
            }
            catch (Exception exception) {
                if (this._min.getText().trim().equals("")) break block3;
                this.setErrorMessage(LogMessages.INVDELT_FMT);
                return false;
            }
        }
        if (!(hour.equals("") || this.hourValue == 0 || this.minValue >= 0 && this.minValue < 60)) {
            this.setErrorMessage(LogMessages.INVDELT_VAL);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isSecValid() {
        String min;
        String hour;
        block3: {
            hour = this._hour.getText().trim();
            min = this._min.getText().trim();
            String sec = this._sec.getText().trim();
            try {
                this.secValue = Integer.parseInt(sec);
            }
            catch (Exception exception) {
                if (this._sec.getText().trim().equals("")) break block3;
                this.setErrorMessage(LogMessages.INVDELT_FMT);
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0) && (this.secValue < 0 || this.secValue >= 60)) {
            this.setErrorMessage(LogMessages.INVDELT_VAL);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMicsecValid() {
        String sec;
        String min;
        String hour;
        block3: {
            hour = this._hour.getText().trim();
            min = this._min.getText().trim();
            sec = this._sec.getText().trim();
            String micsec = this._micsec.getText().trim();
            try {
                this.micsecValue = Integer.parseInt(micsec);
            }
            catch (Exception exception) {
                if (this._micsec.getText().trim().equals("")) break block3;
                this.setErrorMessage(LogMessages.INVDELT_FMT);
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0 || !sec.equals("") && this.secValue != 0) && (this.micsecValue < 0 || this.micsecValue >= 1000000)) {
            this.setErrorMessage(LogMessages.INVDELT_VAL);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

