/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.util.provisional.ITraceModelInteraction;
import org.eclipse.hyades.models.util.provisional.TraceModelInteraction;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.provisional.extension.CustomContentProvider;
import org.eclipse.hyades.ui.provisional.extension.ICustomContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;

public class PDContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected static Hashtable fMonitors = new Hashtable();
    protected Object[] objList;
    protected Navigator fViewer;
    protected ICustomContentProvider[] providers;

    public PDContentProvider(Navigator viewer) {
        this.fViewer = viewer;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.providers = CustomContentProvider.getContributors();
    }

    public static void addMonitor(IResource container, TRCMonitor monitor) {
        Object monitors = fMonitors.get(container);
        if (monitors == null) {
            monitors = new ArrayList();
            ((ArrayList)monitors).add(monitor);
            fMonitors.put(container, monitors);
        } else if (!((ArrayList)monitors).contains(monitor)) {
            ((ArrayList)monitors).add(monitor);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getChildren(Object elem) {
        Object[] delegates;
        Object element = elem;
        this.objList = new Object[0];
        try {
            if (element instanceof IProject) {
                this.objList = this.getContainerMonitors((IContainer)((IProject)element));
            } else if (element instanceof IFolder) {
                this.objList = this.getContainerMonitors((IContainer)((IFolder)element));
            } else if (element instanceof TRCMonitor) {
                this.objList = this.getMonitorChildren((TRCMonitor)element);
            } else if (element instanceof TRCNode) {
                this.objList = this.getNodeProcesses((TRCNode)element);
            } else if (element instanceof TRCProcessProxy) {
                this.objList = this.getProcessAgents((TRCProcessProxy)element);
            } else if (element instanceof TRCAgentProxy) {
                this.objList = null;
            } else if (element instanceof INavigatorItem) {
                this.objList = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.objList == null) {
            this.objList = new Object[0];
        }
        if ((delegates = NavigatorExtensionUtil.getAllChildren((Object)element, (String)this.fViewer.getID()).toArray()) == null || delegates.length == 0) {
            return this.objList;
        }
        Object[] finalList = new Object[this.objList.length + delegates.length];
        System.arraycopy(this.objList, 0, finalList, 0, this.objList.length);
        System.arraycopy(delegates, 0, finalList, this.objList.length, delegates.length);
        return finalList;
    }

    public static TRCAgentProxy getAgent(String runtimeId) {
        if (runtimeId == null) {
            return null;
        }
        for (TRCMonitor monitor : PDContentProvider.getMonitors()) {
            for (TRCNode node : monitor.getNodes()) {
                if (node.eIsProxy()) continue;
                for (TRCProcessProxy process : node.getProcessProxies()) {
                    if (process.eIsProxy()) continue;
                    for (TRCAgentProxy agent : process.getAgentProxies()) {
                        if (agent.eIsProxy() || !runtimeId.equals(agent.getRuntimeId())) continue;
                        return agent;
                    }
                }
            }
        }
        return null;
    }

    protected Object[] getContainerMonitors(IContainer res) {
        return this.getContainerMonitorsArray(res).toArray();
    }

    protected ArrayList getContainerMonitorsArray(IContainer res) {
        ArrayList list = this.getContainerMonitors0(res);
        ArrayList<Object> result = new ArrayList<Object>();
        int idx = 0;
        while (idx < list.size()) {
            Object obj = list.get(idx);
            if (obj instanceof TRCMonitor) {
                TRCMonitor monitor = (TRCMonitor)obj;
                result.add(monitor);
            } else if (obj instanceof IContainer) {
                IContainer cont = (IContainer)obj;
                result.add(cont);
            } else if (obj instanceof INavigatorItem) {
                INavigatorItem navigatorItem = (INavigatorItem)obj;
                result.add(navigatorItem);
            }
            ++idx;
        }
        return result;
    }

    protected ArrayList getContainerMonitors0(IContainer res) {
        int idx;
        ArrayList<Object> childList = new ArrayList<Object>();
        if (res == null || !res.exists()) {
            return childList;
        }
        if (res instanceof IProject && !((IProject)res).isOpen()) {
            return childList;
        }
        try {
            IResource[] rmembers = res.members();
            idx = 0;
            while (idx < rmembers.length) {
                IResource member = rmembers[idx];
                if (member != null && member.exists() && member instanceof IFolder) {
                    childList.add(member);
                }
                ++idx;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object monitors = fMonitors.get(res);
        if (monitors == null) {
            try {
                IResource[] members = res.members();
                int idx2 = 0;
                while (idx2 < members.length) {
                    IResource member = members[idx2];
                    if (member != null && member.exists()) {
                        boolean isMonitor = false;
                        if (member instanceof IFile && member.getFileExtension() != null && member.getFileExtension().equals("trcmxmi")) {
                            isMonitor = true;
                            this.getMonitors(member, childList);
                        }
                        if (!isMonitor) {
                            int i = 0;
                            while (i < this.providers.length) {
                                INavigatorItem navItem;
                                ICustomContentProvider provider = this.providers[i];
                                if (provider != null && provider.isValidResource(member) && (navItem = provider.getContribution(member)) != null) {
                                    childList.add(navItem);
                                }
                                ++i;
                            }
                        }
                    }
                    ++idx2;
                }
            }
            catch (CoreException exc) {
                CommonPlugin.logError((Throwable)exc);
            }
            if (childList.size() > 0) {
                ArrayList v = new ArrayList();
                int i = 0;
                while (i < childList.size()) {
                    Object obj = childList.get(i);
                    if (obj instanceof TRCMonitor) {
                        v.add(obj);
                    }
                    ++i;
                }
                if (v.size() > 0) {
                    fMonitors.put(res, v);
                }
            }
            return childList;
        }
        idx = 0;
        while (idx < ((ArrayList)monitors).size()) {
            childList.add(((ArrayList)monitors).get(idx));
            ++idx;
        }
        if (childList == null || childList.size() == 0) {
            return new ArrayList();
        }
        return childList;
    }

    public Object[] getElements(Object elem) {
        Object element = elem;
        try {
            if (element instanceof IWorkspace) {
                this.objList = ((IWorkspace)element).getRoot().getProjects();
            } else if (element instanceof IWorkspaceRoot) {
                this.objList = ((IWorkspaceRoot)element).getProjects();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.objList == null) {
            this.objList = new Object[0];
        }
        Object[] delegates = NavigatorExtensionUtil.getAllChildren((Object)element, (String)this.fViewer.getID()).toArray();
        Object[] finalList = new Object[this.objList.length + delegates.length];
        System.arraycopy(this.objList, 0, finalList, 0, this.objList.length);
        System.arraycopy(delegates, 0, finalList, this.objList.length, delegates.length);
        return finalList;
    }

    protected Object[] getMonitorChildren(TRCMonitor monitor) {
        return this.getMonitorChildren0(monitor).toArray();
    }

    protected ArrayList getMonitorChildren0(TRCMonitor monitor) {
        ArrayList<TRCNode> list = new ArrayList<TRCNode>();
        try {
            for (TRCNode node : monitor.getNodes()) {
                if (node.eIsProxy()) continue;
                list.add(node);
            }
        }
        catch (Exception exception) {
            return list;
        }
        return list;
    }

    public static ArrayList getMonitors() {
        Enumeration list = fMonitors.elements();
        ArrayList v = new ArrayList();
        while (list.hasMoreElements()) {
            ArrayList monitors = (ArrayList)list.nextElement();
            int idx = 0;
            while (idx < monitors.size()) {
                v.add(monitors.get(idx));
                ++idx;
            }
        }
        return v;
    }

    public static ArrayList getMonitors(IContainer container) {
        Object monitors = fMonitors.get(container);
        if (monitors == null) {
            return new ArrayList();
        }
        return (ArrayList)monitors;
    }

    protected void getMonitors(IResource member, ArrayList childList) {
        ResourceSet resourceSet = TraceUIManager.getTraceUIManager().getResourceSet();
        Resource res = null;
        try {
            String monPath;
            String name = monPath = member.getFullPath().toString();
            res = resourceSet.getResource(SaveUtil.createURI((String)("platform:/resource" + name + "#")).trimFragment(), true);
            ITraceModelInteraction[] contributors = TraceModelInteraction.getContributors();
            EList ext = res.getContents();
            for (Object obj : ext) {
                if (!(obj instanceof TRCMonitor)) continue;
                childList.add(obj);
                if (contributors == null || contributors.length <= 0) continue;
                int contributor = 0;
                while (contributor < contributors.length) {
                    contributors[contributor].traceModelLoad(((TRCMonitor)obj).eResource());
                    ++contributor;
                }
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
            return;
        }
    }

    protected Object[] getNodeProcesses(TRCNode node) {
        return this.getNodeProcesses0(node).toArray();
    }

    protected ArrayList getNodeProcesses0(TRCNode node) {
        ArrayList<TRCProcessProxy> list = new ArrayList<TRCProcessProxy>();
        try {
            for (TRCProcessProxy process : node.getProcessProxies()) {
                if (process.eIsProxy()) continue;
                list.add(process);
            }
        }
        catch (Exception exception) {
            return list;
        }
        return list;
    }

    public Object getParent(Object element) {
        return null;
    }

    protected Object[] getProcessAgents(TRCProcessProxy process) {
        return this.getProcessAgents0(process).toArray();
    }

    protected ArrayList getProcessAgents0(TRCProcessProxy process) {
        ArrayList<TRCAgentProxy> list = new ArrayList<TRCAgentProxy>();
        try {
            Object[] agents = process.getAgentProxies().toArray();
            int idx = 0;
            while (idx < agents.length) {
                TRCAgentProxy agent = (TRCAgentProxy)agents[idx];
                if (!agent.eIsProxy()) {
                    list.add(agent);
                }
                ++idx;
            }
        }
        catch (Exception exception) {
            return list;
        }
        return list;
    }

    public boolean hasChildren(Object element) {
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)this.fViewer.getID())) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        return false;
    }

    public static void removeContainer(IContainer container) {
        Object list = fMonitors.get(container);
        if (list != null && list instanceof ArrayList) {
            ((ArrayList)list).clear();
        }
        fMonitors.remove(container);
    }

    protected void removeDoc(IContainer res) {
        PDContentProvider.removeContainer(res);
        try {
            DeleteUtil.deleteContainer(res, true, true, this.fViewer.getID());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeMonitor(IContainer container, TRCMonitor monitor) {
        if (container == null) {
            return;
        }
        PDContentProvider.removeMonitor(container.getFullPath().toOSString(), monitor);
    }

    public static void removeMonitor(String strPath, TRCMonitor monitor) {
        Path path = new Path(strPath);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember((IPath)path);
        if (res == null) {
            return;
        }
        Object monitors = fMonitors.get(res);
        if (monitors == null) {
            return;
        }
        ((ArrayList)monitors).remove(monitor);
    }

    public static void resetMonitors() {
        Enumeration list = fMonitors.elements();
        while (list.hasMoreElements()) {
            ArrayList monitors = (ArrayList)list.nextElement();
            monitors.clear();
        }
        fMonitors.clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1 && event.getSource() instanceof IWorkspace) {
            IResourceDelta delta = event.getDelta();
            try {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (PDContentProvider.this.fViewer != null && PDContentProvider.this.fViewer.getViewer() != null) {
                        PDContentProvider.this.fViewer.getViewer().refresh();
                    }
                }
            });
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (delta.getKind() == 2) {
                if (resource instanceof IContainer) {
                    PDContentProvider.this.removeDoc((IContainer)resource);
                }
                return true;
            }
            if (delta.getKind() == 1) {
                return false;
            }
            if (delta.getKind() == 4) {
                return true;
            }
            return true;
        }
    }
}

