/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.CommonLabelProviderDelegator;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.common.internal.util.ILabelProvider;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.util.CommonUITraceUtil;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PDLabelProvider
extends LabelProvider {
    protected Map imageTable;
    protected Image[] images = new Image[]{CommonUITraceImages.INSTANCE.getImage("monitor_obj.gif"), CommonUITraceImages.INSTANCE.getImage("node_obj.gif"), CommonUITraceImages.INSTANCE.getImage("process_obj.gif"), CommonUITraceImages.INSTANCE.getImage("agent_mon_obj.gif"), CommonUITraceImages.INSTANCE.getImage("agent_run_obj.gif"), CommonUITraceImages.INSTANCE.getImage("agent_stop_obj.gif"), CommonUITraceImages.INSTANCE.getImage("agent_detach_obj.gif")};
    protected Map processTypeImages;
    protected ILabelProvider delegator = new CommonLabelProviderDelegator(CommonUITracePlugin.getDefault().getPreferenceStore().getInt("profiling_monitor_layout"));

    public PDLabelProvider() {
        this.processTypeImages = new Hashtable();
        this.populateProcessTypeImages();
    }

    protected void populateProcessTypeImages() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.debug.ui.launchConfigurationTypeImages");
        int i = 0;
        while (i < elements.length) {
            Image image;
            String id = elements[i].getAttribute("configTypeID");
            ImageDescriptor imageDescriptor = CommonUITraceUtil.resolveImageDescriptor(elements[i], "icon");
            Image image2 = image = imageDescriptor == null ? null : imageDescriptor.createImage();
            if (id != null && image != null) {
                this.processTypeImages.put(id, image);
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.imageTable != null) {
            Iterator i = this.imageTable.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageTable = null;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IWorkbenchAdapter.class) != null) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((descriptor = adapter.getImageDescriptor(element)) != null) {
                Image image = (Image)this.imageTable.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    this.imageTable.put(descriptor, image);
                }
                return image;
            }
            return null;
        }
        if (element instanceof TRCMonitor) {
            return this.images[0];
        }
        if (element instanceof TRCNode) {
            return this.images[1];
        }
        if (element instanceof TRCProcessProxy) {
            EList variables = ((TRCProcessProxy)element).getEnvironmentVariables();
            String launchConfigurationId = null;
            int i = 0;
            int varCount = variables.size();
            while (i < varCount) {
                TRCEnvironmentVariable currentVariable = (TRCEnvironmentVariable)variables.get(i);
                if ("org.eclipse.tptp.platform.common.ui.trace.LAUNCH_CONFIGURATION_ID".equals(currentVariable.getName())) {
                    launchConfigurationId = currentVariable.getValue();
                }
                ++i;
            }
            Image image = null;
            if (launchConfigurationId != null && (image = (Image)this.processTypeImages.get(launchConfigurationId)) != null) {
                return image;
            }
            return this.images[2];
        }
        if (element instanceof TRCAgentProxy) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)element;
            if (!agentProxy.isActive()) {
                return this.images[5];
            }
            if (!agentProxy.isAttached()) {
                return this.images[6];
            }
            if (agentProxy.isMonitored()) {
                return this.images[3];
            }
            return this.images[4];
        }
        if (element instanceof INavigatorItem) {
            return ((INavigatorItem)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IWorkbenchAdapter.class) != null) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            return adapter.getLabel(element);
        }
        if (element instanceof INavigatorItem) {
            return ((INavigatorItem)element).getText();
        }
        return this.delegator.getText(element);
    }
}

