/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;

public abstract class FilterTraceViewer
extends TraceViewer
implements IFilterViewer {
    protected FilterInformationManager _fi;
    protected IFilterQueryProvider _fqp;
    protected String _contentDescription = null;
    protected boolean _internalCall = false;
    protected Action _filtersAction;
    protected String defaultFilterName;

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        super.makeActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this._fi = FilterInformationManager.instance((IFilterViewer)this);
        if (this._fi.getCurrentFilter() == null) {
            this._fi.selectedFilterName(this.defaultFilterName);
        }
        if (!tbm.isEmpty()) {
            tbm.add((IContributionItem)new Separator());
        }
        this.createFiltersAction();
        tbm.add((IAction)this._filtersAction);
    }

    public void createFiltersAction() {
        this._filtersAction = new FiltersSelectionAction(this._fi);
    }

    public void dispose() {
        if (this._fqp != null) {
            this._fqp.viewerDisposed();
        }
        this._fqp = null;
        super.dispose();
    }

    public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider) {
        this._fqp = filterQueryProvider;
    }

    public SimpleSearchQuery getCurrentFilter() {
        return this._fqp.getCurrentFilter();
    }

    public SimpleSearchQuery standardQuery() {
        return this._fqp.standardQuery();
    }

    public SimpleSearchQuery advancedQuery() {
        return this._fqp.advancedQuery();
    }

    public void updateAdvancedQuery(SimpleSearchQuery query, int advancedTabSelectionIndex) {
        this._fqp.updateAdvancedQuery(query, advancedTabSelectionIndex);
    }

    public void updateFilterAppliedDescription() {
        if (this._contentDescription == null) {
            this._contentDescription = "";
        }
        this._internalCall = true;
        this.setContentDescription(this._contentDescription);
        this._internalCall = false;
    }

    protected void setContentDescription(String description) {
        if (this._internalCall) {
            super.setContentDescription(description);
        } else {
            this._contentDescription = description;
            this.updateFilterAppliedDescription();
        }
    }

    public FilterInformationManager getFilterInformationManager() {
        return this._fi;
    }

    public void setFilterActionEnabled(boolean enabled) {
        if (this._filtersAction == null) {
            return;
        }
        this._filtersAction.setEnabled(enabled);
    }

    public boolean isFilterActionEnabled() {
        return this._filtersAction != null ? this._filtersAction.isEnabled() : false;
    }

    public void setDefaultFilterName(String name) {
        this.defaultFilterName = name;
    }

    public Action getFiltersAction() {
        return this._filtersAction;
    }

    protected void disableToolBarActions() {
        if (this._filtersAction != null) {
            this._filtersAction.setEnabled(false);
        }
        super.disableToolBarActions();
    }

    protected void enableToolBarActions() {
        if (this._filtersAction != null) {
            this._filtersAction.setEnabled(true);
        }
        super.enableToolBarActions();
    }

    public String getCurrentFilterName() {
        String filterAppliedName = this._fqp != null && this._fqp.getCurrentFilter() != null ? this._fqp.getCurrentFilter().getName() : CommonUITraceMessages.ST_FLTAPN;
        return filterAppliedName;
    }
}

