/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.actions.OpenTraceReportAction;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class TraceViewer
extends ViewPart
implements IMenuListener,
ISelectionListener,
IProfileEventListener,
IDeleteListener,
IExportViewer {
    public static final String VIEW_ID = "org.eclipse.hyades.trace.ui.TraceViewer";
    protected EObject _mofObject;
    protected boolean _initializedMenu = false;
    protected Hashtable _pages = new Hashtable();
    protected PageBook book;
    protected IPage currentPage;
    protected IPage defaultPage;
    protected ILabelProvider _labelProvider = new SimpleLayout(null).getLabelProvider();
    protected Menu fContextMenu;
    public final String GROUP_ADD_VIEWS = "open.views";
    public final String GROUP_GENERIC = "generic.action";
    public final String GROUP_ADDITIONS = "additions";
    protected OpenTraceReportAction _printColumns;
    protected boolean fRefreshView = false;
    protected boolean fForceRefresh = false;
    protected boolean contextHandlerSelectionChanged = false;
    protected boolean fPartVisible = true;
    private EObject objToShow = null;
    private boolean initialized = false;
    private boolean loadingTrace = false;
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = true;
                TraceViewer.this.handlePartVisible();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = false;
                TraceViewer.this.handlePartHidden();
            }
        }
    };
    protected int previousSelection = 0;

    public synchronized void loadingTrace() {
        this.loadingTrace = true;
    }

    public synchronized void loadingTraceDone() {
        this.loadingTrace = false;
        this.showPage(this.defaultPage);
    }

    public synchronized void addViewPage(EObject object, boolean newPage) {
        if (!this.initialized) {
            this.objToShow = object;
            return;
        }
        if (this.book == null) {
            TraceUIManager.getTraceUIManager().removeSelectionListener((ISelectionListener)this);
            return;
        }
        this._mofObject = this.getObjectToView(object);
        this.setViewTitle(this._mofObject);
        if (this._mofObject == null) {
            this.showPage(this.defaultPage);
            return;
        }
        TraceViewerPage page = this.getPage(this._mofObject);
        if (this.defaultPage == page) {
            return;
        }
        if (page == null || page.isDisposed()) {
            Enumeration pages = this._pages.elements();
            while (pages.hasMoreElements()) {
                ((IPage)pages.nextElement()).dispose();
            }
            this._pages.clear();
            this.makeActions();
            page = this.createPage(this._mofObject);
            page.createControl((Composite)this.book);
            this._pages.put(this._mofObject, page);
            newPage = true;
        }
        page.update(newPage);
        if (page.isEmpty()) {
            this.showPage(this.defaultPage);
        } else {
            if (this.fPartVisible) {
                this.handlePartVisible();
            }
            this.showPage((IPage)page);
        }
    }

    public void addViewPage(EObject object) {
        this.addViewPage(object, false);
    }

    public EObject getObjectToView(EObject selObject) {
        return selObject;
    }

    protected IPage createDefaultPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        page.createControl((Composite)book);
        page.setMessage(this.getDefaultPageMessage());
        return page;
    }

    protected IPage createLoadingPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        page.createControl((Composite)book);
        page.setMessage(CommonUITraceMessages.LOADING_DATA);
        return page;
    }

    public abstract TraceViewerPage createPage(EObject var1);

    public synchronized void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.defaultPage = this.createDefaultPage(this.book);
        TraceUIManager.getTraceUIManager().addSelectionListener((ISelectionListener)this);
        TraceUIManager.getTraceUIManager().addProfileEventListener((IProfileEventListener)this);
        TraceUIManager.getTraceUIManager().addDeleteListener((IDeleteListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.initialized = true;
        if (this.objToShow != null) {
            this.addViewPage(this.objToShow, true);
            this.objToShow = null;
        } else if (this.loadingTrace) {
            this.showPage(this.createLoadingPage(this.book));
        } else {
            this.addViewPage(HyadesUtil.getMofObject());
        }
    }

    public IPage getCurrentPage() {
        if (this.currentPage == null || !(this.currentPage instanceof TraceViewerPage)) {
            return null;
        }
        return this.currentPage;
    }

    public TraceViewerPage getPage(EObject mofObject) {
        Object page;
        if (mofObject != null && (page = this._pages.get(mofObject)) != null) {
            return (TraceViewerPage)((Object)page);
        }
        return null;
    }

    public void dispose() {
        TraceUIManager.getTraceUIManager().removeSelectionListener((ISelectionListener)this);
        TraceUIManager.getTraceUIManager().removeProfileEventListener((IProfileEventListener)this);
        TraceUIManager.getTraceUIManager().removeDeleteListener((IDeleteListener)this);
        this.getSite().getPage().removePartListener(this.fPartListener);
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            ((IPage)pages.nextElement()).dispose();
        }
        this._pages.clear();
        if (this.book != null) {
            this.book.dispose();
            this.book = null;
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
            this.currentPage = null;
        }
        if (this.defaultPage != null) {
            this.defaultPage.dispose();
            this.defaultPage = null;
        }
        this.fPartListener = null;
        super.dispose();
    }

    public void initializedMenu(boolean init) {
        this._initializedMenu = init;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return true;
    }

    public boolean isInitializedMenu() {
        return this._initializedMenu;
    }

    public boolean isSaveNeeded() {
        return false;
    }

    public void makeActions() {
        this.createReportAction();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this._printColumns);
    }

    public void createReportAction() {
        this._printColumns = new OpenTraceReportAction((IStructuredSelection)new StructuredSelection((Object)this));
    }

    protected void refreshPage(Object obj) {
        if (this._pages == null) {
            return;
        }
        if (obj != null) {
            Object page = this._pages.get(obj);
            if (page == null) {
                this.fRefreshView = true;
                return;
            }
            if (page instanceof TraceViewerPage) {
                if (!((TraceViewerPage)((Object)page)).isDisposed()) {
                    ((TraceViewerPage)((Object)page)).refreshPage();
                }
                if (((TraceViewerPage)((Object)page)).isEmpty() || ((TraceViewerPage)((Object)page)).isDisposed()) {
                    this.showPage(this.defaultPage);
                } else {
                    this.showPage((IPage)((TraceViewerPage)((Object)page)));
                }
            }
        }
    }

    protected void selectionChanged(Object obj) {
        if (obj == null) {
            return;
        }
        Object page = this._pages.get(obj);
        if (page != null && page instanceof TraceViewerPage) {
            ((TraceViewerPage)((Object)page)).selectionChanged();
        }
    }

    public void removePage(Object obj) {
        if (obj == null || !(obj instanceof EObject)) {
            return;
        }
        Object page = this._pages.get(this.getObjectToView((EObject)obj));
        this._pages.remove(obj);
        if (page != null) {
            if (page == this.currentPage) {
                this.showPage(this.defaultPage);
            }
            ((IPage)page).dispose();
        }
    }

    public void setFocus() {
    }

    public void showPage(IPage page) {
        this.book.showPage(page.getControl());
        this.currentPage = page;
        if (this.currentPage == this.defaultPage) {
            this.setViewTitle(null);
            this.disableToolBarActions();
        } else {
            this.enableToolBarActions();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fRefreshView = true;
        boolean openView = ((INavigator)part).isLinkingEnabled();
        if (!this.fPartVisible || part == null || part.getSite().getWorkbenchWindow() != this.getSite().getWorkbenchWindow()) {
            return;
        }
        if (!openView) {
            return;
        }
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj == null || !(obj instanceof EObject)) {
            return;
        }
        if (this.previousSelection != obj.hashCode()) {
            this.fRefreshView = true;
            this.previousSelection = obj.hashCode();
        } else {
            this.fRefreshView = false;
        }
        this.addViewPage((EObject)obj);
    }

    public abstract String getViewTitle();

    public void handleProfileEvent(ProfileEvent event) {
        int type = event.getType();
        if (type == 64) {
            if (!this.fPartVisible) {
                this.fRefreshView = true;
                return;
            }
            this.fRefreshView = false;
            if (event.getSource() instanceof EObject) {
                INavigator nav = HyadesUtil.getActiveNavigator();
                if (nav == null || nav.isLinkingEnabled() || this._mofObject == null) {
                    this.refreshPage(this.getObjectToView((EObject)event.getSource()));
                } else {
                    if (this._mofObject != event.getSource()) {
                        ProfileEvent newEvent = TraceUIManager.getTraceUIManager().getUpdateModelEvent((Object)this._mofObject);
                        TraceUIManager.getTraceUIManager().notifyProfileEventListener(newEvent);
                    }
                    this.refreshPage(this.getObjectToView(this._mofObject));
                }
            }
        } else if (type == 6144 && this._mofObject != null) {
            this.contextHandlerSelectionChanged = true;
            if (this.fPartVisible) {
                this.refreshPage(this.getObjectToView(this._mofObject));
                this.contextHandlerSelectionChanged = false;
            }
        }
    }

    protected void setViewTitle(Object selection) {
        if (selection != null && selection instanceof TRCAgentProxy) {
            TRCAgentProxy a = (TRCAgentProxy)selection;
            this.setContentDescription(String.valueOf(this.getViewTitle()) + " - " + this._labelProvider.getText((Object)a.getProcessProxy()));
            return;
        }
        this.setContentDescription(this.getViewTitle());
    }

    public void initializeActionBar() {
    }

    public void setRecordSelection(EObject record, EObject treeSel) {
    }

    public boolean isProcessRefreshEvents() {
        return this.fPartVisible;
    }

    protected void refreshVisiblePage() {
        EObject obj = HyadesUtil.getMofObject();
        this.addViewPage(obj);
        EObject sel = this.getObjectToView(obj);
        this.refreshPage(sel);
        this.selectionChanged(sel);
    }

    public void deregister(Object obj) {
        this.removePage(obj);
    }

    public boolean isFRefreshView() {
        return this.fRefreshView;
    }

    public void setFRefreshView(boolean refreshView) {
        this.fRefreshView = refreshView;
    }

    public boolean isFPartVisible() {
        return this.fPartVisible;
    }

    public void setFPartVisible(boolean partVisible) {
        this.fPartVisible = partVisible;
    }

    public Object[] getViewerControls() {
        return null;
    }

    public String getViewerTitle() {
        return this.getContentDescription();
    }

    public Viewer[] getExportViewer() {
        return null;
    }

    public boolean contextHandlerSelectionChanged() {
        return this.contextHandlerSelectionChanged;
    }

    public Object getModelObject() {
        if (this.currentPage == null || !(this.currentPage instanceof TraceViewerPage)) {
            return null;
        }
        return ((TraceViewerPage)this.currentPage).getMOFObject();
    }

    public String getDefaultPageMessage() {
        return CommonUITraceMessages.NODATA;
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof TraceViewerPage) {
            ((TraceViewerPage)this.getCurrentPage()).fillContextMenu(menu);
        }
        menu.add((IContributionItem)new Separator("open.views"));
        menu.add((IContributionItem)new Separator("generic.action"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    public IPage getDefaultPage() {
        return this.defaultPage;
    }

    protected void disableToolBarActions() {
        if (this._printColumns != null) {
            this._printColumns.setEnabled(false);
        }
    }

    protected void enableToolBarActions() {
        if (this._printColumns != null) {
            this._printColumns.setEnabled(true);
        }
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public static EObject getObjectToView_(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    protected void handlePartVisible() {
        if (this.fRefreshView) {
            this.fRefreshView = false;
            INavigator navigator = HyadesUtil.getActiveNavigator();
            if (navigator != null && navigator.isLinkingEnabled()) {
                this.fForceRefresh = false;
                this.refreshVisiblePage();
            }
        }
        if (this.fForceRefresh) {
            this.fForceRefresh = false;
            if (this._mofObject != null) {
                this.refreshPage(this.getObjectToView(this._mofObject));
            }
        }
        if (this.contextHandlerSelectionChanged) {
            if (this._mofObject != null) {
                this.refreshPage(this.getObjectToView(this._mofObject));
            }
            this.contextHandlerSelectionChanged = false;
        }
        this.propagateVisible();
    }

    protected void handlePartHidden() {
        this.propagateHidden();
    }

    protected void propagateVisible() {
        TraceViewerPage page = this.getPage(this._mofObject);
        if (page != null) {
            page.setVisible();
        }
    }

    protected void propagateHidden() {
        TraceViewerPage page = this.getPage(this._mofObject);
        if (page != null) {
            page.setHidden();
        }
    }
}

