/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractProfileActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
ISelectionListener {
    protected IAction fAction;
    protected IViewPart fViewPart;
    protected IStructuredSelection fSelection;
    protected boolean fInitialized = false;

    public void dispose() {
        CommonUITracePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
        this.fAction = null;
        this.fViewPart = null;
        this.fSelection = null;
    }

    public void init(IWorkbenchWindow window) {
        window.getSelectionService().addSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        for (Object element : selection) {
            try {
                this.doAction(element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean wasInitialized = this.initialize(action, s);
        if (!wasInitialized && this.getView() != null) {
            this.update(action, s);
        }
    }

    protected void update(IAction action, ISelection s) {
        if (action == null || s == null) {
            return;
        }
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            action.setEnabled(this.getEnableStateForSelection(ss));
            this.setSelection(ss);
        } else {
            action.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator enum1 = selection.iterator();
        int count = 0;
        while (enum1.hasNext()) {
            if (++count > 1 && !this.enableForMultiSelection()) {
                return false;
            }
            Object element = enum1.next();
            if (this.isEnabledFor(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean enableForMultiSelection() {
        return true;
    }

    protected abstract void doAction(Object var1) throws Exception;

    protected abstract boolean isEnabledFor(Object var1);

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            this.setAction(action);
            this.update(action, selection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(this.getAction(), selection);
    }

    protected void setView(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }
}

