/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class DeleteAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    protected INavigator fViewer;
    protected ArrayList deletedPaths = new ArrayList();
    public static final String SD_FILE_EXTENSION = "trcdbxmi";
    public static final String SYMPTOM_FILE_EXTENSION = "symptom";

    public DeleteAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), CommonUITraceMessages.DEL);
        this.setDescription(CommonUITraceMessages.DEL_R);
        this.setToolTipText(CommonUITraceMessages.DEL_OTIP);
        ISharedImages images = CommonUITracePlugin.getDefault().getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.tptp.platform.common.ui.trace.delt0000");
        this.fViewer = viewer;
    }

    public void run() {
        final IStructuredSelection fSelections = (IStructuredSelection)this.fViewer.getViewer().getSelection();
        if (fSelections == null || fSelections.size() == 0) {
            return;
        }
        for (Object sel : fSelections) {
            if (this.validForDelete(sel)) continue;
            return;
        }
        String workspaceLocation = Platform.getLocation().toString();
        String selectedItem = null;
        String fullPath = null;
        boolean showDeleteFileContentDialog = true;
        boolean LogDeleteDialog = true;
        boolean isSymptomCatalogResourceIncluded = false;
        boolean isOnlyDeletingSymptomCatalogResource = true;
        block1: for (Object sel : fSelections) {
            if (sel != null && sel instanceof EObject) {
                isOnlyDeletingSymptomCatalogResource = false;
                Vector<String> agentTypeList = new Vector<String>();
                if (sel instanceof TRCMonitor) {
                    HyadesUtil.getAgentType((TRCMonitor)((TRCMonitor)sel), agentTypeList);
                } else if (sel instanceof TRCNode) {
                    HyadesUtil.getAgentType((TRCNode)((TRCNode)sel), agentTypeList);
                } else if (sel instanceof TRCProcessProxy) {
                    HyadesUtil.getAgentType((TRCProcessProxy)((TRCProcessProxy)sel), agentTypeList);
                } else if (sel instanceof TRCAgentProxy) {
                    agentTypeList.add(HyadesUtil.getAgentType((TRCAgentProxy)((TRCAgentProxy)sel)));
                }
                if (agentTypeList.size() == 0) {
                    LogDeleteDialog = false;
                }
                int agentTypeIndex = 0;
                while (agentTypeIndex < agentTypeList.size()) {
                    String agentType = (String)agentTypeList.get(agentTypeIndex);
                    if (agentType == null || !agentType.equalsIgnoreCase("Logging")) {
                        LogDeleteDialog = false;
                        continue block1;
                    }
                    ++agentTypeIndex;
                }
                continue;
            }
            if (sel != null && sel instanceof IFile) {
                IFile file = (IFile)sel;
                String ext = file.getFileExtension();
                if (ext != null) {
                    if (ext.equals(SD_FILE_EXTENSION) || ext.equals(SYMPTOM_FILE_EXTENSION)) {
                        isSymptomCatalogResourceIncluded = true;
                        continue;
                    }
                    isOnlyDeletingSymptomCatalogResource = false;
                    continue;
                }
                isOnlyDeletingSymptomCatalogResource = false;
                continue;
            }
            isOnlyDeletingSymptomCatalogResource = false;
        }
        if (!LogDeleteDialog) {
            for (Object sel : fSelections) {
                if (sel != null) {
                    if (sel instanceof IResource) {
                        fullPath = ((IResource)sel).getLocation().toString();
                    } else if (sel instanceof EObject) {
                        selectedItem = ((EObject)sel).eResource().getURI().toString();
                        fullPath = String.valueOf(workspaceLocation) + selectedItem.substring(selectedItem.indexOf(":/resource") + ":/resource".length());
                        if (!new File(fullPath).exists()) {
                            if (sel instanceof TRCMonitor && this.areThereFilesOnDisk((TRCMonitor)sel)) {
                                showDeleteFileContentDialog = true;
                                break;
                            }
                            if (sel instanceof TRCNode && this.areThereFilesOnDisk(((TRCNode)sel).getMonitor())) {
                                showDeleteFileContentDialog = true;
                                break;
                            }
                            if (sel instanceof TRCProcessProxy && this.areThereFilesOnDisk(((TRCProcessProxy)sel).getNode().getMonitor())) {
                                showDeleteFileContentDialog = true;
                                break;
                            }
                            if (sel instanceof TRCAgentProxy && this.isAgentSavedOnDisk((TRCAgentProxy)sel)) {
                                showDeleteFileContentDialog = true;
                                break;
                            }
                            if (sel instanceof CorrelationContainerProxy && this.areThereFilesOnDisk(((CorrelationContainerProxy)sel).getMonitor())) {
                                showDeleteFileContentDialog = true;
                                break;
                            }
                        }
                    }
                }
                if (fullPath != null) {
                    showDeleteFileContentDialog = new File(fullPath).exists();
                }
                if (showDeleteFileContentDialog) break;
            }
        }
        boolean deleteContents = false;
        if (LogDeleteDialog) {
            String message = null;
            message = isSymptomCatalogResourceIncluded ? (isOnlyDeletingSymptomCatalogResource ? CommonUITraceMessages.CONFIRM_SYMPTOMCATALOG_DEL : CommonUITraceMessages.CONFIRM_DELM) : CommonUITraceMessages.CONFIRM_LOG_DEL;
            ConfirmDeletionDialog confirmDeletionDialog = new ConfirmDeletionDialog(this.fViewer.getViewSite().getShell(), CommonUITraceMessages.DEL_TITLE, message);
            if (confirmDeletionDialog.open() != 0) {
                return;
            }
            deleteContents = true;
        } else if (showDeleteFileContentDialog) {
            DeleteResourceDialog dlg = new DeleteResourceDialog(this.fViewer.getViewSite().getShell());
            if (dlg.open() != 0) {
                return;
            }
            deleteContents = dlg.getDeleteContent();
        } else {
            ConfirmDeletionDialog confirmDeletionDialog = new ConfirmDeletionDialog(this.fViewer.getViewSite().getShell(), CommonUITraceMessages.DEL_TITLE, CommonUITraceMessages.CONFIRM_DELM);
            if (confirmDeletionDialog.open() != 0) {
                return;
            }
        }
        final boolean fdeleteContents = deleteContents;
        Runnable refreshRunnable = new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        DeleteAction.this.runDeleteTask(fSelections, fdeleteContents);
                    }
                });
            }
        };
        Display.getDefault().asyncExec(refreshRunnable);
        ProfileEvent event = new ProfileEvent();
        event.setSource(null);
        event.setType(4096);
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
        event = TraceUIManager.getTraceUIManager().getProfileEvent();
        if (event == null) {
            event = new ProfileEvent();
        }
        event.setSource(null);
        event.setType(128);
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
    }

    protected boolean areThereFilesOnDisk(TRCMonitor monitor) {
        if (monitor == null) {
            return false;
        }
        for (TRCNode node : monitor.getNodes()) {
            for (TRCProcessProxy process : node.getProcessProxies()) {
                for (TRCAgentProxy agent : process.getAgentProxies()) {
                    if (!this.isAgentSavedOnDisk(agent)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isAgentSavedOnDisk(TRCAgentProxy agentProxy) {
        try {
            String workspaceLocation = Platform.getLocation().toString();
            String agentPath = agentProxy.getAgent().eResource().getURI().toString();
            String fullPath = String.valueOf(workspaceLocation) + agentPath.substring(agentPath.indexOf(":/resource") + ":/resource".length());
            return new File(fullPath).exists();
        }
        catch (Exception e) {
            if (ModelDebugger.INSTANCE.debug) {
                ModelDebugger.log((Throwable)e);
            }
            return false;
        }
    }

    protected boolean containsPath(IPath innerPath) {
        for (IPath path : this.deletedPaths) {
            if (!path.isPrefixOf(innerPath)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkContainer(IContainer container, int deep) {
        if (deep == 0) return true;
        if (deep != -1) {
            --deep;
        }
        try {
            IResource[] resources = container.members();
            int j = 0;
            while (true) {
                if (j >= resources.length) {
                    return true;
                }
                if (resources[j] instanceof IContainer && !this.checkContainer((IContainer)resources[j], deep)) {
                    return false;
                }
                ++j;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean validForDelete(Object sel) {
        if (sel != null) {
            if (sel instanceof IContainer) {
                return this.checkContainer((IContainer)sel, -1);
            }
            return !(sel instanceof TRCAgentProxy ? !this.checkAgentState((TRCAgentProxy)sel) : (sel instanceof TRCProcessProxy ? !this.checkAgentsState(((TRCProcessProxy)sel).getAgentProxies()) : (sel instanceof TRCNode ? !this.checkAgentsState(((TRCNode)sel).getProcessProxies()) : sel instanceof TRCMonitor && !this.checkAgentsState(((TRCMonitor)sel).getNodes()))));
        }
        return true;
    }

    protected boolean checkAgentsState(EList eList) {
        for (Object temp : eList) {
            TRCAgentProxy agent;
            if (!(temp instanceof TRCAgentProxy ? !(agent = (TRCAgentProxy)temp).eIsProxy() && !this.checkAgentState(agent) : (temp instanceof TRCProcessProxy ? !this.validForDelete(temp) : temp instanceof TRCNode && !this.validForDelete(temp)))) continue;
            return false;
        }
        return true;
    }

    protected boolean checkAgentState(TRCAgentProxy a) {
        if (a.isActive() && (a.isAttached() || a.isMonitored()) || a.isCollectionData()) {
            this.treatActiveAgentWhenDelete(a);
            return false;
        }
        return true;
    }

    protected void treatActiveAgentWhenDelete(TRCAgentProxy a) {
        final Shell shell = Display.getDefault().getActiveShell();
        if (shell != null) {
            final Status err = new Status(2, "org.eclipse.core.resources", 566, NLS.bind((String)CommonUITraceMessages.DELAG_ERR, (Object)a.getName()), null);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)CommonUITraceMessages.TRC_MSGT, (String)CommonUITraceMessages.DELF_ERRT, (IStatus)err);
                }
            });
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        if (this.deletedPaths != null) {
            this.deletedPaths.clear();
        }
        this.deletedPaths = null;
    }

    protected void runDeleteTask(IStructuredSelection fSelections, boolean deleteContents) {
        this.deletedPaths.clear();
        DeleteUtil.setDeleteInProgress(true);
        try {
            for (Object sel : fSelections) {
                if (sel == null) continue;
                if (sel instanceof IResource) {
                    if (this.containsPath(((IResource)sel).getFullPath())) continue;
                    DeleteUtil.deleteResource((IResource)sel, deleteContents, deleteContents, this.fViewer.getID());
                    this.deletedPaths.add(((IResource)sel).getFullPath());
                    continue;
                }
                if (sel instanceof TRCMonitor) {
                    DeleteUtil.deleteMonitor((TRCMonitor)sel, true, deleteContents, deleteContents, this.fViewer.getID());
                    TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)((TRCMonitor)sel));
                    continue;
                }
                if (sel instanceof TRCNode) {
                    DeleteUtil.deleteNode((TRCNode)sel, true, deleteContents, deleteContents, this.fViewer.getID());
                    TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)((TRCNode)sel));
                    continue;
                }
                if (sel instanceof TRCAgentProxy) {
                    DeleteUtil.deleteAgent((TRCAgentProxy)sel, true, deleteContents, deleteContents, this.fViewer.getID());
                    TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)((TRCAgentProxy)sel));
                    continue;
                }
                if (sel instanceof TRCProcessProxy) {
                    DeleteUtil.deleteProcess((TRCProcessProxy)sel, true, deleteContents, deleteContents, this.fViewer.getID());
                    TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)((TRCProcessProxy)sel));
                    continue;
                }
                if (sel instanceof CorrelationContainerProxy) {
                    DeleteUtil.deleteCorrelationContainer((CorrelationContainerProxy)sel, true, deleteContents, deleteContents, this.fViewer.getID());
                    TraceUIManager.getTraceUIManager().removeSelectionModel((EObject)((CorrelationContainerProxy)sel));
                    continue;
                }
                if (!(sel instanceof INavigatorItem)) continue;
                ((INavigatorItem)sel).delete(true, deleteContents);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeleteUtil.setDeleteInProgress(false);
        fSelections = null;
        this.deletedPaths.clear();
    }

    class ConfirmDeletionDialog
    extends MessageDialog {
        ConfirmDeletionDialog(Shell parentShell, String title, String message) {
            super(parentShell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            return composite;
        }
    }

    class DeleteResourceDialog
    extends MessageDialog {
        protected boolean deleteContent;
        protected Button radio1;
        protected Button radio2;
        protected SelectionListener selectionListener;

        DeleteResourceDialog(Shell parentShell) {
            super(parentShell, CommonUITraceMessages.DEL_TITLE, null, CommonUITraceMessages.CONFIRM_DELM, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.deleteContent = false;
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    if (button.getSelection()) {
                        DeleteResourceDialog.this.deleteContent = button == DeleteResourceDialog.this.radio1;
                    }
                }
            };
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = CommonUITraceMessages.DEL_RSP;
            this.radio1.setText(text1);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = CommonUITraceMessages.NDEL_RSP;
            this.radio2.setText(text2);
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }
    }
}

