/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.internal.actions.CreateOrEditFilter;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

public class ImportFilterUI
implements SelectionListener,
ModifyListener {
    protected Label _filterLabel;
    protected Button _editFilterButton;
    protected Button _newFilterButton;
    protected Combo _filterListCombo;
    protected Label _filterContextLabel;
    protected Combo _filterContextCombo;
    protected String _scope;
    protected FilterInformationManager _fi;

    public ImportFilterUI(String scope) {
        this._scope = scope;
        this._fi = FilterInformationManager.instance((String)this._scope);
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        result.setLayoutData((Object)data);
        Label desc = new Label(result, 64);
        desc.setText(CommonUITraceMessages.FILUI_DL);
        new Label(result, 0);
        this._filterLabel = new Label(result, 0);
        this._filterLabel.setText(CommonUITraceMessages.SEL_FILL);
        this._filterListCombo = new Combo(result, 2048);
        this._filterListCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterListCombo.addModifyListener((ModifyListener)this);
        IContextLanguage[] clangs = ContextManager.getContextLanguages();
        if (clangs != null && clangs.length > 1) {
            this.createContextArea(clangs, result);
        }
        Composite buttonGroup = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(128));
        this._newFilterButton = new Button(buttonGroup, 0);
        this._newFilterButton.setText(CommonUITraceMessages.NEWF_BTN);
        this._editFilterButton = new Button(buttonGroup, 0);
        this._editFilterButton.setText(CommonUITraceMessages.EDF_BTN);
        this._newFilterButton.addSelectionListener((SelectionListener)this);
        this._editFilterButton.addSelectionListener((SelectionListener)this);
        this.initialize();
        return result;
    }

    protected void createContextArea(IContextLanguage[] clangs, Composite parent) {
        final IContextLanguage[] langs = clangs;
        this._filterContextLabel = new Label(parent, 0);
        this._filterContextLabel.setText("Select the context to be used in filter dialog");
        this._filterContextCombo = new Combo(parent, 8);
        this._filterContextCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterContextCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (langs != null && langs.length > 0) {
                    CommonUITracePlugin.getDefault().getPreferenceStore().setValue("trace_import_filter_context", langs[ImportFilterUI.this._filterContextCombo.getSelectionIndex()].contextKey());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._filterContextCombo.removeAll();
        String selectedContext = CommonUITracePlugin.getDefault().getPreferenceStore().getString("trace_import_filter_context");
        int selectedIndex = -1;
        int i = 0;
        while (i < clangs.length) {
            IContextLanguage language = clangs[i];
            if (language != null) {
                this._filterContextCombo.add(language.name());
                if (selectedContext != null && selectedContext != null && selectedContext.equals(language.contextKey())) {
                    selectedIndex = i;
                }
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            this._filterContextCombo.select(selectedIndex);
        }
    }

    public void initialize() {
        this._filterListCombo.removeAll();
        this._filterListCombo.add(CommonUITraceMessages.NOF_LBL);
        Object[] filters = this._fi.getFiltersArray();
        int i = 0;
        while (i < filters.length) {
            this._filterListCombo.add(((FilterQueries)filters[i]).name());
            ++i;
        }
        this._filterListCombo.setFocus();
        this.setSelectedFilterName(this._fi.selectedFilterName());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this._scope != null) {
            this._fi = FilterInformationManager.instance((String)this._scope);
            if (e.widget == this._newFilterButton) {
                CreateOrEditFilter.run((FilterInformationManager)this._fi, null);
            } else if (e.widget == this._editFilterButton) {
                CreateOrEditFilter.run((FilterInformationManager)this._fi);
            }
            this.initialize();
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this._filterListCombo) {
            if (this._filterListCombo.getText().equals(CommonUITraceMessages.NOF_LBL)) {
                this._editFilterButton.setEnabled(false);
                this._fi.selectedFilterName(null);
            } else {
                this._editFilterButton.setEnabled(true);
                if (this._fi.filter(this._filterListCombo.getText().trim()) != null) {
                    this._fi.selectedFilterName(this._filterListCombo.getText().trim());
                }
            }
        }
    }

    public void setSelectedFilter(String selectedFilterName, String selectedFilterType) {
        if (selectedFilterName != null) {
            FilterQueries fq = this._fi.filter(selectedFilterName);
            if (fq != null && fq.type().equals(selectedFilterType)) {
                this._fi.selectedFilterName(selectedFilterName);
            } else {
                this._fi.selectedFilterName(null);
            }
        } else {
            this._fi.selectedFilterName(null);
        }
        this.setSelectedFilterName(this._fi.selectedFilterName());
    }

    public String getSelectedFilterName() {
        return this._fi.selectedFilterName();
    }

    public String getSelectedFilterType() {
        return this._fi.selectedFilter().type();
    }

    public SimpleSearchQuery getSelectedFilter() {
        return this._fi.getCurrentFilter();
    }

    protected void setSelectedFilterName(String filterName) {
        if (filterName != null) {
            this._filterListCombo.setText(filterName);
        } else {
            this._filterListCombo.setText(CommonUITraceMessages.NOF_LBL);
        }
    }
}

