/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.internal.preferences.ACPrefMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ACPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener,
SelectionListener {
    private Text _localPort;
    private Button _firewallBtn;
    private Composite portComp;
    private Label firewallDesc;
    private Button randomPort;
    private Button customPort;
    private Text portText;
    private Label acStatus;

    public Composite createControls(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridUtil.createFill());
        Group acStatusGroup = new Group(content, 0);
        acStatusGroup.setText(ACPrefMessages._12);
        layout = new GridLayout();
        layout.numColumns = 1;
        acStatusGroup.setLayout((Layout)layout);
        acStatusGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.acStatus = new Label((Composite)acStatusGroup, 0);
        this.acStatus.setText(this.getIACStatus());
        final Display controlDisplay = content.getDisplay();
        controlDisplay.timerExec(0, new Runnable(){

            public void run() {
                try {
                    ACPreferencePage.this.acStatus.setText(ACPreferencePage.this.getIACStatus());
                    controlDisplay.timerExec(5000, (Runnable)this);
                }
                catch (SWTException sWTException) {}
            }
        });
        Group profilingInfo = new Group(content, 0);
        profilingInfo.setText(ACPrefMessages._1);
        layout = new GridLayout();
        layout.numColumns = 2;
        profilingInfo.setLayout((Layout)layout);
        profilingInfo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label portdesc = new Label((Composite)profilingInfo, 0);
        portdesc.setText(ACPrefMessages._2);
        this._localPort = new Text((Composite)profilingInfo, 2048);
        GridData data = GridUtil.createHorizontalFill();
        this._localPort.setLayoutData((Object)data);
        this._localPort.addModifyListener((ModifyListener)this);
        Group portGrp = new Group(content, 0);
        portGrp.setText(ACPrefMessages._11);
        layout = new GridLayout();
        layout.numColumns = 1;
        portGrp.setLayout((Layout)layout);
        portGrp.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._firewallBtn = new Button((Composite)portGrp, 32);
        this._firewallBtn.setText(ACPrefMessages._6);
        this._firewallBtn.addSelectionListener((SelectionListener)this);
        this.portComp = new Composite((Composite)portGrp, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 5;
        this.portComp.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.portComp.setLayout((Layout)layout);
        this.firewallDesc = new Label(this.portComp, 0);
        this.firewallDesc.setText(ACPrefMessages._10);
        data = new GridData();
        data.horizontalSpan = 2;
        this.firewallDesc.setLayoutData((Object)data);
        this.randomPort = new Button(this.portComp, 16);
        this.randomPort.setText(ACPrefMessages._7);
        data = new GridData();
        data.horizontalSpan = 2;
        this.randomPort.setLayoutData((Object)data);
        this.randomPort.addSelectionListener((SelectionListener)this);
        this.customPort = new Button(this.portComp, 16);
        this.customPort.setText(ACPrefMessages._8);
        this.customPort.addSelectionListener((SelectionListener)this);
        this.portText = new Text(this.portComp, 2048);
        data = new GridData(4, -1, true, false);
        this.portText.setLayoutData((Object)data);
        this.portText.addModifyListener((ModifyListener)this);
        Label note = new Label(this.portComp, 0);
        note.setText(ACPrefMessages._9);
        data = new GridData();
        data.horizontalSpan = 2;
        note.setLayoutData((Object)data);
        this.initializeValues();
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    private void enablePortComp(boolean enabled) {
        this.firewallDesc.setEnabled(enabled);
        this.randomPort.setEnabled(enabled);
        this.customPort.setEnabled(enabled);
        this.portText.setEnabled(this.customPort.getSelection());
    }

    private void initializeValues() {
        IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
        this.setLocalHostPort(store.getString("localhost_port"));
        store = AdminPlugin.getDefault().getPreferenceStore();
        this._firewallBtn.setSelection(store.getBoolean("datapool_port_enabled"));
        this.portText.setText(store.getString("datapool_port_number"));
        this.randomPort.setSelection(store.getBoolean("datapool_port_random"));
        this.customPort.setSelection(!store.getBoolean("datapool_port_random"));
        this.enablePortComp(this._firewallBtn.getSelection());
        this.valideInput();
    }

    public String getLocalPortNumber() {
        return this._localPort.getText().trim();
    }

    public void setLocalHostPort(String portNum) {
        this._localPort.setText(portNum);
    }

    public void modifyText(ModifyEvent e) {
        this.valideInput();
    }

    public void valideInput() {
        this.validateLocalPort();
        if (this.getErrorMessage() == null && this._firewallBtn.getSelection() && this.customPort.getSelection()) {
            this.validateFirewallPort();
        }
    }

    public void validateLocalPort() {
        try {
            if (this._localPort.getText().trim() == "") {
                this.setErrorMessage(ACPrefMessages._3);
                this.setValid(false);
                return;
            }
            int value = Integer.parseInt(this._localPort.getText().trim());
            if (value < 0) {
                this.setErrorMessage(ACPrefMessages._4);
                this.setValid(false);
                this._localPort.setFocus();
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }
        catch (NumberFormatException numberFormatException) {
            if (this != null) {
                this.setErrorMessage(ACPrefMessages._4);
            }
            this.setValid(false);
        }
    }

    public void validateFirewallPort() {
        try {
            if (this.portText.getText().trim() == "") {
                if (!this.customPort.getSelection()) {
                    this.setErrorMessage(null);
                    this.setValid(true);
                } else {
                    this.setErrorMessage(ACPrefMessages._5);
                    this.setValid(false);
                }
                return;
            }
            int value = Integer.parseInt(this.portText.getText().trim());
            if (value < 0) {
                this.setErrorMessage(ACPrefMessages._5);
                this.setValid(false);
                this.portText.setFocus();
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }
        catch (NumberFormatException numberFormatException) {
            if (this != null) {
                this.setErrorMessage(ACPrefMessages._5);
            }
            this.setValid(false);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.tptp.platform.common.ui.trace.fwps0000");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        this.createControls(comp);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private void initializeDefaults() {
        IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
        this.setLocalHostPort(store.getDefaultString("localhost_port"));
        store = AdminPlugin.getDefault().getPreferenceStore();
        this._firewallBtn.setSelection(store.getDefaultBoolean("datapool_port_enabled"));
        this.portText.setText(store.getDefaultString("datapool_port_number"));
        this.randomPort.setSelection(store.getDefaultBoolean("datapool_port_random"));
        this.customPort.setSelection(!store.getDefaultBoolean("datapool_port_random"));
        this.enablePortComp(this._firewallBtn.getSelection());
    }

    protected void performDefaults() {
        this.initializeDefaults();
        this.valideInput();
    }

    public boolean performOk() {
        this.storeValues();
        CommonUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
        store.setValue("localhost_port", this.getLocalPortNumber());
        store = AdminPlugin.getDefault().getPreferenceStore();
        store.setValue("datapool_port_enabled", this._firewallBtn.getSelection());
        store.setValue("datapool_port_number", this.portText.getText().trim());
        store.setValue("datapool_port_random", this.randomPort.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._firewallBtn) {
            this.enablePortComp(this._firewallBtn.getSelection());
        } else if (event.widget == this.randomPort) {
            this.portText.setEnabled(!this.randomPort.getSelection());
        } else if (event.widget == this.customPort) {
            this.portText.setEnabled(this.customPort.getSelection());
        }
        this.valideInput();
    }

    private String getIACStatus() {
        return AutoStartStop.isIACRunning() ? ACPrefMessages._13 : ACPrefMessages._14;
    }
}

