/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HostPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected TraceHostUI _options;

    public HostPreferencePage() {
        this.setPreferenceStore(CommonUITracePlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setText(SecurityMessages._81);
    }

    protected void addHosts(String hosts) {
        if (hosts != null && !hosts.equals("")) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this._options.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this._options.addHost(hosts);
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.tptp.platform.common.ui.trace.hstp0000");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._options = new TraceHostUI();
        this._options.createControl(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CommonUITracePlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initializeDefaults() {
        IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();
        this._options.reset();
        String hosts = store.getDefaultString("use_host");
        this.addHosts(hosts);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        CommonUITracePlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void storeValues() {
        IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();
        String hosts = "";
        TableItem[] items = this._options.getHosts();
        int idx = 0;
        while (idx < items.length) {
            hosts = String.valueOf(hosts) + "," + items[idx].getText().trim();
            ++idx;
        }
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue("use_host", hosts);
    }
}

