/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.ui.IPropertyListener;

public class TraceAssociationMapping
implements IPropertyListener {
    protected Map typeClassMap;
    protected static TraceAssociationMapping inst;

    protected TraceAssociationMapping() {
        if (this.typeClassMap == null) {
            this.typeClassMap = new HashMap();
        }
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
    }

    public static TraceAssociationMapping getDefault() {
        if (inst == null) {
            inst = new TraceAssociationMapping();
        }
        return inst;
    }

    public Object[] getClassForTypeUnsorted(String type) {
        Object mapp = this.typeClassMap.get(type);
        if (mapp != null) {
            return (Object[])mapp;
        }
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            Object[] viewIDs = new Object[]{};
            this.typeClassMap.put(type, viewIDs);
            return viewIDs;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(type);
        Object[] viewIDs = new Object[array.length];
        int idx = 0;
        while (idx < array.length) {
            IAssociationDescriptor desc = array[idx];
            try {
                Object implClass = desc.createImplementationClassInstance();
                if (implClass != null) {
                    viewIDs[idx] = implClass;
                    if (!(implClass instanceof OpenAssociatedTraceViewAction)) {
                        Status status = new Status(1, "org.eclipse.tptp.platform.common.ui.trace", 0, String.valueOf(implClass.getClass().getName()) + " should extend OpenAssociatedTraceViewAction", null);
                        CommonPlugin.logError((IStatus)status);
                        System.out.println(String.valueOf(implClass.getClass().getName()) + " should extend OpenAssociatedTraceViewAction");
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++idx;
        }
        this.typeClassMap.put(type, viewIDs);
        return viewIDs;
    }

    public boolean isViewForType(String viewID, String type) {
        Object[] viewIDs = this.getClassForTypeUnsorted(type);
        int i = 0;
        while (i < viewIDs.length) {
            Object implClass = viewIDs[i];
            if (implClass instanceof OpenAssociatedTraceViewAction && ((OpenAssociatedTraceViewAction)implClass).getViewID().equals(viewID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.typeClassMap != null) {
            this.typeClassMap.clear();
        }
    }

    public void dispose() {
        this.clear();
        this.typeClassMap = null;
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof IAssociationMappingRegistry) {
            this.clear();
        }
    }
}

