/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.trace.internal.util;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.ui.PlatformUI;

public class PDCoreUtil {
    public static final byte PI_MODE_CONTROLLED = 1;
    public static final byte PI_MODE_APPLICATION = 2;
    public static final byte PI_MODE_STANDALONE = 3;
    public static final byte PI_MODE_ENABLED = 4;

    public static void activate(TRCAgentProxy agentProxy) {
        for (TRCAgentProxy element : agentProxy.getProcessProxy().getAgentProxies()) {
            try {
                if (!agentProxy.getName().equals(element.getName()) || !agentProxy.getType().equals(element.getType())) continue;
                element.setActive(false);
                element.setAttached(false);
            }
            catch (NullPointerException nullPointerException) {}
        }
        agentProxy.setActive(true);
        agentProxy.setAttached(true);
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy process, Agent a) {
        TRCAgentProxy agentProxy = PDCoreUtil.createAgent(process, a, "");
        return agentProxy;
    }

    public static TRCAgentProxy getCorrespondingAgent(TRCProcessProxy processProxy, Agent ag, boolean activeProxy) {
        for (TRCAgentProxy agentProxy : processProxy.getAgentProxies()) {
            if (agentProxy.eIsProxy() || agentProxy == null || !agentProxy.getName().equals(ag.getName()) || agentProxy.getRuntimeId() != null && !agentProxy.getRuntimeId().equals(ag.getUUID()) || agentProxy.isActive() != activeProxy) continue;
            return agentProxy;
        }
        return null;
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy processProxy, Agent agent, String sessionId) {
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(processProxy, agent, false);
        if (agentProxy != null) {
            return agentProxy;
        }
        return PDCoreUtil.createAgentNoCheck(processProxy, agent, sessionId);
    }

    public static final IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception exception) {}
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
        return container;
    }

    public static final TRCMonitor createMonitor(IContainer res, String name) {
        TRCMonitor monitor = null;
        ArrayList monitors = PDContentProvider.getMonitors(res);
        int idx = 0;
        while (idx < monitors.size()) {
            Object mon = monitors.get(idx);
            if (mon instanceof TRCMonitor && ((TRCMonitor)mon).getName().equals(name)) {
                return (TRCMonitor)mon;
            }
            ++idx;
        }
        String monitorName = name;
        String monitorFileName = String.valueOf(monitorName) + "." + "trcmxmi";
        IPath filePath = res.getFullPath().append(monitorFileName);
        URI uri = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
        Resource monDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        monDoc.setModified(true);
        EList monExt = monDoc.getContents();
        TraceUIManager.getTraceUIManager().getResourceSet().getResources().add((Object)monDoc);
        HierarchyFactory factory = TraceUIManager.getTraceUIManager().getPerftraceFactory();
        monitor = factory.createTRCMonitor();
        monitor.setName(name);
        monExt.add((Object)monitor);
        PDContentProvider.addMonitor((IResource)res, monitor);
        return monitor;
    }

    public static TRCNode findNode(TRCMonitor monitor, String name) {
        Object[] nodes = monitor.getNodes().toArray();
        int idx = 0;
        while (idx < nodes.length) {
            TRCNode node = (TRCNode)nodes[idx];
            if (!node.eIsProxy() && node.getName().equalsIgnoreCase(name)) {
                return node;
            }
            ++idx;
        }
        return null;
    }

    public static final TRCNode createNode(TRCMonitor monitor, String name, String portNumber) {
        String ipAddress = "";
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
            ipAddress = fnode.getInetAddress().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        TRCNode node = PDCoreUtil.findNode(monitor, name);
        if (node != null) {
            node.setPort(Integer.parseInt(portNumber));
            return node;
        }
        String nodeName = String.valueOf(monitor.getName()) + "_" + TString.change((String)name, (String)" ", (String)"");
        String nodeFileName = String.valueOf(nodeName) + "." + "trcnxmi";
        String monPath = monitor.eResource().getURI().toString();
        Path path = new Path(monPath);
        if (path.segmentCount() > 1) {
            monPath = path.removeLastSegments(1).toString();
        }
        IPath filePath = new Path(monPath).append(nodeFileName);
        URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
        Resource nodeDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        nodeDoc.setModified(true);
        EList nodeExt = nodeDoc.getContents();
        TraceUIManager.getTraceUIManager().getResourceSet().getResources().add((Object)nodeDoc);
        HierarchyFactory factory = TraceUIManager.getTraceUIManager().getPerftraceFactory();
        node = factory.createTRCNode();
        node.setName(name);
        node.setIpAddress(ipAddress);
        node.setMonitor(monitor);
        node.setPort(Integer.parseInt(portNumber));
        nodeExt.add((Object)node);
        EList mon_nodes = monitor.getNodes();
        try {
            mon_nodes.add((Object)node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    public static TRCProcessProxy createProcess(TRCNode node, Object process, boolean isProcessLaunched) {
        String processExecutable;
        String processName;
        String processUUID;
        long processId;
        Process oldProcess = null;
        IProcess newProcess = null;
        if (process instanceof Process) {
            oldProcess = (Process)process;
        } else if (process instanceof IProcess) {
            newProcess = (IProcess)process;
        } else {
            return null;
        }
        try {
            if (oldProcess == null) {
                processId = newProcess.getProcessId();
                processUUID = isProcessLaunched ? newProcess.getUUID() : null;
                processName = newProcess.getName();
                processExecutable = newProcess.getExecutable();
            } else {
                processId = Long.parseLong(oldProcess.getProcessId());
                processUUID = isProcessLaunched ? oldProcess.getUUID() : null;
                processName = oldProcess.getName();
                processExecutable = oldProcess.getExecutable();
            }
        }
        catch (Exception e) {
            CommonUITracePlugin.getDefault().log(e);
            return null;
        }
        TRCProcessProxy trcProcessProxy2 = null;
        EList processes = node.getProcessProxies();
        for (TRCProcessProxy trcProcessProxy2 : processes) {
            if (trcProcessProxy2.eIsProxy() || (long)trcProcessProxy2.getPid() != processId) continue;
            if (isProcessLaunched && trcProcessProxy2.getRuntimeId() != null && trcProcessProxy2.getRuntimeId().equals(processUUID)) {
                return trcProcessProxy2;
            }
            for (TRCAgentProxy agent : trcProcessProxy2.getAgentProxies()) {
                if (agent.eIsProxy() || !agent.isActive()) continue;
                return trcProcessProxy2;
            }
        }
        TRCMonitor monitor = node.getMonitor();
        String rID = new Date().toString();
        rID = TString.change((String)rID, (String)" ", (String)"");
        rID = TString.change((String)rID, (String)":", (String)"");
        String processQualifiedName = String.valueOf(monitor.getName()) + "_" + node.getName() + "_" + processId + "_" + rID;
        String fileName = String.valueOf(processQualifiedName) + "." + "trcpxmi";
        String monPath = node.eResource().getURI().toString();
        Path path = new Path(monPath);
        if (path.segmentCount() > 1) {
            monPath = path.removeLastSegments(1).toString();
        }
        IPath filePath = new Path(monPath).append(fileName);
        URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();
        TraceUIManager.getTraceUIManager().getResourceSet().getResources().add((Object)pDoc);
        HierarchyFactory factory = TraceUIManager.getTraceUIManager().getPerftraceFactory();
        trcProcessProxy2 = factory.createTRCProcessProxy();
        if (isProcessLaunched) {
            trcProcessProxy2.setPid((int)processId);
            trcProcessProxy2.setRuntimeId(processUUID);
        }
        if (processName != null) {
            trcProcessProxy2.setName(processName);
        } else {
            trcProcessProxy2.setName(processExecutable);
        }
        trcProcessProxy2.setLocation(process instanceof ProcessImpl ? ((ProcessImpl)process).getlocation() : null);
        trcProcessProxy2.setActive(true);
        trcProcessProxy2.setLaunchMode(0);
        trcProcessProxy2.setNode(node);
        pExt.add((Object)trcProcessProxy2);
        return trcProcessProxy2;
    }

    public static TRCProcessProxy createProcess(TRCNode node, Object process) {
        return PDCoreUtil.createProcess(node, process, true);
    }

    public static void detachAgents() {
        for (Resource res : HierarchyResourceSetImpl.getInstance().getResources()) {
            EList ext = res.getContents();
            for (Object obj : ext) {
                TRCProcessProxy process;
                TRCAgentProxy agent = null;
                if (obj instanceof TRCAgent) {
                    agent = ((TRCAgent)obj).getAgentProxy();
                } else if (obj instanceof TRCAgentProxy) {
                    agent = (TRCAgentProxy)obj;
                }
                if (agent == null || (process = agent.getProcessProxy()) == null || !process.isActive() || !agent.isActive()) continue;
                try {
                    Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent);
                    if (instance == null || !(instance instanceof Agent)) continue;
                    Agent a = (Agent)instance;
                    if (process.getLaunchMode() != 0) {
                        a.getProcess().kill(0L);
                        continue;
                    }
                    if (!a.isAttached()) continue;
                    a.detach();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    public static String getPIVMArgument(byte mode) {
        String param = "";
        String piFlag = "-XrunpiAgent:server=";
        switch (mode) {
            case 1: {
                piFlag = String.valueOf(piFlag) + "controlled";
                break;
            }
            case 2: {
                piFlag = String.valueOf(piFlag) + "application";
                break;
            }
            case 3: {
                piFlag = String.valueOf(piFlag) + "standalone";
                break;
            }
            case 4: {
                piFlag = String.valueOf(piFlag) + "enabled";
            }
        }
        param = String.valueOf(piFlag) + param;
        return param;
    }

    public static void setAgentConfiguration(TRCAgentProxy agent, Agent a) {
        Object[] configs;
        AgentConfiguration aconfig = a.getConfiguration();
        aconfig.clear();
        if (agent.getType().equals("Profiler") && (configs = agent.getConfigurations().toArray()).length > 0) {
            TRCConfiguration config = (TRCConfiguration)configs[0];
            Object[] filters = config.getFilters().toArray();
            int idx = 0;
            while (idx < filters.length) {
                TRCFilter filter = (TRCFilter)filters[idx];
                if (filter.getActive().booleanValue()) {
                    AgentConfigurationEntry entry = new AgentConfigurationEntry();
                    if (filter.getOperation().equals("") || filter.getOperation().equals("\"\"")) {
                        entry.setName(filter.getPattern());
                        entry.setType("SETFILTER");
                        entry.setValue(filter.getMode());
                        entry.setEnabled(filter.getActive().booleanValue());
                    } else {
                        entry.setName(String.valueOf(filter.getPattern()) + ' ' + filter.getOperation());
                        entry.setType("SETMETHODFILTER");
                        entry.setValue(filter.getMode());
                        entry.setEnabled(filter.getActive().booleanValue());
                    }
                    aconfig.addEntry(entry);
                }
                ++idx;
            }
            Object[] options = config.getOptions().toArray();
            int idx2 = 0;
            while (idx2 < options.length) {
                TRCOption option = (TRCOption)options[idx2];
                AgentConfigurationEntry entry = new AgentConfigurationEntry();
                entry.setType("SETOPTION");
                entry.setName(option.getKey());
                entry.setValue(option.getValue());
                aconfig.addEntry(entry);
                ++idx2;
            }
        }
    }

    public static String getDirectoryName(String fName) {
        int i = fName.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            fName = fName.substring(0, i);
        }
        return fName;
    }

    public static boolean isPathExists(String fdir) {
        File pf = new File(PDCoreUtil.getDirectoryName(fdir));
        return pf.exists();
    }

    public static boolean isZipFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[2];
        return readStream.read(magic) > 1 && magic[0] == 80 && magic[1] == 75;
    }

    public static boolean isZipFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = PDCoreUtil.isZipFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }

    public static boolean createDirectoryMessage(String fDir, Shell shell) {
        File directory = new File(PDCoreUtil.getDirectoryName(fDir));
        String msg = NLS.bind((String)CommonUITraceMessages.FCT_M, (Object)directory.getPath());
        if (!MessageDialog.openQuestion((Shell)shell, (String)CommonUITraceMessages.TRC_MSGT, (String)msg)) {
            return false;
        }
        if (!directory.mkdirs()) {
            String errMsg = CommonUITraceMessages.ERR_FCT;
            MessageDialog.openError((Shell)shell, (String)CommonUITraceMessages.TRC_MSGT, (String)errMsg);
            return false;
        }
        return true;
    }

    public static TRCAgentProxy createUniqueAgent(TRCProcessProxy processProxy, Agent agent) {
        long timeStamp = new Date().getTime();
        double time = (double)timeStamp / 1000.0;
        TRCAgentProxy agentProxy = PDCoreUtil.createAgentNoCheck(processProxy, agent, String.valueOf(timeStamp));
        LoadersUtils.registerAgentInstance((TRCAgentProxy)agentProxy, (Object)agent);
        LoadersUtils.setSessionStartTime((double)time, (TRCAgentProxy)agentProxy);
        return agentProxy;
    }

    protected static TRCAgentProxy createAgentNoCheck(TRCProcessProxy process, Agent agent, String sessionId) {
        String timestamp;
        String rID = timestamp = DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date());
        rID = TString.change((String)rID, (String)" ", (String)"");
        rID = TString.change((String)rID, (String)":", (String)"");
        String agentName = new StringBuffer(process.getNode().getMonitor().getName()).append("_").append(process.getNode().getName()).append("_").append(process.getPid()).append("_").append(rID).append("_").append(sessionId).append("_").append(agent.getName()).toString();
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = String.valueOf(agentName) + "." + "trcaxmi";
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        EList agExt = agDoc.getContents();
        TraceUIManager.getTraceUIManager().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = TraceUIManager.getTraceUIManager().getPerftraceFactory();
        TRCAgentProxy agentProxy = factory.createTRCAgentProxy();
        agentProxy.setName(agent.getName());
        if (agent.getType() != null) {
            agentProxy.setType(agent.getType());
        }
        agentProxy.setProcessProxy(process);
        TRCAgent iAgent = factory.createTRCAgent();
        iAgent.setAgentProxy(agentProxy);
        agExt.add((Object)iAgent);
        PDCoreUtil.markModifiedResources((EObject)iAgent, true);
        if (agentProxy.getAgent() != null) {
            agentProxy.getAgent().setCollectionMode(agentProxy.getCollectionMode());
        }
        iAgent.setName(agentProxy.getName());
        iAgent.setRuntimeId(agentProxy.getRuntimeId());
        iAgent.setType(agentProxy.getType());
        iAgent.setCollectionMode(agentProxy.getCollectionMode());
        return agentProxy;
    }

    public static void markModifiedResources(EObject eObject, boolean modifiedState) {
        while (eObject != null) {
            if (eObject instanceof TRCAgent) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCAgent)eObject).getAgentProxy().getProcessProxy();
                continue;
            }
            if (eObject instanceof TRCAgentProxy) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCAgentProxy)eObject).getProcessProxy().getNode();
                continue;
            }
            if (eObject instanceof TRCProcessProxy) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCProcessProxy)eObject).getNode();
                continue;
            }
            if (eObject instanceof TRCNode) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCNode)eObject).getMonitor();
                continue;
            }
            if (!(eObject instanceof TRCMonitor)) break;
            eObject.eResource().setModified(modifiedState);
            break;
        }
    }

    public static boolean isProfilingPerspective() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective");
    }

    public static boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equals(hostname)) {
            return true;
        }
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return hostname.equals(name);
    }

    public static Node profileConnect(String host, String port, boolean showErrorMsgs) {
        String text = "";
        if ((host == null || host.trim() == "" || port == null || port.trim() == "") && showErrorMsgs) {
            text = CommonUITraceMessages.INVALID_HOST;
            final Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)CommonUITracePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommonUITraceMessages.TRC_MSGT, (String)CommonUITraceMessages.CON_FL, (IStatus)err);
                }
            });
            return null;
        }
        IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();
        ConnectUtil util = new ConnectUtil(host, port, store.getString("user_id"), (Application)CommonUITracePlugin.getDefault());
        int result = util.connect(showErrorMsgs);
        if (result == 0) {
            store.setValue("user_id", util.getUserId());
            return util.getNode();
        }
        return null;
    }

    public static Node profileConnect(String host, String port) {
        return PDCoreUtil.profileConnect(host, port, true);
    }
}

