/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.net.ssl.TrustManager;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreManagerImpl;
import org.eclipse.hyades.execution.security.SecurityConstants;
import org.eclipse.hyades.execution.security.X509TrustManagerImpl;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class SecurityParameters
implements ISecureClientParameters {
    protected KeyFactory keyFactory = null;
    protected IKeystoreManager manager = null;
    protected boolean authenticateServer;

    public SecurityParameters() {
        try {
            this.keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.manager = new KeystoreManagerImpl();
    }

    public Provider getSecurityProvider() {
        return this.keyFactory.getProvider();
    }

    public String getKeystoreFileName() {
        return CommonUIPlugin.getKeyStoreLocation();
    }

    public String getKeystoreFilepassword() {
        return CommonUIPlugin.getDefault().getWorkspaceName();
    }

    public IKeystoreManager getKeystoreManager() {
        return this.manager;
    }

    public String[] getEnabledCipherSuites() {
        return null;
    }

    public String[] getEnabledProtocols() {
        return SecurityConstants.PROTOCOLS;
    }

    public boolean getRequiresServerAuthentication() {
        return this.authenticateServer;
    }

    public void disableServerAuthentication() {
        TrustManager[] trustManagers = this.manager.getTrustManagers();
        int i = 0;
        while (i < trustManagers.length) {
            if (trustManagers[i] instanceof X509TrustManagerImpl) {
                ((X509TrustManagerImpl)trustManagers[i]).disableServerAuthentication();
            }
            ++i;
        }
    }

    public void enableServerAuthentication() {
        TrustManager[] trustManagers = this.manager.getTrustManagers();
        int i = 0;
        while (i < trustManagers.length) {
            if (trustManagers[i] instanceof X509TrustManagerImpl) {
                ((X509TrustManagerImpl)trustManagers[i]).enableServerAuthentication();
            }
            ++i;
        }
    }
}

