/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.security.internal.util.ConnectUtilUser;
import org.eclipse.hyades.security.internal.util.ConnectivityDialog;
import org.eclipse.hyades.security.internal.util.IConnectUtilUI;
import org.eclipse.hyades.security.internal.util.IConnectUtilUser;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.security.internal.util.ui.CertificateDetails;
import org.eclipse.hyades.security.internal.util.ui.SaveCertificate;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ConnectUtilUI
implements IConnectUtilUI {
    protected ConnectivityDialog _connectivityDialog;
    protected int btnPressed = 0;
    protected boolean okPressed = false;
    protected String alias = null;

    protected static Shell getValidShell() {
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            if (workbench.getActiveWorkbenchWindow() != null && (shell = workbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (workbench.getWorkbenchWindows().length > 0 && (shell = workbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    public int openQuestionDialog(final String title, final String msg, final String[] btnLabels) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (btnLabels != null) {
                    MessageDialog dialog = new MessageDialog(ConnectUtilUI.getValidShell(), title, null, msg, 3, btnLabels, 0);
                    ConnectUtilUI.this.btnPressed = dialog.open();
                } else {
                    ConnectUtilUI.this.btnPressed = MessageDialog.openQuestion((Shell)ConnectUtilUI.getValidShell(), (String)title, (String)msg) ? 0 : 1;
                }
            }
        });
        return this.btnPressed;
    }

    public void openCertificateDetailDialog(final X509Certificate certificate) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CertificateDetails dlg = new CertificateDetails(ConnectUtilUI.getValidShell());
                dlg.init(certificate);
                dlg.open();
            }
        });
    }

    public boolean openSaveCertificateDialog(final KeyStore ks) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SaveCertificate dlg = new SaveCertificate(ConnectUtilUI.getValidShell(), ks);
                ConnectUtilUI.this.okPressed = dlg.open() == 0;
                ConnectUtilUI.this.alias = dlg.getAlias();
            }
        });
        return this.okPressed;
    }

    public ConnectivityDialog getUserDialog(String userId, String hostName) {
        return this.getUserDialog(true, userId, hostName);
    }

    public void openDialog(final Dialog dialog) {
        dialog.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public void openErrorDialog(final String title, final String message, final IStatus err) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)ConnectUtilUI.getValidShell(), (String)title, (String)message, (IStatus)err);
            }
        });
    }

    public IConnectUtilUser promptAuthentication(String hostName, String userName) {
        ConnectivityDialog dialog = this.getUserDialog(userName, hostName);
        if (dialog != null && dialog.getReturnCode() == 0) {
            ConnectUtilUser user = new ConnectUtilUser(dialog.getUserId(), dialog.getPassword());
            return user;
        }
        return null;
    }

    protected ConnectivityDialog getUserDialog(boolean isValidPassword, final String userId, final String _hostName) {
        if (isValidPassword) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ConnectUtilUI.this._connectivityDialog = new ConnectivityDialog(ConnectUtilUI.getValidShell(), _hostName, userId, userId == null || userId.equals(""));
                    ConnectUtilUI.this._connectivityDialog.setDescription(NLS.bind((String)SecurityMessages._51, (Object)_hostName));
                    ConnectUtilUI.this._connectivityDialog.create();
                    ConnectUtilUI.this.openDialog(ConnectUtilUI.this._connectivityDialog);
                }
            });
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ConnectUtilUI.this._connectivityDialog = new ConnectivityDialog(ConnectUtilUI.getValidShell(), _hostName, userId, userId == null || userId.equals(""));
                    ConnectUtilUI.this._connectivityDialog.setDescription(NLS.bind((String)SecurityMessages._52, (Object)_hostName));
                    ConnectUtilUI.this._connectivityDialog.create();
                    ConnectUtilUI.this.openDialog(ConnectUtilUI.this._connectivityDialog);
                }
            });
        }
        if (this._connectivityDialog.getReturnCode() != 0) {
            return null;
        }
        return this._connectivityDialog;
    }

    public String getAlias() {
        return this.alias;
    }
}

