/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.security.internal.util.ConnectivityUI;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class ConnectivityDialog
extends Dialog {
    protected ConnectivityUI _connectivityUI;
    protected String fHost;
    protected String fUserId;
    protected String fPassword;
    protected String fDescription;
    protected boolean fSelectUserField = true;

    public ConnectivityDialog(Shell shell, String host) {
        this(shell, host, "", "", true);
    }

    public ConnectivityDialog(Shell shell, String host, String userId) {
        this(shell, host, userId, "", true);
    }

    public ConnectivityDialog(Shell shell, String host, String userId, boolean selectUserField) {
        this(shell, host, userId, "", selectUserField);
    }

    public ConnectivityDialog(Shell shell, String host, String userId, String password, boolean selectUserField) {
        super(shell);
        this.fHost = host;
        this.fUserId = userId;
        this.fPassword = password;
        this.fSelectUserField = selectUserField;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SecurityMessages._41);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        this._connectivityUI = new ConnectivityUI(this.getShell());
        this._connectivityUI.setUserSelection(this.fSelectUserField);
        this._connectivityUI.setDescription(this.fDescription);
        this._connectivityUI.createContents(content);
        this._connectivityUI.setHost(this.fHost);
        this._connectivityUI.setUserId(this.fUserId);
        this._connectivityUI.setPassword(this.fPassword);
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getShell().setDefaultButton(this.getButton(0));
        return control;
    }

    protected void okPressed() {
        this.fUserId = this._connectivityUI.getUserId();
        this.fPassword = this._connectivityUI.getPassword();
        if (this.fUserId.equals("")) {
            String text = SecurityMessages._39;
            String info = SecurityMessages._38;
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            ErrorDialog.openError((Shell)CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityMessages._41, (String)info, (IStatus)err);
            return;
        }
        if (this.fPassword.equals("")) {
            String text = SecurityMessages._40;
            String info = SecurityMessages._38;
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            ErrorDialog.openError((Shell)CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityMessages._41, (String)info, (IStatus)err);
            return;
        }
        super.okPressed();
    }

    public String getUserId() {
        return this.fUserId;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setDescription(String desc) {
        this.fDescription = desc;
    }
}

