/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectivityUI {
    protected Text fPassword;
    protected Text fUserId;
    protected Text fHost;
    protected String fDescription = "";
    protected boolean fSelectUserField = true;

    public ConnectivityUI(Shell shell) {
    }

    public void createContents(Composite c) {
        Composite nameGroup = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = GridUtil.createFill();
        nameGroup.setLayoutData((Object)data);
        nameGroup.setLayout((Layout)layout);
        Label label = new Label(nameGroup, 64);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 340;
        data.horizontalAlignment = 768;
        label.setLayoutData((Object)data);
        String text = this.fDescription;
        label.setText(text);
        label = new Label(nameGroup, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Label hostLabel = new Label(nameGroup, 0);
        hostLabel.setText(SecurityMessages._35);
        this.fHost = new Text(nameGroup, 2048);
        this.fHost.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.fHost.setEditable(false);
        Label userLabel = new Label(nameGroup, 0);
        userLabel.setText(SecurityMessages._36);
        this.fUserId = new Text(nameGroup, 2048);
        this.fUserId.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label pwdLabel = new Label(nameGroup, 0);
        pwdLabel.setText(SecurityMessages._37);
        this.fPassword = new Text(nameGroup, 2048);
        this.fPassword.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.fPassword.setEchoChar('*');
    }

    public Text getHostComponent() {
        return this.fHost;
    }

    public String getHost() {
        return this.fHost.getText().trim();
    }

    public void setHost(String host) {
        this.fHost.setText(host);
    }

    public Text getUserIdComponent() {
        return this.fUserId;
    }

    public String getUserId() {
        return this.fUserId.getText().trim();
    }

    public void setUserId(String userId) {
        if (userId != null) {
            this.fUserId.setText(userId);
        }
        if (this.fSelectUserField) {
            this.fUserId.setFocus();
            this.fUserId.selectAll();
        } else {
            this.fPassword.setFocus();
            this.fPassword.selectAll();
        }
    }

    public Text getPasswordComponent() {
        return this.fPassword;
    }

    public String getPassword() {
        return this.fPassword.getText().trim();
    }

    public void setPassword(String password) {
        if (password != null) {
            this.fPassword.setText(password);
        }
        if (this.fSelectUserField) {
            this.fUserId.setFocus();
            this.fUserId.selectAll();
        } else {
            this.fPassword.setFocus();
            this.fPassword.selectAll();
        }
    }

    public void setDescription(String desc) {
        this.fDescription = desc;
    }

    public void setUserSelection(boolean sel) {
        this.fSelectUserField = sel;
    }
}

