/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.internal.actions.CreateOrEditFilter;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class FilterQueryProvider
implements IFilterQueryProvider {
    protected FilterInformationManager _fi;

    public FilterQueryProvider(FilterInformationManager fi) {
        this._fi = fi;
    }

    public SimpleSearchQuery standardQuery() {
        FilterQueries fq = this._fi.selectedFilter();
        if (fq != null && !CommonUIMessages._111.equals(fq.name())) {
            return fq.standard();
        }
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        query.setWhereExpression((WhereExpression)logicalExpression);
        return query;
    }

    public SimpleSearchQuery advancedQuery() {
        FilterQueries fq = this._fi.selectedFilter();
        if (fq != null && !CommonUIMessages._111.equals(fq.name())) {
            return fq.advanced();
        }
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        query.setWhereExpression((WhereExpression)logicalExpression);
        return query;
    }

    public void updateStandardQuery(SimpleSearchQuery standardQuery) {
        CreateOrEditFilter.run(this._fi, 0, standardQuery, null, -1);
    }

    public void updateAdvancedQuery(SimpleSearchQuery advancedQuery) {
        CreateOrEditFilter.run(this._fi, 1, null, advancedQuery, -1);
    }

    public void updateAdvancedQuery(SimpleSearchQuery advancedQuery, int advancedTabSelectionIndex) {
        CreateOrEditFilter.run(this._fi, 1, null, advancedQuery, advancedTabSelectionIndex);
    }

    public SimpleSearchQuery getCurrentFilter() {
        return this._fi.getCurrentFilter();
    }

    public void viewerDisposed() {
        this._fi.viewerDisposed();
    }
}

