/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.hyades.ui.filters.internal.actions.FiltersEditorAction;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersSetAction;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class FiltersDropDownMenu
implements IMenuCreator {
    protected Menu _menu;
    protected FiltersEditorAction _feAction;
    protected FilterInformationManager _fi;

    public FiltersDropDownMenu(FilterInformationManager fi) {
        this._fi = fi;
        this._feAction = new FiltersEditorAction(this._fi);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this._menu != null) {
            this._menu.dispose();
        }
        this._menu = new Menu(parent);
        String NO_FILTER_NAME = CommonUIMessages._111;
        String selectedFilterName = this._fi.selectedFilterName();
        boolean noFilterSelected = true;
        boolean actionNoFilterFound = false;
        int i = 0;
        while (i < this._fi.size()) {
            String filterName = this._fi.filter(i).name();
            if (!actionNoFilterFound && NO_FILTER_NAME.equals(filterName)) {
                actionNoFilterFound = true;
            } else {
                ImageDescriptor icon = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(this._fi.filter(i).type()).icon();
                FiltersSetAction action = new FiltersSetAction(this, filterName, icon);
                if (selectedFilterName != null && selectedFilterName.equals(action.getText())) {
                    action.setChecked(true);
                    noFilterSelected = false;
                } else {
                    action.setChecked(false);
                }
                this.addActionToMenu(this._menu, action);
            }
            ++i;
        }
        if (actionNoFilterFound || noFilterSelected) {
            FiltersSetAction action = new FiltersSetAction(this, NO_FILTER_NAME, null);
            this.addActionToMenu(this._menu, action);
            if (noFilterSelected) {
                action.setChecked(true);
                this._fi.selectedFilterName(NO_FILTER_NAME, false);
            }
        }
        new Separator().fill(this._menu, -1);
        this.addActionToMenu(this._menu, this._feAction);
        return this._menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void selectedFilterName(String filterName) {
        this._fi.selectedFilterName(filterName);
    }
}

