/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterTypeDialog;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersDialog;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersEditDialog;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class FilterUIUtil {
    public static FiltersEditDialog getFiltersEditDialog(FilterInformationManager fi) {
        return new FiltersEditDialog(fi);
    }

    public static FiltersEditDialog getFiltersEditDialog(FilterInformationManager fi, boolean showNoFilter) {
        return new FiltersEditDialog(fi, showNoFilter);
    }

    public static FiltersDialog getFiltersDialog(FilterQueries fq, FilterInformationManager fi, int openTabIndex, int advancedTabSelectionIndex) {
        FiltersDialog dialog = new FiltersDialog(fq, fi, openTabIndex, advancedTabSelectionIndex);
        IFilterType ft = ICommonUIHelper.INSTANCE.getFilterTypesManager().getFilterType(fq.type());
        FiltersStandardTabUI standardTabUI = ft.standardTabUI();
        FiltersAdvancedUI advancedTabUI = null;
        if (ft.advancedTabAttributeSet() != null) {
            advancedTabUI = new FiltersAdvancedUI(ft.advancedTabAttributeSet());
        }
        if (standardTabUI != null) {
            standardTabUI.initializeDialog(dialog);
        }
        if (advancedTabUI != null) {
            advancedTabUI.initializeDialog(dialog);
        }
        dialog.setTabUIs(standardTabUI, advancedTabUI);
        return dialog;
    }

    public static FiltersDialog getFiltersDialog(FilterQueries fq, FilterInformationManager fi, int openTabIndex) {
        return FilterUIUtil.getFiltersDialog(fq, fi, openTabIndex, -1);
    }

    public static FilterTypeDialog getFiltersTypeDialog(FilterInformationManager fi) {
        return new FilterTypeDialog(fi);
    }
}

