/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class FilterResourceFileHandler {
    protected Resource _resource;
    protected URI _uri;

    protected FilterResourceFileHandler(URI uri) {
        this._uri = uri;
        this.load();
    }

    public static FilterResourceFileHandler instance(URI uri) {
        return new FilterResourceFileHandler(uri);
    }

    public void addFilter(FilterQueries fq) {
        this._resource.getContents().add((Object)fq.standard());
        this._resource.getContents().add((Object)fq.advanced());
    }

    public FilterQueries filter(int i) {
        FilterQueries fq = new FilterQueries();
        fq.standard((SimpleSearchQuery)this._resource.getContents().get(i * 2));
        fq.advanced((SimpleSearchQuery)this._resource.getContents().get(i * 2 + 1));
        return fq;
    }

    public int size() {
        return this._resource.getContents().size() / 2;
    }

    public void clear() {
        this._resource.getContents().clear();
    }

    public void removeFilter(FilterQueries fq) {
        this._resource.getContents().remove((Object)fq.standard());
        this._resource.getContents().remove((Object)fq.advanced());
    }

    public FilterQueries filter(String name) {
        int i = 0;
        while (i < this.size()) {
            FilterQueries fq = this.filter(i);
            if (fq.name().equals(name)) {
                return fq;
            }
            ++i;
        }
        return null;
    }

    public Vector filters(String name) {
        Vector<FilterQueries> result = new Vector<FilterQueries>();
        int i = 0;
        while (i < this.size()) {
            FilterQueries fq = this.filter(i);
            if (fq.name().equals(name)) {
                result.add(fq);
            }
            ++i;
        }
        return result;
    }

    public Object[] toArray() {
        Vector<FilterQueries> filters = new Vector<FilterQueries>();
        int i = 0;
        while (i < this.size()) {
            filters.addElement(this.filter(i));
            ++i;
        }
        return filters.toArray();
    }

    public void save() {
        try {
            if (this._resource instanceof XMLResource) {
                ((XMLResource)this._resource).setEncoding("UTF-8");
            }
            this._resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            CommonPlugin.logError((Throwable)e);
        }
    }

    public void save(OutputStream oStream, Map resourceMap) {
        try {
            if (this._resource instanceof XMLResource) {
                ((XMLResource)this._resource).setEncoding("UTF-8");
            }
            this._resource.save(oStream, resourceMap);
        }
        catch (IOException e) {
            CommonPlugin.logError((Throwable)e);
        }
    }

    public void load(InputStream is, Map resourceMap) {
        if (this._resource == null) {
            this.restoreResource();
        } else {
            try {
                this.unload(false);
                this._resource.load(is, resourceMap);
            }
            catch (IOException e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
    }

    public void load() {
        if (this._resource == null) {
            this.restoreResource();
        } else {
            try {
                this.unload(false);
                this._resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
    }

    public void unload() {
        this.unload(true);
    }

    protected void unload(boolean resetResource) {
        if (this._resource != null) {
            this._resource.unload();
            if (resetResource) {
                this._resource = null;
            }
        }
    }

    protected void restoreResource() {
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        try {
            this._resource = resourceSet.getResource(this._uri, true);
        }
        catch (Exception exception) {
            this._resource = null;
        }
        if (this._resource == null) {
            this._resource = resourceSet.createResource(this._uri);
        }
    }
}

