/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.classloader;

import java.util.Hashtable;

public abstract class AbstractClassLoader
extends ClassLoader {
    protected Hashtable classByClassName;
    protected boolean prepend;
    protected char classNameReplacementChar;

    protected AbstractClassLoader() {
        this.initialize();
    }

    protected AbstractClassLoader(ClassLoader parent) {
        super(parent);
        this.initialize();
    }

    protected void initialize() {
        this.prepend = true;
        this.classByClassName = new Hashtable();
    }

    public void setPrepend(boolean prepend) {
        this.prepend = prepend;
    }

    public boolean getPrepend() {
        return this.prepend;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class result;
        block9: {
            result = (Class)this.classByClassName.get(className);
            if (result != null) {
                return result;
            }
            if (this.prepend) {
                try {
                    result = this.loadFromExtensions(className);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (result == null) {
                    return super.loadClass(className, resolve);
                }
            } else {
                try {
                    return super.loadClass(className, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    result = this.loadFromExtensions(className);
                    if (result != null) break block9;
                    throw new ClassFormatError();
                }
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        this.classByClassName.put(className, result);
        return result;
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected Class loadFromExtensions(String className) throws ClassNotFoundException {
        byte[] classBytes = null;
        classBytes = this.loadClassBytes(className);
        if (classBytes == null) {
            throw new ClassNotFoundException("className: " + className);
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }

    protected String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return String.valueOf(className.replace('.', '/')) + ".class";
        }
        return String.valueOf(className.replace('.', this.classNameReplacementChar)) + ".class";
    }
}

