/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.context;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.ContextOpenSourceHandlerManager;
import org.eclipse.hyades.ui.provisional.context.IContextHandler;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceHandler;
import org.eclipse.jface.preference.IPreferenceStore;

public class ContextMappingPreference {
    public static String CONTEXT_MAPPING_PREFERENCE = "hyades.ui.context.mapping.preference";
    protected Map mappingByContext;
    protected IPreferenceStore preferenceStore;
    protected String contextMappingStr;

    public ContextMappingPreference(IPreferenceStore preferenceStore_) {
        this.preferenceStore = preferenceStore_;
        this.contextMappingStr = null;
    }

    public void populateMappingByContext() {
        this.populateMappingFromPreferenceStore();
        IContextLanguage[] languages = ContextManager.getContextLanguages();
        int i = 0;
        while (i < languages.length) {
            IContextOpenSourceHandler[] coshs;
            IContextHandler[] chs;
            String contextKey = languages[i].contextKey();
            if (this.getContextProviderId(contextKey) == null && (chs = ContextManager.getContextHandlers(contextKey)) != null && chs.length > 0) {
                this.setContextProviderId(contextKey, chs[0].id());
            }
            if (this.getContextOpenSourceProviderId(contextKey) == null && (coshs = ContextOpenSourceHandlerManager.getContextOpenSourceHandlers(contextKey)) != null && coshs.length > 0) {
                this.setContextOpenSourceProviderId(contextKey, coshs[0].id());
            }
            ++i;
        }
    }

    public void populateMappingFromPreferenceStore() {
        this.contextMappingStr = this.getPreferenceStore().getString(CONTEXT_MAPPING_PREFERENCE);
        if (this.contextMappingStr == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.contextMappingStr, ":");
        while (st.hasMoreTokens()) {
            String contextStr = st.nextToken();
            StringTokenizer contextStrTokenizer = new StringTokenizer(contextStr, ";");
            String key = contextStrTokenizer.hasMoreTokens() ? contextStrTokenizer.nextToken() : null;
            String contextProviderId = contextStrTokenizer.hasMoreTokens() ? contextStrTokenizer.nextToken() : null;
            String contextOpenSourceProviderId = contextStrTokenizer.hasMoreTokens() ? contextStrTokenizer.nextToken() : null;
            if (key == null) continue;
            this.setContextProviderId(key, contextProviderId);
            this.setContextOpenSourceProviderId(key, contextOpenSourceProviderId);
        }
    }

    public boolean writeMappingToPreferenceStore() {
        StringBuffer contextMappingStrB = new StringBuffer();
        for (String key : this.mappingByContext.keySet()) {
            String contextProviderId = this.getContextProviderId(key);
            String contextOpenSourceProviderId = this.getContextOpenSourceProviderId(key);
            contextMappingStrB.append(key);
            contextMappingStrB.append(";");
            if (contextProviderId != null) {
                contextMappingStrB.append(contextProviderId);
            }
            contextMappingStrB.append(";");
            if (contextOpenSourceProviderId != null) {
                contextMappingStrB.append(contextOpenSourceProviderId);
            }
            contextMappingStrB.append(":");
        }
        this.getPreferenceStore().setValue(CONTEXT_MAPPING_PREFERENCE, contextMappingStrB.toString());
        return true;
    }

    public String getContextProviderId(String contextKey) {
        return this.getContextProviders(contextKey).contextProviderID();
    }

    public String getContextOpenSourceProviderId(String contextKey) {
        return this.getContextProviders(contextKey).openSourceProviderID();
    }

    public void setContextProviderId(String contextKey, String id) {
        ContextProviders cps = this.getContextProviders(contextKey);
        cps.contextProviderID(id);
    }

    public void setContextOpenSourceProviderId(String contextKey, String id) {
        ContextProviders cps = this.getContextProviders(contextKey);
        cps.openSourceProviderID(id);
    }

    protected ContextProviders getContextProviders(String contextKey) {
        ContextProviders cps;
        if (this.mappingByContext == null) {
            this.mappingByContext = new HashMap();
        }
        if ((cps = (ContextProviders)this.mappingByContext.get(contextKey)) == null) {
            cps = new ContextProviders();
            this.mappingByContext.put(contextKey, cps);
        }
        return cps;
    }

    public boolean changed() {
        String preferenceStr = this.getPreferenceStore().getString(CONTEXT_MAPPING_PREFERENCE);
        return preferenceStr == null || !preferenceStr.equals(this.contextMappingStr);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public class ContextProviders {
        protected String contextProviderId;
        protected String openSourceProviderId;

        public void contextProviderID(String contextProviderId_) {
            this.contextProviderId = contextProviderId_;
        }

        public void openSourceProviderID(String openSourceProviderId_) {
            this.openSourceProviderId = openSourceProviderId_;
        }

        public String contextProviderID() {
            return this.contextProviderId;
        }

        public String openSourceProviderID() {
            return this.openSourceProviderId;
        }
    }
}

