/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMapping;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.util.UIUtil;

public class AssociationDescriptor
implements IAssociationDescriptor,
Serializable {
    protected static final long serialVersionUID = 3256725086991103289L;
    protected AssociationMapping associationMapping;
    protected String id;
    protected String name;
    protected String extension;
    protected String description;
    protected Class extensionClass;
    protected String imageKey;
    protected Set types;
    protected boolean isPluginDefault = false;
    protected IConfigurationElement configurationElement;
    private Object currentInstance = null;

    public AssociationDescriptor(AssociationMapping associationMapping) {
        this.associationMapping = associationMapping;
    }

    public void dispose() {
        if (this.types != null) {
            this.types.clear();
        }
        this.configurationElement = null;
        this.extensionClass = null;
    }

    protected ImageRegistry getImageRegistry() {
        return this.associationMapping.getImageRegistry();
    }

    public IAssociationMapping getAssociationMapping() {
        return this.associationMapping;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        String key = imageDescriptor.toString();
        if (this.getImageRegistry() != null && this.getImageRegistry().getDescriptor(key) == null) {
            this.getImageRegistry().put(key, imageDescriptor);
            this.imageKey = key;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageKey == null || this.getImageRegistry() == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(this.imageKey);
        if (imageDescriptor == null && this.configurationElement != null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin(Platform.getBundle((String)this.configurationElement.getDeclaringExtension().getNamespace()), this.imageKey)) != null) {
            this.getImageRegistry().put(this.imageKey, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getImage() {
        if (this.imageKey == null || this.getImageRegistry() == null) {
            return null;
        }
        Image image = this.getImageRegistry().get(this.imageKey);
        if (image == null && this.getImageDescriptor() != null) {
            image = this.getImageRegistry().get(this.imageKey);
        }
        return image;
    }

    public void setConfigurationElement(IConfigurationElement configurationElement) {
        this.extensionClass = null;
        this.configurationElement = configurationElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public void setImplementationClass(Class extensionClass) {
        this.extensionClass = extensionClass;
    }

    public Class getImplementationClass() {
        this.currentInstance = null;
        if (this.extensionClass == null && this.configurationElement != null && this.getValue(this.configurationElement, "class") != null) {
            try {
                this.currentInstance = this.configurationElement.createExecutableExtension("class");
                this.extensionClass = this.currentInstance.getClass();
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        return this.extensionClass;
    }

    public Object createImplementationClassInstance() {
        Class cls = this.getImplementationClass();
        if (this.currentInstance != null) {
            return this.currentInstance;
        }
        if (cls != null) {
            try {
                return cls.newInstance();
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExtension(String fileExtension) {
        this.extension = fileExtension;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean applyTo(String type) {
        if (this.applyToAllTypes()) {
            return true;
        }
        return this.types.contains(type);
    }

    public boolean applyToAllTypes() {
        return this.types == null;
    }

    public boolean addType(String type) {
        if (type == null) {
            return false;
        }
        if (this.types == null) {
            this.types = new HashSet();
        }
        if (this.types.add(type)) {
            if (!this.associationMapping.register(type, this)) {
                this.types.remove(type);
                return false;
            }
            if (this.types.size() == 1) {
                this.associationMapping.deregister(this);
            }
        }
        return true;
    }

    public boolean removeType(String type) {
        if (type == null) {
            return false;
        }
        if (this.types == null) {
            return false;
        }
        if (this.types.remove(type)) {
            if (this.types.isEmpty()) {
                this.types = null;
            }
            this.associationMapping.deregister(type, this);
            if (this.applyToAllTypes()) {
                this.associationMapping.register(this);
            }
        }
        return true;
    }

    public String[] types() {
        if (this.types == null) {
            return new String[0];
        }
        return this.types.toArray(new String[this.types.size()]);
    }

    public IAssociationDescriptor copy() {
        AssociationDescriptor associationDescriptor = this.createClone();
        this.setAttributesOf(associationDescriptor);
        return associationDescriptor;
    }

    protected AssociationDescriptor createClone() {
        return new AssociationDescriptor(null);
    }

    protected void setAttributesOf(AssociationDescriptor associationDescriptor) {
        associationDescriptor.name = this.name;
        associationDescriptor.description = this.description;
        associationDescriptor.id = this.id;
        associationDescriptor.extension = this.extension;
        associationDescriptor.configurationElement = this.configurationElement;
        associationDescriptor.extensionClass = this.extensionClass;
        associationDescriptor.imageKey = this.imageKey;
        associationDescriptor.types = this.types == null ? null : new HashSet(this.types);
    }

    protected void loadFromConfigurationElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.id = this.getValue(configurationElement, "id");
        this.name = this.getValue(configurationElement, "name");
        this.extension = this.getValue(configurationElement, "extension");
        this.description = this.getValue(configurationElement, "description");
        this.imageKey = this.getValue(configurationElement, "icon");
        String defaultValue = this.getValue(configurationElement, "isDefault");
        this.isPluginDefault = defaultValue != null && defaultValue.equalsIgnoreCase("true");
        String type = this.getValue(configurationElement, "type");
        if (type != null) {
            this.addType(type);
        } else {
            IConfigurationElement[] elements = configurationElement.getChildren("appliesTo");
            int i = 0;
            int max = elements.length;
            while (i < max) {
                this.addType(this.getValue(elements[i], "type"));
                ++i;
            }
        }
        if (this.id != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.hyades.ui.extensionBinding");
            int i = 0;
            while (i < elements.length) {
                String extensionIdField = elements[i].getAttribute("extensionId");
                String typeField = elements[i].getAttribute("type");
                if (extensionIdField != null && typeField != null && this.id.equals(extensionIdField)) {
                    this.addType(typeField);
                }
                ++i;
            }
        }
        if (this.applyToAllTypes()) {
            this.associationMapping.register(this);
            if (this.isPluginDefault) {
                this.associationMapping.setDefaultAssociationDescriptor(this);
            }
        } else if (this.isPluginDefault) {
            String[] types = this.types();
            int idx = 0;
            while (idx < types.length) {
                this.associationMapping.setDefaultAssociationDescriptor(types[idx], this);
                ++idx;
            }
        }
    }

    protected String getValue(IConfigurationElement configurationElement, String name) {
        IConfigurationElement[] childElements;
        String value = configurationElement.getAttribute(name);
        if (value == null && (childElements = configurationElement.getChildren(name)).length == 1) {
            value = childElements[0].getValue();
        }
        return value;
    }

    public boolean isPluginDefault() {
        return this.isPluginDefault;
    }

    public void setPluginDefault(boolean value) {
        this.isPluginDefault = value;
    }
}

