/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class NavigatorExtensionUtil {
    protected static final String ALL = "all";
    protected static final Map _contributions = new HashMap();

    public static void fillContextMenu(IMenuManager menu, IStructuredSelection selection, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        int i = 0;
        while (i < e.length) {
            e[i].fillContextMenu(menu, selection);
            ++i;
        }
    }

    public static INavigatorContribution[] getContributions(String navigatorID) {
        INavigatorContribution[] cached = (INavigatorContribution[])_contributions.get(navigatorID == null ? ALL : navigatorID);
        if (cached == null) {
            IExtension[] hyadesUIPluginExtension;
            IExtension[] commonUIPluginExtension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.common.ui", "navigatorExtensions").getExtensions();
            IExtension[] exts = null;
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", "navigatorExtensions");
            if (extPoint != null && (hyadesUIPluginExtension = extPoint.getExtensions()) != null && hyadesUIPluginExtension.length > 0) {
                exts = new IExtension[commonUIPluginExtension.length + hyadesUIPluginExtension.length];
                System.arraycopy(commonUIPluginExtension, 0, exts, 0, commonUIPluginExtension.length);
                System.arraycopy(hyadesUIPluginExtension, 0, exts, commonUIPluginExtension.length, hyadesUIPluginExtension.length);
            }
            if (exts == null) {
                exts = commonUIPluginExtension;
            }
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elements = exts[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("navigatorContribution".equals(elements[j].getName())) {
                        String nav = elements[j].getAttribute("navigatorID");
                        if (navigatorID == null || navigatorID.equals(nav)) {
                            try {
                                String className = elements[j].getAttribute("class");
                                Class classObj = Platform.getBundle((String)exts[i].getNamespace()).loadClass(className);
                                list.add(classObj.newInstance());
                            }
                            catch (Exception e) {
                                CommonPlugin.logError((Throwable)e);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            cached = new INavigatorContribution[list.size()];
            list.toArray(cached);
            _contributions.put(navigatorID == null ? ALL : navigatorID, cached);
        }
        return cached;
    }

    public static List getAllChildren(Object item, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < e.length) {
            list.addAll(e[i].getChildren(item));
            ++i;
        }
        return list;
    }

    public static boolean hasChildren(Object item, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        int i = 0;
        while (i < e.length) {
            if (e[i].hasChildren(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Collection getAllModifiedItems(String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        HashSet c = new HashSet();
        int i = 0;
        while (i < e.length) {
            c.addAll(e[i].getModifiedItems());
            ++i;
        }
        return c;
    }

    public static void disposeAll() {
        for (INavigatorContribution[] e : _contributions.values()) {
            int i = 0;
            while (i < e.length) {
                e[i].dispose();
                e[i] = null;
                ++i;
            }
        }
        _contributions.clear();
    }
}

