/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ResourceUtil {
    public static void createContainer(IContainer container, IProgressMonitor progressMonitor) throws CoreException {
        if (container == null || container.exists()) {
            return;
        }
        ResourceUtil.createContainer(container.getParent(), progressMonitor);
        if (container instanceof IProject) {
            ((IProject)container).create(progressMonitor);
        } else if (container instanceof IFolder) {
            ((IFolder)container).create(true, true, progressMonitor);
        }
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static File getPluginDirectory(String pluginId) {
        File pluginDir = null;
        try {
            URL pluginURL = new URL(Platform.getBundle((String)pluginId).getEntry("/"), "plugin.xml");
            File manifestFile = new File(Platform.asLocalURL((URL)pluginURL).getFile()).getAbsoluteFile();
            if (manifestFile.exists()) {
                pluginDir = manifestFile.getParentFile();
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
        }
        return pluginDir;
    }

    public static String[] getPluginLibraries(String pluginId) {
        if (pluginId == null) {
            return new String[0];
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return new String[0];
        }
        File pluginDir = ResourceUtil.getPluginDirectory(pluginId);
        String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
        }
        catch (BundleException be) {
            CommonPlugin.logError((Throwable)be);
        }
        if (elements == null) {
            return new String[0];
        }
        ArrayList<String> libraries = new ArrayList<String>(elements.length);
        int i = 0;
        int maxi = elements.length;
        while (i < maxi) {
            File lib = new File(pluginDir, elements[i].getValue());
            try {
                libraries.add(lib.getCanonicalPath().replace('\\', '/'));
            }
            catch (IOException iOException) {
                libraries.add(lib.getAbsolutePath().replace('\\', '/'));
            }
            ++i;
        }
        return libraries.toArray(new String[libraries.size()]);
    }

    public static Map getFiles(IWorkspaceRoot workspaceRoot, String[] fileExtensions, IGetFilesVisitor visitor) {
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int i = 0;
        int maxi = fileExtensions.length;
        while (i < maxi) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
            ++i;
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        IProject[] projects = workspaceRoot.getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            ResourceUtil.getFiles((IResource)projects[i2], filesByFileExtension, visitor);
            ++i2;
        }
        return filesByFileExtension;
    }

    public static Map getFiles(IResource resource, String[] fileExtensions, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return Collections.EMPTY_MAP;
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int i = 0;
        int maxi = fileExtensions.length;
        while (i < maxi) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
            ++i;
        }
        ResourceUtil.getFiles(resource, filesByFileExtension, visitor);
        return filesByFileExtension;
    }

    protected static void getFiles(IResource resource, Map filesByFileExtension, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return;
        }
        switch (resource.getType()) {
            case 1: {
                Object object;
                List files;
                String fileExtension = resource.getFileExtension();
                if (fileExtension == null || (files = (List)filesByFileExtension.get(fileExtension)) == null || (object = visitor.visit((IFile)resource)) == null) break;
                files.add(object);
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                if (!project.isOpen()) {
                    return;
                }
            }
            case 2: {
                try {
                    IResource[] members = ((IContainer)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        ResourceUtil.getFiles(members[i], filesByFileExtension, visitor);
                        ++i;
                    }
                    break;
                }
                catch (CoreException e) {
                    CommonPlugin.logError((Throwable)e);
                }
            }
        }
    }

    public static List getValidAdapters(List objects, Class adapterClass) {
        ArrayList<Object> adapters = new ArrayList<Object>(objects.size());
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof IAdaptable) {
                Object adapter = ((IAdaptable)object).getAdapter(adapterClass);
                if (adapter == null) continue;
                adapters.add(adapter);
                continue;
            }
            if (!adapterClass.isInstance(object)) continue;
            adapters.add(object);
        }
        return adapters;
    }

    public static String getFullPath(IPath path) {
        if (path == null) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path.makeAbsolute());
        if (res != null) {
            path = res.getLocation().makeAbsolute();
        }
        return path.toString();
    }

    public static interface IGetFilesVisitor {
        public Object visit(IFile var1);
    }
}

