/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportExtensionsWizard;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportGeneratorsExtensionRegistryReader;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportSelectionWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.internal.util.UIUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.framework.Bundle;

public class HyadesReportWizard
extends HyadesWizard {
    protected static String REPORT_WIZARD_KEY = "HyadesReportWizard";
    HyadesReportSelectionWizardPage reportSelectionPage;
    protected String contextHelpID = null;

    public HyadesReportWizard() {
        this.setWindowTitle(CommonUIMessages._152);
        IDialogSettings dialogSettings = CommonUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(REPORT_WIZARD_KEY);
        if (settings == null) {
            settings = dialogSettings.addNewSection(REPORT_WIZARD_KEY);
        }
        this.setDialogSettings(settings);
        this.setForcePreviousAndNextButtons(true);
    }

    public HyadesReportWizard(String contextHelpID) {
        this();
        this.contextHelpID = contextHelpID;
    }

    protected void initPages() {
        this.reportSelectionPage = this.contextHelpID != null ? new HyadesReportSelectionWizardPage("report", this.getWorkbench(), this.getSelection(), this.getWizardElements(), CommonUIMessages._156, this.contextHelpID) : new HyadesReportSelectionWizardPage("report", this.getWorkbench(), this.getSelection(), this.getWizardElements(), CommonUIMessages._156);
        this.reportSelectionPage.setTitle(CommonUIMessages._152);
        this.reportSelectionPage.setDescription(CommonUIMessages._180);
    }

    protected IWizardElement[] getWizardElements() {
        LinkedList<WizardElement> wizardElems = new LinkedList<WizardElement>();
        try {
            for (IConfigurationElement elem : HyadesReportGeneratorsExtensionRegistryReader.getInstance().getWizardCategoryElements()) {
                String icon_path;
                ReportGeneratorWizard wiz = (ReportGeneratorWizard)elem.createExecutableExtension("class");
                if (!wiz.isAvailable((ISelection)this.getSelection())) continue;
                WizardElement wizardElement = new WizardElement((IWizard)wiz);
                wizardElement.setId(elem.getAttribute("id"));
                wiz.setId(wizardElement.getId());
                wizardElement.setLabel(elem.getAttribute("name"));
                wizardElement.setDescription(elem.getAttribute("description"));
                ImageDescriptor imageDescriptor = null;
                String symbolicName = elem.getDeclaringExtension().getNamespace();
                Bundle bundle = Platform.getBundle((String)symbolicName);
                if (bundle != null && bundle.getState() == 32 && (icon_path = elem.getAttribute("icon")) != null) {
                    URL url = new URL(bundle.getEntry("/"), icon_path);
                    imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                }
                wizardElement.setImageDescriptor(imageDescriptor);
                wizardElems.add(wizardElement);
            }
            ReportManager manager = ReportManager.getInstance();
            IReportDescription[] list = manager.getReportDescriptions();
            int idx = 0;
            while (idx < list.length) {
                ReportDescription data = (ReportDescription)list[idx];
                IReportGenerator gen = null;
                gen = data.getReportGenerator();
                if (gen != null && gen.isAvailable((ISelection)this.getSelection())) {
                    WizardElement wizardElement = new WizardElement((IWizard)new HyadesReportExtensionsWizard(gen));
                    wizardElement.setId(data.getName());
                    wizardElement.setLabel(data.getName());
                    wizardElement.setDescription("wizard.Report.Description");
                    wizardElems.add(wizardElement);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
        }
        IWizardElement[] arrayOfWizardElement = new IWizardElement[wizardElems.size()];
        wizardElems.toArray(arrayOfWizardElement);
        return arrayOfWizardElement;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.reportSelectionPage);
    }

    public boolean performFinish() {
        String editorid;
        IFile reportFile;
        block6: {
            FinishOperation op = new FinishOperation();
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
            reportFile = op.getReportFile();
            editorid = op.getEditorId();
            this.reportSelectionPage.saveWidgetValues();
            if (reportFile != null) break block6;
            return false;
        }
        try {
            BasicNewResourceWizard.selectAndReveal((IResource)reportFile, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
            this.open(reportFile, editorid);
        }
        catch (InterruptedException e) {
            CommonPlugin.logError((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            CommonPlugin.logError((Throwable)exception);
            String error = exception.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = exception.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = exception.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)CommonUIMessages._8, (String)NLS.bind((String)CommonUIMessages._160, (Object)error));
            return false;
        }
        return true;
    }

    protected void open(IFile file, String editorid) {
        IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
        store.setValue("REPORT_OPEN_EDITOR", this.reportSelectionPage.openEditor());
        if (this.reportSelectionPage.openEditor()) {
            UIUtil.openEditor(file, editorid, false);
        }
    }

    class FinishOperation
    extends WorkspaceModifyOperation {
        protected IFile indexReport = null;
        protected String editorid = null;

        FinishOperation() {
        }

        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    IWizard selectedWizard = HyadesReportWizard.this.reportSelectionPage.getSelectedNode().getWizard();
                    if (selectedWizard instanceof ReportGeneratorWizard) {
                        monitor.beginTask("", 1);
                        this.indexReport = ((ReportGeneratorWizard)selectedWizard).generate((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                        this.editorid = ((ReportGeneratorWizard)selectedWizard).getEditorId();
                    }
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        public IFile getReportFile() {
            return this.indexReport;
        }

        public String getEditorId() {
            return this.editorid;
        }
    }
}

