/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class FilterListDialog
extends Dialog {
    protected static final String FILTERS_LIST_CRITERIA = "filtersListsCriteria";
    protected static final String FILTERS_LIST_SIZE = "filtersListSize";
    protected IViewPart viewer = null;
    protected ISDFilterProvider provider = null;
    protected List filters;
    protected Button add;
    protected Button remove;
    protected Button edit;
    protected Table table;

    protected void addCriteria(Criteria c, boolean checked, boolean positive, String loaderClassName) {
        CriteriaTableItem cti = new CriteriaTableItem(this.table, checked, positive, loaderClassName);
        cti.setCriteria(c);
    }

    protected void replaceSelectedCriteria(Criteria new_) {
        CriteriaTableItem cti = (CriteriaTableItem)this.table.getSelection()[0].getData();
        cti.setCriteria(new_);
    }

    protected void handleTableSelectionCount() {
        int count = this.table.getSelectionCount();
        this.edit.setEnabled(count == 1);
        this.remove.setEnabled(count > 0);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        ret.setText(SDMessages._57);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ret, "org.eclipse.hyades.ui.UML2SDFILTER");
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        rowLayout.marginLeft = 4;
        rowLayout.marginTop = 4;
        rowLayout.marginRight = 4;
        rowLayout.marginBottom = 4;
        rowLayout.spacing = 8;
        ret.setLayout((Layout)rowLayout);
        this.table = new Table((Composite)ret, 34);
        this.table.setLayoutData((Object)new RowData(220, 84));
        this.table.setHeaderVisible(false);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Criteria c;
                int count = FilterListDialog.this.table.getSelectionCount();
                if (count == 1 && (c = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDMessages._63)) != null) {
                    FilterListDialog.this.replaceSelectedCriteria(c);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        if (this.filters != null) {
            for (FilterCriteria filterCriteria : this.filters) {
                this.addCriteria(filterCriteria.getCriteria(), filterCriteria.isActive(), filterCriteria.isPositive(), filterCriteria.getLoaderClassName());
            }
        }
        Composite commands = new Composite((Composite)ret, 0);
        RowLayout rowLayoutCommands = new RowLayout();
        rowLayoutCommands.wrap = false;
        rowLayoutCommands.pack = false;
        rowLayoutCommands.justify = true;
        rowLayoutCommands.type = 512;
        rowLayoutCommands.marginLeft = 0;
        rowLayoutCommands.marginTop = 4;
        rowLayoutCommands.marginRight = 0;
        rowLayoutCommands.marginBottom = 4;
        rowLayoutCommands.spacing = 8;
        commands.setLayout((Layout)rowLayoutCommands);
        this.add = new Button(commands, 0);
        this.add.setText(SDMessages._61);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria init = new Criteria();
                Criteria c = FilterListDialog.this.openFilterDialog(init, SDMessages._62);
                if (c != null) {
                    FilterListDialog.this.addCriteria(c, true, false, null);
                }
            }
        });
        this.edit = new Button(commands, 0);
        this.edit.setText(SDMessages._60);
        this.edit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria c = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDMessages._63);
                if (c != null) {
                    FilterListDialog.this.replaceSelectedCriteria(c);
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = new Button(commands, 0);
        this.remove.setText(SDMessages._64);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.table.remove(FilterListDialog.this.table.getSelectionIndices());
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        this.remove.setEnabled(false);
        this.getShell().setText(SDMessages._65);
        return ret;
    }

    public FilterListDialog(IViewPart view_, ISDFilterProvider loader_) {
        super(view_.getSite().getShell());
        this.viewer = view_;
        this.provider = loader_;
        this.filters = null;
        this.setShellStyle(67680);
    }

    protected Criteria openFilterDialog(Criteria criteria, String action) {
        SearchFilterDialog filter = new SearchFilterDialog((SDView)this.viewer, this.provider, true, 65536);
        filter.setCriteria(criteria);
        filter.setOkText(action);
        filter.setTitle(SDMessages._66);
        filter.open();
        return filter.getCriteria();
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.loadFiltersCriteria();
        return super.open();
    }

    public void okPressed() {
        this.filters = this.table.getItemCount() > 0 ? new ArrayList() : null;
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            CriteriaTableItem cti = (CriteriaTableItem)item.getData();
            FilterCriteria fc = new FilterCriteria(cti.getCriteria(), item.getChecked(), cti.getPositive(), cti.getLoaderClassName());
            FilterCriteria efc = FilterCriteria.find(fc, this.filters);
            if (efc == null) {
                this.filters.add(fc);
            } else {
                efc.setActive(efc.isActive() || fc.isActive());
            }
            ++i;
        }
        super.close();
        this.provider.filter(this.filters);
        FilterListDialog.saveFiltersCriteria(this.filters);
    }

    public void setFilters(ArrayList filters_) {
        this.filters = filters_;
    }

    public List getFilters() {
        return this.filters;
    }

    protected void loadFiltersCriteria() {
        List globalFilters = FilterListDialog.getGlobalFilters();
        for (FilterCriteria filterCriteria : globalFilters) {
            this.addCriteria(filterCriteria.getCriteria(), filterCriteria.isActive(), filterCriteria.isPositive(), filterCriteria.getLoaderClassName());
        }
    }

    public static List getGlobalFilters() {
        DialogSettings settings = (DialogSettings)CommonUIPlugin.getDefault().getDialogSettings().getSection(FILTERS_LIST_CRITERIA);
        int i = 0;
        DialogSettings section = null;
        int size = 0;
        if (settings != null) {
            try {
                size = settings.getInt(FILTERS_LIST_SIZE);
            }
            catch (NumberFormatException numberFormatException) {
                size = 0;
            }
            section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA + i);
        }
        ArrayList<FilterCriteria> globalFilters = new ArrayList<FilterCriteria>();
        while (section != null && i < size) {
            FilterCriteria criteria = new FilterCriteria();
            criteria.setCriteria(new Criteria());
            criteria.load(section);
            globalFilters.add(criteria);
            section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA + ++i);
        }
        return globalFilters;
    }

    public static void saveFiltersCriteria(List globalFilters) {
        DialogSettings settings = (DialogSettings)CommonUIPlugin.getDefault().getDialogSettings();
        DialogSettings section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA);
        if (section == null) {
            section = (DialogSettings)settings.addNewSection(FILTERS_LIST_CRITERIA);
        }
        if (globalFilters == null) {
            section.put(FILTERS_LIST_SIZE, 0);
            return;
        }
        section.put(FILTERS_LIST_SIZE, globalFilters.size());
        int j = 0;
        while (j < globalFilters.size()) {
            if (!(globalFilters.get(j) instanceof FilterCriteria)) {
                return;
            }
            FilterCriteria criteria = (FilterCriteria)globalFilters.get(j);
            DialogSettings subSection = (DialogSettings)section.getSection(FILTERS_LIST_CRITERIA + j);
            if (subSection == null) {
                subSection = (DialogSettings)section.addNewSection(FILTERS_LIST_CRITERIA + j);
            }
            criteria.save(subSection);
            ++j;
        }
    }

    protected class CriteriaTableItem {
        protected Criteria criteria;
        protected boolean positive;
        protected String loaderClassName;
        protected TableItem tableItem;

        public CriteriaTableItem(Table parent, boolean checked_, boolean positive_, String loaderClassName_) {
            this.tableItem = new TableItem(parent, 0);
            this.tableItem.setData((Object)this);
            this.tableItem.setChecked(checked_);
            this.positive = positive_;
            this.loaderClassName = loaderClassName_;
        }

        public CriteriaTableItem(Table parent, boolean checked_, boolean positive_, String loaderClassName_, int index) {
            this.tableItem = new TableItem(parent, 0, index);
            this.tableItem.setChecked(checked_);
            this.positive = positive_;
            this.loaderClassName = loaderClassName_;
        }

        public void setCriteria(Criteria criteria_) {
            this.criteria = criteria_;
            this.tableItem.setText(String.valueOf(this.positive ? SDMessages._59 : SDMessages._58) + " " + this.criteria.getExpression() + " " + this.criteria.getGraphNodeSummary(FilterListDialog.this.provider, this.loaderClassName));
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public boolean getPositive() {
            return this.positive;
        }

        public String getLoaderClassName() {
            return this.loaderClassName;
        }
    }
}

