/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public abstract class BaseMessage
extends GraphNode {
    protected Lifeline startLifeline = null;
    protected Lifeline endLifeline = null;
    protected boolean visible = true;

    public int getX() {
        return this.getX(false);
    }

    public int getY() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.endEventOccurrence;
        }
        if (this.startLifeline != null) {
            return this.startLifeline.getY() + this.startLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.endEventOccurrence;
        }
        if (this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.endEventOccurrence;
        }
        return 0;
    }

    public int getWidth() {
        return this.getWidth(false);
    }

    public int getHeight() {
        return 0;
    }

    protected int getX(boolean quick) {
        int x = 0;
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            x = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
        } else {
            if (this.startLifeline != null) {
                x = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
            }
            if (this.endLifeline != null) {
                x = this.endLifeline.getX() - 22;
            }
        }
        if (quick) {
            return x;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.endEventOccurrence)) {
            x += activationWidth;
        }
        return x;
    }

    protected int getWidth(boolean quick) {
        int width = 0;
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            width = this.startLifeline == this.endLifeline ? 28 : this.endLifeline.getX() + Metrics.getLifelineWidth() / 2 - this.getX(true);
        } else {
            if (this.startLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
            if (this.endLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
        }
        if (quick) {
            return width;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.endEventOccurrence)) {
            width -= activationWidth;
        }
        if (this.isMessageEndInActivation(this.endEventOccurrence)) {
            width -= activationWidth;
        }
        return width;
    }

    public boolean isVisible(int x, int y, int width, int height) {
        if (this.endLifeline != null && this.endLifeline.isVisible(x, y, width, height) || this.startLifeline != null && this.startLifeline.isVisible(x, y, width, height)) {
            return true;
        }
        if (this.endLifeline != null && !this.endLifeline.isVisible(x, y, width, height) && this.startLifeline != null && !this.startLifeline.isVisible(x, y, width, height)) {
            if (this.endLifeline.getX() > x + width && this.startLifeline.getX() < x) {
                return true;
            }
            if (this.startLifeline.getX() > x + width && this.endLifeline.getX() < x) {
                return true;
            }
        }
        return false;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setStartLifeline(Lifeline lifeline) {
        this.startLifeline = lifeline;
    }

    public Lifeline getStartLifeline() {
        return this.startLifeline;
    }

    public Lifeline getEndLifeline() {
        return this.endLifeline;
    }

    public void setEndLifeline(Lifeline lifeline) {
        this.endLifeline = lifeline;
    }

    protected void setEventOccurrence(int occurrence) {
        this.endEventOccurrence = occurrence;
    }

    public int getEventOccurrence() {
        return this.endEventOccurrence;
    }

    protected boolean isMessageStartInActivation(int event) {
        boolean inActivation = false;
        if (this.startLifeline != null && this.startLifeline.getExecutions() != null) {
            int thisY = this.getY();
            int i = 0;
            while (i < this.startLifeline.getExecutions().size()) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.startLifeline.getExecutions().get(i);
                if (event >= toDraw.startEventOccurrence && event <= toDraw.endEventOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > thisY) break;
                ++i;
            }
        }
        return inActivation;
    }

    protected boolean isMessageEndInActivation(int event) {
        boolean inActivation = false;
        if (this.endLifeline != null && this.endLifeline.getExecutions() != null) {
            int i = 0;
            while (i < this.endLifeline.getExecutions().size()) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.endLifeline.getExecutions().get(i);
                if (event >= toDraw.startEventOccurrence && event <= toDraw.endEventOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > this.getY()) break;
                ++i;
            }
        }
        return inActivation;
    }

    public boolean contains(int _x, int _y) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int tempHeight = 10 + Metrics.getMessageFontHeigth();
        if (this.startLifeline == this.endLifeline) {
            if (this.getName().length() * Metrics.getAverageCharWidth() > Metrics.swimmingLaneWidth() - 4 + -20 ? Frame.contains(x + 20 + 10, y, Metrics.swimmingLaneWidth() - 4 + -20, Metrics.getMessageFontHeigth(), _x, _y) : Frame.contains(x + 20 + 10, y, this.getName().length() * Metrics.getAverageCharWidth(), Metrics.getMessageFontHeigth(), _x, _y)) {
                return true;
            }
            if (Frame.contains(x, y - 15, 10, 30, _x, _y)) {
                return true;
            }
            if (Frame.contains(x + 20 - 15, y, 30, height + 10, _x, _y)) {
                return true;
            }
            return Frame.contains(x, y + height - 15 + 10, 10, 30, _x, _y);
        }
        return Frame.contains(x, y - tempHeight, width, tempHeight, _x, _y);
    }

    protected void drawMessage(IGC context) {
        int fH = 0;
        int fW = 0;
        int fY = 0;
        int fX = 0;
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if ((this.startLifeline == null || this.endLifeline == null) && this.startLifeline != this.endLifeline) {
            IColor temp = context.getForeground();
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            context.setForeground(temp);
            int margin = 0;
            if (this.endLifeline == null) {
                margin = 5;
            }
            context.drawLine(x, y, x + width, y + height);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width - margin, y + height, x + width - xt.intValue() - margin, y + height - yt.intValue(), x + width - xt.intValue() - margin, y + height + yt.intValue(), x + width - margin, y + height};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - xt.intValue() - margin, y + height - yt.intValue(), x + width - margin, y + height);
                context.drawLine(x + width - xt.intValue() - margin, y + height + yt.intValue(), x + width - margin, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            int ray = 5;
            if (context.getLineWidth() != 1) {
                ray = ray + 5 - 1;
            }
            if (this.startLifeline == null) {
                context.fillOval(x - ray, y - ray, ray * 2, ray * 2);
            } else {
                context.fillOval(x + width - ray, y + height - ray, ray * 2, ray * 2);
            }
            context.setBackground(storedColor);
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            fX = x;
            fY = y - yt.intValue();
            fW = width;
            fH = height + 2 * yt.intValue();
        } else if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline) {
            int tempy = 10;
            tempy = 5;
            context.drawLine(x, y, x + 10, y);
            context.drawLine(x + 20, y + tempy, x + 20, y + height + 10 - tempy);
            context.drawLine(x, y + height + 10, x + 10, y + height + 10);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            fX = x;
            fY = y;
            fW = 20;
            fH = height + 10;
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x, y + height + 10, x + xt.intValue(), y + height + 10 + yt.intValue(), x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + xt.intValue(), y + height + 10 + yt.intValue(), x, y + height + 10);
                context.drawLine(x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            context.drawArc(x, y, 20, 2 * tempy, 0, 90);
            context.drawArc(x, y + 10, 20, -2 * tempy, 0, -90);
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            if (this.startLifeline.getIndex() == this.startLifeline.getFrame().getHorizontalIndex()) {
                context.drawTextTruncated(this.getName(), x + width + 5, y, Metrics.swimmingLaneWidth() / 2 - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                context.drawTextTruncated(this.getName(), x + width + 5, y, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        } else if (this.startLifeline != null && this.endLifeline != null) {
            context.drawLine(x, y, x + width, y + height);
            int spaceBTWStartEnd = this.endLifeline.getX() - this.startLifeline.getX();
            double a = height;
            double b = width;
            double angle = Math.atan(a / b);
            int sign = 1;
            if (spaceBTWStartEnd < 0) {
                sign = -1;
            }
            Double x1 = new Double((double)sign * Math.cos(angle - 0.75) * 7.0);
            Double y1 = new Double((double)sign * Math.sin(angle - 0.75) * 7.0);
            Double x2 = new Double((double)sign * Math.cos(angle + 0.75) * 7.0);
            Double y2 = new Double((double)sign * Math.sin(angle + 0.75) * 7.0);
            fX = this.getX();
            fY = y + height - y2.intValue();
            fW = this.getWidth();
            fH = y2.intValue() - y1.intValue() + 1;
            if (fW < 0) {
                fW = -fW;
                fX -= fW;
            }
            if (fH < 0) {
                fH = -fH;
                fY -= fH;
            }
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height, x + width - x2.intValue(), y + height - y2.intValue(), x + width - x1.intValue(), y + height - y1.intValue()};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height);
                context.drawLine(x + width - x2.intValue(), y + height - y2.intValue(), x + width, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            if (spaceBTWStartEnd > 0) {
                context.drawTextTruncatedCentred(this.getName(), x, y + height / 2 - (20 + Metrics.getMessageFontHeigth()), width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                context.drawTextTruncatedCentred(this.getName(), x + width, y + height / 2 - (20 + Metrics.getMessageFontHeigth()), -width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        }
    }

    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        }
        context.setLineWidth(1);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        this.drawMessage(context);
        int oldStyle = context.getLineStyle();
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
            this.drawFocus(context);
        }
        context.setLineStyle(oldStyle);
    }

    public boolean isSameAs(GraphNode message) {
        if (!(message instanceof BaseMessage)) {
            return super.isSameAs(message);
        }
        if (message == null) {
            // empty if block
        }
        return this.getX() == message.getX() && this.getY() == message.getY() && this.getWidth() == message.getWidth() && this.getHeight() == message.getHeight();
    }

    public void drawRot(int x, int y, int w, int h, IGC context) {
        double angleA = Math.atan2(this.getHeight(), this.getWidth());
        double cosA = Math.cos(angleA);
        double sinA = Math.sin(angleA);
        int gx = this.getX();
        int gy = this.getY();
        h /= 2;
        double cw = Math.sqrt(w * w + this.getHeight() * this.getHeight());
        int x1 = Math.round((float)((double)(x - gx) * cosA - (double)(y - gy) * sinA));
        int y1 = Math.round((float)((double)(x - gx) * sinA + (double)(y - gy) * cosA));
        int x2 = Math.round((float)(cw * cosA - (double)(y - gy) * sinA));
        int y2 = Math.round((float)(cw * sinA + (double)(y - gy) * cosA));
        int x3 = Math.round((float)(cw * cosA - (double)h * sinA));
        int y3 = Math.round((float)(cw * sinA + (double)h * cosA));
        int x4 = Math.round((float)((double)(x - gx) * cosA - (double)h * sinA));
        int y4 = Math.round((float)((double)(x - gx) * sinA + (double)h * cosA));
        int[] points = new int[]{x1 + this.getX(), y1 + this.getY(), x2 + this.getX(), y2 + this.getY(), x3 + this.getX(), y3 + this.getY(), x4 + this.getX(), y4 + this.getY()};
        context.drawPolygon(points);
    }

    public void drawFocus(IGC context) {
        if (this.startLifeline != this.endLifeline && this.startEventOccurrence == this.endEventOccurrence) {
            context.setLineStyle(context.getLineDotStyle());
            context.setLineWidth(1);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
            context.drawFocus(this.getX(), this.getY() - 3, this.getWidth(), this.getHeight() + 6);
        } else if (this.startLifeline == this.endLifeline && this.startEventOccurrence == this.endEventOccurrence) {
            context.drawFocus(this.getX(), this.getY() - 3, this.getWidth(), 16);
        } else if (this.startLifeline != this.endLifeline && this.startEventOccurrence != this.endEventOccurrence) {
            context.setLineStyle(context.getLineDotStyle());
            context.setLineWidth(1);
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE_HEADER"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_LIFELINE_HEADER"));
            this.drawRot(this.getX(), this.getY() - 5, this.getWidth(), 10, context);
        } else {
            super.drawFocus(context);
        }
    }
}

