/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;

public class Lifeline
extends GraphNode {
    protected int indexInFrame = 0;
    protected Frame frame = null;
    protected int eventOccurrence = 0;
    public static final String LIFELINE_TAG = "Lifeline";
    protected int category = -1;
    protected boolean hasTime = false;

    public int getX() {
        return 33 + (this.indexInFrame - 1) * Metrics.swimmingLaneWidth();
    }

    public int getY() {
        return 23 + Metrics.getFrameFontHeigth() + Metrics.getLifelineHeaderFontHeigth() + 10 + 8;
    }

    public int getWidth() {
        return Metrics.getLifelineWidth();
    }

    public int getHeight() {
        return Metrics.getLifelineFontHeigth() + 28;
    }

    public Lifeline() {
        this.prefId = "PREF_LIFELINE";
    }

    public void setCategory(int arrayIndex) {
        this.category = arrayIndex;
    }

    public String getToolTipText() {
        if (this.category >= 0) {
            LifelineCategories[] categories = this.frame.getLifelineCategories();
            if (this.category < categories.length) {
                return String.valueOf(categories[this.category].getName()) + " " + this.getName();
            }
            return "";
        }
        return "";
    }

    public int getExecOccurrenceDrawIndex() {
        if (!this.hasChilds) {
            return 0;
        }
        if (this.indexes.get("Execution_Occ") != null) {
            return (Integer)this.indexes.get("Execution_Occ");
        }
        return 0;
    }

    protected void setFrame(Frame parentFrame) {
        this.frame = parentFrame;
        if (this.hasTime) {
            this.frame.setHasTimeInfo(true);
        }
        if (this.frame.getMaxEventOccurrence() < this.getEventOccurrence() + 1) {
            this.frame.setMaxEventOccurrence(this.getEventOccurrence() + 1);
        }
    }

    protected Frame getFrame() {
        return this.frame;
    }

    protected void setIndex(int index) {
        this.indexInFrame = index;
    }

    public int getIndex() {
        return this.indexInFrame;
    }

    public void setCurrentEventOccurrence(int eventOcc) {
        if (this.frame != null && this.frame.getMaxEventOccurrence() < eventOcc) {
            this.frame.setMaxEventOccurrence(eventOcc);
        }
        this.eventOccurrence = eventOcc;
    }

    public int getEventOccurrence() {
        return this.eventOccurrence;
    }

    public int getNewEventOccurrence() {
        this.setCurrentEventOccurrence(this.eventOccurrence + 1);
        return this.eventOccurrence;
    }

    public void addExecution(BasicExecutionOccurrence exec) {
        exec.setLifeline(this);
        this.addNode(exec);
        if (this.frame != null && this.frame.getMaxEventOccurrence() < exec.endEventOccurrence) {
            this.frame.setMaxEventOccurrence(exec.endEventOccurrence);
        }
    }

    protected void setTimeInfo(boolean value) {
        this.hasTime = value;
        if (this.frame != null && value) {
            this.frame.setHasTimeInfo(value);
        }
    }

    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    public List getExecutions() {
        if (this.hasChilds) {
            return (List)this.nodes.get("Execution_Occ");
        }
        return new ArrayList();
    }

    public boolean contains(int _x, int _y) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.frame == null) {
            return false;
        }
        if (Frame.contains(x, y, width, height, _x, _y)) {
            return true;
        }
        if (Frame.contains(x + Metrics.getLifelineWidth() / 2 - 4, y + height, 8, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.frame.getMaxEventOccurrence() + 20 - 4, _x, _y)) {
            return true;
        }
        height = Metrics.getLifelineFontHeigth() + 8;
        int hMargin = (30 - height) / 2;
        if (hMargin >= 2 && (this.frame.getVisibleAreaY() < y - height - hMargin ? Frame.contains(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height + 1, _x, _y) : Frame.contains(x - 22 + 1, this.frame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height, _x, _y))) {
            return true;
        }
        return this.getNodeAt(_x, _y) != null;
    }

    public boolean isVisible(int vx, int vy, int vwidth, int vheight) {
        int x = this.getX();
        int width = this.getWidth();
        return x >= vx && x <= vx + vwidth || x + width >= vx && x <= vx;
    }

    protected void drawName(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int height = Metrics.getLifelineHeaderFontHeigth() + 8;
        int hMargin = 7;
        context.setLineStyle(context.getLineSolidStyle());
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE_HEADER"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_LIFELINE_HEADER"));
        context.setFont(Frame.getUserPref().getFont("PREF_LIFELINE_HEADER"));
        if (hMargin >= 0) {
            if (this.frame.getVisibleAreaY() < y - height - hMargin) {
                context.fillRectangle(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height);
                context.drawRectangle(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height);
                context.setForeground(Frame.getUserPref().getFontColor("PREF_LIFELINE_HEADER"));
                context.drawTextTruncatedCentred(this.getName(), x + 20 - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 40 - 2, height, true);
            } else {
                context.fillRectangle(x - 22 + 1, this.frame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height);
                context.drawRectangle(x - 22 + 1, this.frame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height);
                context.setForeground(Frame.getUserPref().getFontColor("PREF_LIFELINE_HEADER"));
                context.drawTextTruncatedCentred(this.getName(), x - 22 + 20 + 1, this.frame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 40 - 2, height, true);
            }
        }
    }

    public void draw(IGC context, int x, int y) {
        IImage image;
        LifelineCategories[] categories;
        context.setLineWidth(1);
        if (this.isSelected()) {
            if (Frame.getUserPref().useGradienColor()) {
                context.setGradientColor(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
            }
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            if (Frame.getUserPref().useGradienColor()) {
                context.setGradientColor(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
                context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
            } else {
                context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
            }
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_LIFELINE"));
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (Frame.getUserPref().useGradienColor()) {
            context.fillGradientRectangle(x, y, width, height / 2 - 7, true);
            context.fillRectangle(x, y + height / 2 - 8, width, height / 2 - 5);
            context.fillGradientRectangle(x, y + height, width, -height / 2 + 6, true);
        } else {
            context.fillRectangle(x, y, width, height);
        }
        context.drawRectangle(x, y, width, height);
        if (this.category >= 0 && this.category < (categories = this.frame.getLifelineCategories()).length && (image = categories[this.category].getImage()) != null) {
            context.drawImage(image, x, y, width, height);
        }
        IColor temp = context.getForeground();
        context.setFont(Frame.getUserPref().getFont("PREF_LIFELINE"));
        context.setForeground(Frame.getUserPref().getFontColor("PREF_LIFELINE"));
        context.drawTextTruncatedCentred(this.getName(), x + 20, y, Metrics.getLifelineWidth() - 40, height, true);
        context.setLineStyle(context.getLineDashStyle());
        context.setForeground(temp);
        int oldStyle = context.getLineStyle();
        int dashedLineEnd = y + height + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.frame.getMaxEventOccurrence() + 20;
        if (this.isSelected()) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        }
        context.setLineWidth(1);
        context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
        context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
        context.setLineStyle(oldStyle);
        context.setLineStyle(context.getLineSolidStyle());
        if (this.hasFocus()) {
            this.drawFocus(context);
        }
        super.drawChildsNodes(context);
    }

    public void highlightExecOccurrenceRegion(IGC context, int startEvent, int nbEvent, IColor color) {
        IColor backupColor = context.getBackground();
        context.setBackground(color);
        int x = this.getX() + Metrics.getLifelineWidth() / 2 - 4;
        int y = this.getY() + this.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * startEvent;
        int width = 8;
        int height = (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * nbEvent;
        context.fillRectangle(x, y, width, height);
        context.setBackground(backupColor);
    }

    public void draw(IGC context) {
        this.draw(context, this.getX(), this.getY());
    }

    public String getArrayId() {
        return LIFELINE_TAG;
    }

    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getX() > x - Metrics.swimmingLaneWidth();
    }

    public GraphNode getNodeAt(int x, int y) {
        int vy = 0;
        int vh = 0;
        if (this.getFrame() == null) {
            return null;
        }
        vy = this.getFrame().getVisibleAreaY();
        vh = this.getFrame().getVisibleAreaHeight();
        if (this.getExecutions() == null) {
            return null;
        }
        int i = this.getExecOccurrenceDrawIndex();
        while (i < this.getExecutions().size()) {
            GraphNode node = (GraphNode)this.getExecutions().get(i);
            if (node.getHeight() >= 0 ? node.getY() > vy + vh : node.getY() + node.getHeight() > vy + vh) break;
            if (node.contains(x, y)) {
                GraphNode internal = node.getNodeAt(x, y);
                if (internal != null) {
                    return internal;
                }
                return node;
            }
            ++i;
        }
        return null;
    }
}

