/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiagramToolTip {
    protected Control parent = null;
    protected Shell toolTipShell = null;
    protected String text = null;
    protected Text textBox = null;

    public DiagramToolTip(Control _parent) {
        this.parent = _parent;
        this.toolTipShell = new Shell(this.parent.getShell(), 2);
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.textBox = new Text((Composite)this.toolTipShell, 66);
        this.textBox.setBackground(Display.getDefault().getSystemColor(29));
    }

    public void showToolTip(String value) {
        if (value == null || value.equalsIgnoreCase("")) {
            this.toolTipShell.setVisible(false);
            return;
        }
        this.text = value;
        int w = this.toolTipShell.getBounds().width;
        Point hr = Display.getDefault().getCursorLocation();
        int cursorH = 32;
        int i = 0;
        while (i < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[i].y < cursorH) {
                cursorH = Display.getDefault().getCursorSizes()[i].y;
            }
            ++i;
        }
        if (hr.x + w > Display.getDefault().getBounds().width) {
            int tempX = hr.x + w - Display.getDefault().getBounds().width;
            if (tempX > Display.getDefault().getBounds().width) {
                hr.x = 0;
            }
            hr.x -= tempX;
        }
        this.textBox.setText(value);
        int charactersPerColumn = 50;
        GC gc = new GC((Drawable)this.textBox);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int width = charactersPerColumn * fm.getAverageCharWidth();
        this.textBox.setSize(this.textBox.computeSize(width, this.textBox.getLineCount() * this.textBox.getLineHeight()));
        this.toolTipShell.setLocation(hr.x, hr.y + cursorH);
        this.toolTipShell.setSize(this.textBox.getSize());
        this.textBox.setVisible(true);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }
}

