/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class SDUtil {
    protected static SDUtil instance;
    public static final String LOADER_TAG = "uml2SDLoader";
    public static final String LOADER_PREFIX = "uml2SDLoader.";
    protected static HashMap viewLoadersList;
    protected static URL BASIC_URL;

    static {
        viewLoadersList = new HashMap();
        BASIC_URL = null;
        try {
            BASIC_URL = new URL("platform", "localhost", "plugin");
        }
        catch (Exception E) {
            System.err.println(E);
        }
    }

    public SDUtil() {
        if (instance == null) {
            instance = this;
        }
    }

    public static ImageDescriptor getResourceImage(String _name) {
        try {
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.hyades.ui/icons/" + _name);
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)url);
            return img;
        }
        catch (Exception E) {
            System.err.println(E);
            return null;
        }
    }

    public static List getLoaders(String viewId) {
        IExtension[] hyadesUIExtensions;
        List list = (List)viewLoadersList.get(viewId);
        if (list != null) {
            return list;
        }
        ArrayList<IConfigurationElement> ret = new ArrayList<IConfigurationElement>();
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.common.ui", LOADER_TAG);
        IExtension[] commonUIExtensions = iep.getExtensions();
        IExtension[] ie = null;
        iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", LOADER_TAG);
        if (iep != null && (hyadesUIExtensions = iep.getExtensions()) != null && hyadesUIExtensions.length > 0) {
            ie = new IExtension[commonUIExtensions.length + hyadesUIExtensions.length];
            System.arraycopy(commonUIExtensions, 0, ie, 0, commonUIExtensions.length);
            System.arraycopy(hyadesUIExtensions, 0, ie, commonUIExtensions.length, hyadesUIExtensions.length);
        }
        if (ie == null) {
            ie = commonUIExtensions;
        }
        int i = 0;
        while (i < ie.length) {
            IConfigurationElement[] c = ie[i].getConfigurationElements();
            int j = 0;
            while (j < c.length) {
                if (viewId.equals(c[j].getAttribute("view"))) {
                    ret.add(c[j]);
                }
                ++j;
            }
            ++i;
        }
        viewLoadersList.put(viewId, ret);
        return ret;
    }

    public static void createLoaderForView(String viewId, IConfigurationElement ce) {
        try {
            Object obj = ce.createExecutableExtension("class");
            IUml2SDLoader l = (IUml2SDLoader)obj;
            if (viewId != null) {
                LoadersManager.getLoadersManager().setCurrentLoader(l, viewId);
            }
        }
        catch (CoreException e4) {
            System.err.println("Error 'uml2SDLoader' Extension point :" + (Object)((Object)e4));
        }
        catch (Exception e5) {
            e5.printStackTrace();
            System.err.println("Error 'uml2SDLoader' Extension point :" + e5);
        }
    }

    public String getSavedLoader(String viewId) {
        Preferences p = CommonUIPlugin.getDefault().getPluginPreferences();
        return p.getString(LOADER_PREFIX + viewId);
    }

    public void setLastLoader(String id, String id2) {
        Preferences p = CommonUIPlugin.getDefault().getPluginPreferences();
        p.setValue(LOADER_PREFIX + id2, id);
    }

    public static SDUtil getInstance() {
        if (instance == null) {
            instance = new SDUtil();
        }
        return instance;
    }
}

