/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.util.UIAgentControllerFactory;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.eclipse.tptp.platform.execution.util.internal.IAgentControllerFactory;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CommonUIPlugin
extends AbstractUIPlugin {
    protected static final String KEYSTORE = "keystore.dat";
    public static final String EP_NAVIGATOR_EXTENSIONS = "navigatorExtensions";
    public static final String PLUGIN_ID = "org.eclipse.tptp.platform.common.ui";
    public static final String EP_REPORT_EXTENSIONS = "reportExtensions";
    protected static CommonUIPlugin plugin;

    public CommonUIPlugin() {
        plugin = this;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        HierarchyPackageImpl.init();
        AgentControllerPool.setAgentControllerFactory((IAgentControllerFactory)new UIAgentControllerFactory());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CommonUIPlugin getDefault() {
        return plugin;
    }

    public boolean openPerspectiveSwitchDialog(Shell shell, String perspectiveId, IPreferenceStore preferenceStore, String preferenceKey, String message) {
        if (this.isCurrentPerspective(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String preferenceValue = preferenceStore.getString(preferenceKey);
        if (preferenceValue == null || preferenceValue.length() == 0) {
            preferenceValue = "prompt";
            preferenceStore.setValue(preferenceKey, preferenceValue);
        }
        boolean saveAndChange = false;
        if ("prompt".equals(preferenceValue)) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)CommonUIMessages._52, (String)MessageFormat.format((String)message, (Object[])new String[]{perspectiveName}), null, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
            boolean bl = saveAndChange = dialog.getReturnCode() == 2;
        }
        if (!this.getContributions(perspectiveId)) {
            return false;
        }
        preferenceValue = preferenceStore.getString(preferenceKey);
        if ("always".equals(preferenceValue)) {
            return true;
        }
        return saveAndChange && !"never".equals(preferenceValue);
    }

    protected boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    protected boolean getContributions(String perspectiveId) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(perspectiveId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            CommonPlugin.logError((String)("Unable to find perspective " + perspectiveId));
            return false;
        }
        return true;
    }

    protected String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    public String getWorkspaceName() {
        IPath workspace = Platform.getLocation();
        int nr = workspace.segmentCount();
        return workspace.segment(nr - 1);
    }

    public static String getKeyStoreLocation() {
        return Platform.getPluginStateLocation((Plugin)plugin).append(KEYSTORE).toOSString();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("switch_to_perspective", "prompt");
        store.setDefault("localhost_port", "10002");
    }

    public static void log(Throwable e) {
        String msg = e.getMessage();
        CommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, msg == null ? "" : msg, e));
    }
}

