/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.internal.util;

import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.security.internal.util.ConnectUtilUI;
import org.eclipse.hyades.security.internal.util.IConnectUtilUser;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerFactory;

public class UIAgentControllerFactory
extends AgentControllerFactory {
    public org.eclipse.tptp.platform.execution.security.User promptAuthentication(String hostName, String userName) {
        ConnectUtilUI cui = new ConnectUtilUI();
        IConnectUtilUser cuUser = cui.promptAuthentication(hostName, userName);
        if (cuUser == null) {
            return null;
        }
        return new org.eclipse.tptp.platform.execution.security.User(null, cuUser.getName(), cuUser.getPassword());
    }

    public org.eclipse.tptp.platform.execution.security.User findUser(String hostName) {
        org.eclipse.tptp.platform.execution.security.User user = this.findUserForHost(hostName);
        if (user != null) {
            return user;
        }
        if ("localhost".equals(hostName)) {
            return this.findUserForHost(null);
        }
        return null;
    }

    protected org.eclipse.tptp.platform.execution.security.User findUserForHost(String hostName) {
        Node node;
        try {
            node = hostName != null ? NodeFactory.getNode((String)hostName, null) : NodeFactory.getNode((InetAddress)InetAddress.getLocalHost(), null);
        }
        catch (Exception exception) {
            node = null;
        }
        if (node == null || !node.isConnected()) {
            return null;
        }
        User hyadesUser = node.getUser();
        if (hyadesUser == null) {
            return null;
        }
        HyadesConnection con = new HyadesConnection();
        try {
            hyadesUser.login((Connection)con);
        }
        catch (Exception exception) {}
        return con.getUser();
    }

    class HyadesConnection
    implements Connection {
        public org.eclipse.tptp.platform.execution.security.User user = null;

        HyadesConnection() {
        }

        public void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException {
            int count = msg.getSize();
            if (count <= 1) {
                return;
            }
            CommandElement ce = msg.getCommand(0);
            if (!(ce instanceof AuthenticateCommand)) {
                return;
            }
            AuthenticateCommand acmd = (AuthenticateCommand)ce;
            byte[] buf = new byte[acmd.getSize()];
            acmd.writeToBuffer(buf, 0);
            RAString hyadesName = new RAString();
            RAString hyadesPsw = new RAString();
            int offset = Message.readRAStringFromBuffer((byte[])buf, (int)4, (RAString)hyadesName);
            Message.readRAStringFromBuffer((byte[])buf, (int)offset, (RAString)hyadesPsw);
            this.user = new org.eclipse.tptp.platform.execution.security.User(null, hyadesName.getData(), hyadesPsw.getData());
        }

        public void addAuthenticationListener(AuthenticationListener listener) {
        }

        public void addConnectionListener(ConnectionListener listener) {
        }

        public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        }

        public void disconnect() {
        }

        public Node getNode() {
            return null;
        }

        public int getPort() {
            return 0;
        }

        public boolean isActive() {
            return false;
        }

        public void removeAuthenticationListener(AuthenticationListener listener) {
        }

        public void removeConnectionListener(ConnectionListener listener) {
        }

        public org.eclipse.tptp.platform.execution.security.User getUser() {
            return this.user;
        }
    }
}

