/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class UIUtil {
    public static ImageDescriptor getImageDescriptorFromPlugin(Bundle plugin, String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(plugin.getEntry("/"), path));
        }
        catch (MalformedURLException malformedURLException) {
            CommonPlugin.logError((String)NLS.bind((String)CommonUIMessages.UIUtil_ERROR_RESOLVING_IMAGE, (Object)path, (Object)plugin.getSymbolicName()));
            return null;
        }
    }

    public static boolean areEquals(ISelection selection1, ISelection selection2) {
        if (selection1 == selection2) {
            return true;
        }
        if (selection1 instanceof IStructuredSelection && selection2 instanceof IStructuredSelection) {
            ArrayList list1 = new ArrayList(((IStructuredSelection)selection1).toList());
            ArrayList list2 = new ArrayList(((IStructuredSelection)selection2).toList());
            if (list1.size() == list2.size()) {
                list1.removeAll(list2);
                return list1.isEmpty();
            }
        }
        return false;
    }

    public static IElementFactory getElementFactory(String factoryId) {
        return PlatformUI.getWorkbench().getElementFactory(factoryId);
    }

    public static int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    public static Set getVisibleViewerNodes(TreeViewer viewer) {
        HashSet set = new HashSet();
        ITreeContentProvider content = (ITreeContentProvider)viewer.getContentProvider();
        Object[] top = content.getElements(viewer.getInput());
        int i = 0;
        while (i < top.length) {
            UIUtil.collectVisibleElements(viewer, content, top[i], set);
            ++i;
        }
        return set;
    }

    protected static void collectVisibleElements(TreeViewer viewer, ITreeContentProvider content, Object current, Set set) {
        set.add(current);
        if (viewer.getExpandedState(current)) {
            Object[] children = content.getChildren(current);
            int i = 0;
            while (i < children.length) {
                UIUtil.collectVisibleElements(viewer, content, children[i], set);
                ++i;
            }
        }
    }

    public static void setVisibleViewerNodes(TreeViewer viewer, Set set) {
        viewer.expandAll();
        viewer.collapseAll();
        for (Object obj : set) {
            ITreeContentProvider content = (ITreeContentProvider)viewer.getContentProvider();
            Object[] top = content.getElements(viewer.getInput());
            int i = 0;
            while (i < top.length) {
                UIUtil.hasElement(viewer, content, top[i], obj);
                ++i;
            }
        }
    }

    protected static boolean hasElement(TreeViewer viewer, ITreeContentProvider content, Object current, Object target) {
        if (current == target) {
            return true;
        }
        Object[] children = content.getChildren(current);
        boolean found = false;
        int i = 0;
        while (i < children.length) {
            if (UIUtil.hasElement(viewer, content, children[i], target)) {
                found = true;
            }
            ++i;
        }
        if (found) {
            viewer.setExpandedState(current, true);
        }
        return found;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = null;
        if (workbench.getActiveWorkbenchWindow() != null) {
            activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        } else if (workbench.getWorkbenchWindows().length > 0) {
            activePage = workbench.getWorkbenchWindows()[0].getActivePage();
        }
        return activePage;
    }

    public static void openSaveFileErrorDialog(Shell shell, String filePath, Throwable throwable) {
        if (filePath == null) {
            filePath = "";
        }
        String error = "";
        if (throwable != null) {
            if (throwable.getLocalizedMessage() != null) {
                error = throwable.getLocalizedMessage();
            } else if (throwable.getMessage() != null) {
                error = throwable.getMessage();
            }
        }
        String message = NLS.bind((String)CommonUIMessages._48, (Object[])new String[]{filePath, error});
        MessageDialog.openError((Shell)shell, (String)CommonUIMessages._8, (String)message);
    }

    public static IEditorPart openEditor(IFile file, String editorId, boolean substring) {
        IWorkbenchPage activeWorkbenchPage;
        if (file != null && (activeWorkbenchPage = UIUtil.getActiveWorkbenchPage()) != null) {
            try {
                file.refreshLocal(0, null);
                if (editorId == null || editorId.trim().length() == 0) {
                    return IDE.openEditor((IWorkbenchPage)activeWorkbenchPage, (IFile)file, (boolean)true);
                }
                IEditorDescriptor[] editors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(file.getName());
                if (editors != null) {
                    boolean editorFound = false;
                    int counter = 0;
                    while (counter < editors.length) {
                        editorFound = substring ? editors[counter].getId().startsWith(editorId) : editorId.equals(editors[counter].getId());
                        if (editorFound) {
                            return IDE.openEditor((IWorkbenchPage)activeWorkbenchPage, (IEditorInput)new FileEditorInput(file), (String)editors[counter].getId());
                        }
                        ++counter;
                    }
                }
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        return null;
    }

    public static IEditorPart openEditor(IEditorInput editorInput, String editorId) {
        IWorkbenchPage activeWorkbenchPage;
        if (editorInput != null && editorId != null && editorId.trim().length() > 0 && (activeWorkbenchPage = UIUtil.getActiveWorkbenchPage()) != null) {
            try {
                return IDE.openEditor((IWorkbenchPage)activeWorkbenchPage, (IEditorInput)editorInput, (String)editorId.trim());
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        return null;
    }
}

