/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.ui.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.util.LocationValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.wizard.ICustomLocationNameValidation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

public class LocationPage
extends WizardPage
implements Listener {
    private Text containerFullPathText = null;
    private TreeViewer treeViewer = null;
    private Text fileNameText = null;
    private List filters = null;
    private ICustomLocationNameValidation nameValidator = null;
    private IStructuredSelection initialSelection = null;
    private IPath initialContainerFullPath = null;
    private String initialFileName = null;
    private String fileExtension = null;
    private Image fileImage = null;
    private boolean allowOverwrite = false;
    private boolean displayFiles = false;
    private String newProjectWizardCategory = null;
    private IWorkspaceRoot workspaceRoot = null;
    private static final int TREE_HEIGHT_HINT = 250;
    private static final int TEXT_WIDTH_HINT = 200;

    public LocationPage(String pageName, IStructuredSelection initialSelection) {
        super(pageName);
        this.initialSelection = initialSelection;
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public IPath getContainerFullPath() {
        String containerFullPath;
        if (this.containerFullPathText != null && (containerFullPath = this.containerFullPathText.getText()).length() > 0) {
            return new Path(TextProcessor.deprocess((String)containerFullPath)).makeAbsolute();
        }
        return this.initialContainerFullPath;
    }

    public String getItemName() {
        return this.getFileName();
    }

    public String getFileName() {
        if (this.fileNameText != null) {
            return this.addFileExtension(this.fileNameText.getText());
        }
        return this.initialFileName;
    }

    public String getFileNameWithoutExtension() {
        if (this.fileNameText != null) {
            return this.removeFileExtension(this.fileNameText.getText());
        }
        return this.initialFileName;
    }

    public String getFilePath() {
        IPath containerFullPath = this.getContainerFullPath();
        String fileName = this.getFileName();
        if (containerFullPath != null && fileName != null && fileName.length() > 0) {
            return containerFullPath.append(fileName).toString();
        }
        return null;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public boolean getDisplayFiles() {
        return this.displayFiles;
    }

    public boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public void setContainerFullPath(IPath containerFullPath) {
        if (this.containerFullPathText != null) {
            IContainer container = this.getContainer(containerFullPath);
            if (container != null) {
                this.updateSelection((IStructuredSelection)new StructuredSelection((Object)container));
            } else {
                this.updateContainerFullPath(containerFullPath);
            }
        } else {
            this.initialContainerFullPath = containerFullPath;
        }
    }

    public void setFileName(String fileName) {
        if (this.fileNameText != null) {
            IFile file = this.getFile(fileName);
            if (file != null) {
                this.updateSelection((IStructuredSelection)new StructuredSelection((Object)file));
            } else {
                this.updateFileName(fileName);
            }
        } else {
            this.initialFileName = fileName;
        }
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setFileImage(Image fileImage) {
        this.fileImage = fileImage;
    }

    public void setDisplayFiles(boolean displayFiles) {
        this.displayFiles = displayFiles;
        this.setAllowOverwrite(displayFiles);
    }

    public void setAllowExistingResources(boolean allowExistingResources) {
        this.setAllowOverwrite(allowExistingResources);
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public void setNewProjectWizardCategory(String newProjectWizardCategory) {
        this.newProjectWizardCategory = newProjectWizardCategory;
    }

    public void setNameValidator(ICustomLocationNameValidation nameValidator) {
        this.nameValidator = nameValidator;
    }

    public void addFilter(IFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filter);
        if (this.treeViewer != null) {
            this.treeViewer.refresh();
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout twoColumnGridLayout = new GridLayout(2, false);
        twoColumnGridLayout.marginWidth = 0;
        twoColumnGridLayout.marginHeight = 0;
        GridData textGridData = new GridData(4, 0x1000000, true, false);
        textGridData.widthHint = 200;
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.heightHint = 250;
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout());
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        topComposite.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topComposite, "org.eclipse.ui.ide.new_file_wizard_page_context");
        Label containerLabel = new Label(topComposite, 64);
        containerLabel.setText(CommonUIMessages.LocationPage_CONTAINER_LABEL_TEXT);
        Composite containerComposite = new Composite(topComposite, 0);
        containerComposite.setLayout((Layout)twoColumnGridLayout);
        containerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.containerFullPathText = new Text(containerComposite, 2052);
        this.containerFullPathText.setLayoutData((Object)textGridData);
        this.containerFullPathText.addListener(24, (Listener)this);
        ToolBar newContainerToolBar = new ToolBar(containerComposite, 0x800000);
        ToolItem newContainerToolItem = new ToolItem(newContainerToolBar, 0x800004);
        newContainerToolItem.setImage(CommonUIImages.INSTANCE.getImage("e", "new_wiz.gif"));
        newContainerToolItem.setDisabledImage(CommonUIImages.INSTANCE.getImage("d", "new_wiz.gif"));
        newContainerToolItem.setToolTipText(CommonUIMessages.LocationPage_NEW_CONTAINER_TOOL_ITEM_TOOL_TIP);
        newContainerToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Menu menu = null;
            private IProject newProject = null;
            private IFolder newFolder = null;

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (this.menu == null) {
                    IExtensionPoint extensionPoint;
                    this.menu = new Menu((Control)LocationPage.this.getShell());
                    final IResourceChangeListener newProjectListener = new IResourceChangeListener(){

                        public void resourceChanged(IResourceChangeEvent resourceChangeEvent) {
                            IResourceDelta delta = resourceChangeEvent.getDelta();
                            if (delta != null) {
                                try {
                                    delta.accept(new IResourceDeltaVisitor(){

                                        public boolean visit(IResourceDelta delta) throws CoreException {
                                            IResource newResource = delta.getResource();
                                            int resourceType = newResource.getType();
                                            if (resourceType == 4 && delta.getKind() == 1) {
                                                newProject = (IProject)newResource;
                                            }
                                            return resourceType != 1;
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    CommonUIPlugin.log(e);
                                }
                            }
                        }
                    };
                    final IResourceChangeListener newFolderListener = new IResourceChangeListener(){

                        public void resourceChanged(IResourceChangeEvent resourceChangeEvent) {
                            IResourceDelta delta = resourceChangeEvent.getDelta();
                            if (delta != null) {
                                try {
                                    delta.accept(new IResourceDeltaVisitor(){

                                        public boolean visit(IResourceDelta delta) throws CoreException {
                                            IResource newResource = delta.getResource();
                                            int resourceType = newResource.getType();
                                            if (resourceType == 2 && delta.getKind() == 1) {
                                                newFolder = (IFolder)newResource;
                                            }
                                            return resourceType != 1;
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    CommonUIPlugin.log(e);
                                }
                            }
                        }
                    };
                    int newProjectWizardMenuCount = 0;
                    if (LocationPage.this.newProjectWizardCategory != null && (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.newWizards")) != null) {
                        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
                        int counter = 0;
                        while (counter < configurationElements.length) {
                            final IConfigurationElement configurationElement = configurationElements[counter];
                            if ("wizard".equals(configurationElement.getName()) && Boolean.parseBoolean(configurationElement.getAttribute("project")) && LocationPage.this.newProjectWizardCategory.equals(configurationElement.getAttribute("category"))) {
                                MenuItem newProjectMenuItem = new MenuItem(this.menu, 0);
                                newProjectMenuItem.setText(configurationElement.getAttribute("name"));
                                Image newProjectMenuItemImage = null;
                                try {
                                    newProjectMenuItemImage = ImageDescriptor.createFromURL((URL)new URL(Platform.getBundle((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier()).getEntry("/"), configurationElement.getAttribute("icon"))).createImage(false);
                                }
                                catch (Exception e) {
                                    CommonUIPlugin.log(e);
                                }
                                if (newProjectMenuItemImage != null) {
                                    newProjectMenuItem.setImage(newProjectMenuItemImage);
                                } else {
                                    newProjectMenuItem.setImage(CommonUIImages.INSTANCE.getImage("e", "new_wiz.gif"));
                                }
                                newProjectMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent selectionEvent) {
                                        menu.setVisible(false);
                                        try {
                                            try {
                                                INewWizard newProjectWizard = (INewWizard)configurationElement.createExecutableExtension("class");
                                                newProjectWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)LocationPage.this.treeViewer.getSelection());
                                                WizardDialog newProjectWizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newProjectWizard);
                                                newProjectWizardDialog.create();
                                                newProject = null;
                                                ResourcesPlugin.getWorkspace().addResourceChangeListener(newProjectListener, 1);
                                                if (newProjectWizardDialog.open() == 0 && newProject != null) {
                                                    LocationPage.this.treeViewer.refresh(true);
                                                    LocationPage.this.updateSelection((IStructuredSelection)new StructuredSelection((Object)newProject));
                                                }
                                            }
                                            catch (Exception e) {
                                                CommonUIPlugin.log(e);
                                                ResourcesPlugin.getWorkspace().removeResourceChangeListener(newProjectListener);
                                            }
                                        }
                                        finally {
                                            ResourcesPlugin.getWorkspace().removeResourceChangeListener(newProjectListener);
                                        }
                                    }
                                });
                                ++newProjectWizardMenuCount;
                            }
                            ++counter;
                        }
                    }
                    MenuItem newProjectMenuItem = new MenuItem(this.menu, 0);
                    newProjectMenuItem.setText(CommonUIMessages.LocationPage_NEW_PROJECT_MENU_ITEM_TEXT);
                    newProjectMenuItem.setImage(CommonUIImages.INSTANCE.getImage("e", "new_wiz.gif"));
                    newProjectMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
                        private NewProjectAction newProjectAction = null;

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            menu.setVisible(false);
                            try {
                                newProject = null;
                                ResourcesPlugin.getWorkspace().addResourceChangeListener(newProjectListener, 1);
                                if (this.newProjectAction == null) {
                                    this.newProjectAction = new NewProjectAction();
                                }
                                this.newProjectAction.run();
                                if (newProject != null) {
                                    LocationPage.this.treeViewer.refresh(true);
                                    LocationPage.this.updateSelection((IStructuredSelection)new StructuredSelection((Object)newProject));
                                }
                            }
                            finally {
                                ResourcesPlugin.getWorkspace().removeResourceChangeListener(newProjectListener);
                            }
                        }
                    });
                    new MenuItem(this.menu, 2);
                    MenuItem newFolderMenuItem = new MenuItem(this.menu, 0);
                    newFolderMenuItem.setText(CommonUIMessages.LocationPage_NEW_FOLDER_MENU_ITEM_TEXT);
                    newFolderMenuItem.setImage(CommonUIImages.INSTANCE.getImage("e", "newfolder_wiz.gif"));
                    newFolderMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            menu.setVisible(false);
                            BasicNewFolderResourceWizard newFolderWizard = new BasicNewFolderResourceWizard();
                            newFolderWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)LocationPage.this.treeViewer.getSelection());
                            WizardDialog newFolderWizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newFolderWizard);
                            newFolderWizardDialog.create();
                            try {
                                newFolder = null;
                                ResourcesPlugin.getWorkspace().addResourceChangeListener(newFolderListener, 1);
                                if (newFolderWizardDialog.open() == 0 && newFolder != null) {
                                    LocationPage.this.treeViewer.refresh(true);
                                    LocationPage.this.updateSelection((IStructuredSelection)new StructuredSelection((Object)newFolder));
                                }
                            }
                            finally {
                                ResourcesPlugin.getWorkspace().removeResourceChangeListener(newFolderListener);
                            }
                        }
                    });
                }
                if (selectionEvent.detail == 4) {
                    boolean isMenuVisible = this.menu.getVisible();
                    if (!isMenuVisible) {
                        ToolItem toolItem = (ToolItem)selectionEvent.widget;
                        Rectangle toolItemBounds = toolItem.getBounds();
                        Point position = toolItem.getParent().toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                        this.menu.setLocation(position.x, position.y + toolItemBounds.height);
                    }
                    this.menu.setVisible(!isMenuVisible);
                } else {
                    MenuItem[] menuItems = this.menu.getItems();
                    int counter = 0;
                    while (counter < menuItems.length) {
                        if (menuItems[counter] != null && (menuItems[counter].getStyle() & 2) == 0) {
                            Event menuSelectionEvent = new Event();
                            menuSelectionEvent.type = 13;
                            menuSelectionEvent.widget = menuItems[counter];
                            menuItems[counter].notifyListeners(13, menuSelectionEvent);
                            break;
                        }
                        ++counter;
                    }
                }
            }
        });
        DrillDownComposite drillDown = new DrillDownComposite(topComposite, 2048);
        drillDown.setLayoutData((Object)treeGridData);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object element) {
                IContainer container;
                if (element instanceof IWorkspace) {
                    ArrayList<IProject> openProjects = new ArrayList<IProject>();
                    IProject[] projects = ((IWorkspace)element).getRoot().getProjects();
                    int counter = 0;
                    while (counter < projects.length) {
                        if (!LocationPage.this.isFiltered(projects[counter]) && projects[counter].isOpen()) {
                            openProjects.add(projects[counter]);
                        }
                        ++counter;
                    }
                    return openProjects.toArray();
                }
                if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                    try {
                        ArrayList<IResource> children = new ArrayList<IResource>();
                        IResource[] members = container.members();
                        int counter = 0;
                        while (counter < members.length) {
                            if (!LocationPage.this.isFiltered(members[counter]) && (members[counter].getType() != 1 || LocationPage.this.isDisplayed((IFile)members[counter]))) {
                                children.add(members[counter]);
                            }
                            ++counter;
                        }
                        return children.toArray();
                    }
                    catch (CoreException e) {
                        CommonUIPlugin.log(e);
                    }
                }
                return new Object[0];
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()){

            public Image getImage(Object element) {
                if (LocationPage.this.fileImage != null && element instanceof IFile && LocationPage.this.containsFileExtension(((IFile)element).getName())) {
                    return LocationPage.this.fileImage;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                return LocationPage.this.removeFileExtension(super.getText(element));
            }
        });
        this.treeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IResource resource = LocationPage.this.getResource((IStructuredSelection)selection);
                    if (resource instanceof IContainer) {
                        LocationPage.this.updateContainerFullPath(((IContainer)resource).getFullPath());
                    } else if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        LocationPage.this.updateContainerFullPath(file.getParent().getFullPath());
                        LocationPage.this.updateFileName(file.getName());
                    }
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) != null) {
                    if (LocationPage.this.treeViewer.getExpandedState(selectedElement)) {
                        LocationPage.this.treeViewer.collapseToLevel(selectedElement, 1);
                    } else {
                        LocationPage.this.treeViewer.expandToLevel(selectedElement, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)this.workspaceRoot);
        drillDown.setChildTree(this.treeViewer);
        Composite fileComposite = new Composite(topComposite, 0);
        fileComposite.setLayout((Layout)twoColumnGridLayout);
        fileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label fileNameLabel = new Label(fileComposite, 64);
        fileNameLabel.setText(CommonUIMessages.LocationPage_NAME_LABEL_TEXT);
        this.fileNameText = new Text(fileComposite, 2048);
        this.fileNameText.setLayoutData((Object)textGridData);
        this.fileNameText.addListener(24, (Listener)this);
        this.createAdvancedControls(topComposite);
        if (this.initialSelection != null) {
            this.updateSelection(this.initialSelection);
        }
        if (this.initialContainerFullPath != null) {
            IContainer container = this.getContainer(this.initialContainerFullPath);
            if (container != null) {
                this.updateSelection((IStructuredSelection)new StructuredSelection((Object)container));
            } else {
                this.updateContainerFullPath(this.initialContainerFullPath);
            }
        }
        if (this.containerFullPathText.getText().length() == 0) {
            IProject[] projects = this.workspaceRoot.getProjects();
            int counter = 0;
            while (counter < projects.length) {
                if (projects[counter].isAccessible()) {
                    this.updateSelection((IStructuredSelection)new StructuredSelection((Object)projects[counter]));
                    break;
                }
                ++counter;
            }
        }
        if (this.initialFileName != null) {
            IFile file = this.getFile(this.initialFileName);
            if (file != null) {
                this.updateSelection((IStructuredSelection)new StructuredSelection((Object)file));
            } else {
                this.updateFileName(this.initialFileName);
            }
        }
        this.setPageComplete(this.validatePage(false));
        this.setMessage(null);
        this.setErrorMessage(null);
        Dialog.applyDialogFont((Control)topComposite);
        this.setControl((Control)topComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileNameText.selectAll();
            this.fileNameText.setFocus();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage(true));
    }

    public boolean isPageComplete() {
        return this.validatePage(false);
    }

    public IFile createNewFile() {
        String filePath = this.getFilePath();
        if (filePath != null) {
            final IFile file = this.workspaceRoot.getFile((IPath)new Path(filePath));
            if (!file.isAccessible()) {
                try {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                new CreateFileOperation(file, null, null, CommonUIMessages.LocationPage_CREATE_FILE_OPERATION_LABEL).execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)LocationPage.this.getShell()));
                            }
                            catch (Exception e) {
                                CommonUIPlugin.log(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    CommonUIPlugin.log(e);
                }
            }
            if (file.isAccessible()) {
                return file;
            }
        }
        return null;
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected boolean validatePage() {
        return this.validatePage(true);
    }

    protected TreeViewer internal_getTreeViewer() {
        return this.treeViewer;
    }

    protected boolean validatePage(boolean updateMessage) {
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath == null) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_MISSING_CONTAINER_ERROR_);
            }
            return false;
        }
        String invalidCharacter = LocationValidator.validatePath(containerFullPath);
        if (invalidCharacter != null) {
            if (updateMessage) {
                this.setMessage(null);
                if ("Invalid Path".equals(invalidCharacter)) {
                    this.setErrorMessage(CommonUIMessages.LocationPage_INVALID_CONTAINER_ERROR_);
                } else {
                    this.setErrorMessage(NLS.bind((String)CommonUIMessages.LocationPage_INVALID_CONTAINER_CHARS_ERROR_, (Object)invalidCharacter));
                }
            }
            return false;
        }
        String fileNameWithoutExtension = this.getFileNameWithoutExtension();
        if (fileNameWithoutExtension == null || fileNameWithoutExtension.trim().length() == 0) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_MISSING_NAME_ERROR_);
            }
            return false;
        }
        if (fileNameWithoutExtension.trim().startsWith(".")) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_INVALID_NAME_PERIOD_ERROR_);
            }
            return false;
        }
        invalidCharacter = LocationValidator.validateOSFileName(this.getFileName());
        if (invalidCharacter != null) {
            if (updateMessage) {
                this.setMessage(null);
                if (invalidCharacter.trim().equals("-")) {
                    this.setErrorMessage(CommonUIMessages.LocationPage_INVALID_NAME_DASH_ERROR_);
                } else if ("Invalid Path".equals(invalidCharacter)) {
                    this.setErrorMessage(CommonUIMessages.LocationPage_INVALID_NAME_ERROR_);
                } else {
                    this.setErrorMessage(NLS.bind((String)CommonUIMessages.LocationPage_INVALID_NAME_CHARS_ERROR_, (Object)invalidCharacter));
                }
            }
            return false;
        }
        IFile file = this.workspaceRoot.getFile((IPath)new Path(this.getFilePath()));
        if (this.nameValidator != null && !this.nameValidator.isNameValid(file.getName(), file.getParent())) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_INVALID_NAME_ERROR_);
            }
            return false;
        }
        IProject project = file.getProject();
        if (project == null || !project.exists()) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_NO_PROJECT_ERROR_);
            }
            return false;
        }
        if (!this.allowOverwrite && file.exists()) {
            if (updateMessage) {
                this.setMessage(null);
                this.setErrorMessage(CommonUIMessages.LocationPage_EXISTING_NAME_ERROR_);
            }
            return false;
        }
        if (!this.workspaceRoot.getWorkspace().validateFiltered((IResource)file).isOK()) {
            if (updateMessage) {
                this.setMessage(CommonUIMessages.LocationPage_FILTERED_NAME_WARNING_, 2);
                this.setErrorMessage(null);
            }
            return false;
        }
        if (updateMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return true;
    }

    private void updateContainerFullPath(IPath containerFullPath) {
        if (containerFullPath != null) {
            String containerFullPathString = TextProcessor.process((String)containerFullPath.makeRelative().toString());
            this.containerFullPathText.setText(containerFullPathString);
            this.containerFullPathText.setToolTipText(containerFullPathString);
        }
        this.validatePage(true);
    }

    private void updateFileName(String fileName) {
        String fileNameWithExtension = this.removeFileExtension(fileName);
        if (fileNameWithExtension != null) {
            this.fileNameText.setText(fileNameWithExtension);
            this.fileNameText.setToolTipText(fileNameWithExtension);
        }
        this.validatePage(true);
    }

    private void updateSelection(IStructuredSelection selection) {
        IResource resource = this.getResource(selection);
        if (resource != null) {
            IContainer parentContainer = resource.getParent();
            if (parentContainer != null) {
                this.treeViewer.expandToLevel((Object)parentContainer, 1);
            }
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
        }
        Event selectionEvent = new Event();
        selectionEvent.type = 13;
        selectionEvent.widget = this.treeViewer.getTree();
        this.handleEvent(selectionEvent);
    }

    private IFile getFile(String fileName) {
        IFile file;
        IResource resource;
        IPath containerFullPath;
        if (fileName != null && fileName.length() > 0 && (containerFullPath = this.getContainerFullPath()) != null && (resource = this.workspaceRoot.findMember(containerFullPath.append(this.addFileExtension(fileName)))) instanceof IFile && this.isDisplayed(file = (IFile)resource)) {
            return file;
        }
        return null;
    }

    private IContainer getContainer(IPath path) {
        IResource resource;
        if (path != null && (resource = this.workspaceRoot.findMember(path)) != null) {
            if (resource instanceof IContainer) {
                return (IContainer)resource;
            }
            return resource.getParent();
        }
        return null;
    }

    private IResource getResource(IStructuredSelection selection) {
        if (selection != null) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof IResource) {
                return (IResource)selectedObject;
            }
            if (selectedObject instanceof IAdaptable) {
                return (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
            }
        }
        return null;
    }

    private String addFileExtension(String fileName) {
        if (fileName != null && fileName.length() > 0 && this.fileExtensionExists() && !this.containsFileExtension(fileName)) {
            return String.valueOf(fileName) + '.' + this.fileExtension;
        }
        return fileName;
    }

    private String removeFileExtension(String fileName) {
        if (this.containsFileExtension(fileName)) {
            return fileName.substring(0, fileName.length() - this.fileExtension.length() - 1);
        }
        return fileName;
    }

    private boolean isDisplayed(IFile file) {
        return file != null && this.displayFiles && this.containsFileExtension(file.getName());
    }

    private boolean containsFileExtension(String fileName) {
        return fileName != null && fileName.length() > 0 && this.fileExtensionExists() && fileName.trim().endsWith(String.valueOf('.') + this.fileExtension);
    }

    private boolean fileExtensionExists() {
        return this.fileExtension != null && this.fileExtension.length() > 0;
    }

    private boolean isFiltered(Object object) {
        if (this.filters != null && this.filters.size() > 0) {
            for (IFilter filter : this.filters) {
                if (filter == null || filter.select(object)) continue;
                return true;
            }
        }
        return false;
    }
}

