/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.agentcontroller.config.ConfigFile;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.CommonConstants;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACConfigUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACPluginMessages;
import org.eclipse.tptp.platform.iac.administrator.internal.config.ConfigGenerator;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.PreferenceMessages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdminUtil {
    static final String JVM_EE_TYPE = "EEVMType";

    public static boolean validString(String stringToCheck) {
        return stringToCheck != null && stringToCheck.trim().length() > 0;
    }

    public static Document parseFile(String fileName, boolean validation) {
        Document document;
        block5: {
            document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            factory.setNamespaceAware(validation);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(new File(fileName));
            }
            catch (SAXParseException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
                if (e instanceof SAXException) {
                    Exception nested = ((SAXException)e).getException();
                    if (nested != null) {
                        e = nested;
                    }
                }
                if (!(e instanceof FileNotFoundException)) break block5;
                Status status1 = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.FILE_NOT_FOUND);
                AdminPlugin.getDefault().getLog().log((IStatus)status1);
            }
        }
        return document;
    }

    public static Document parseFile(String fileName) {
        return AdminUtil.parseFile(fileName, true);
    }

    public static String getAttributeWithMoreDetails(Document document, String elementName, String attributeToCheck, String attributeValueToCheck, String attributeToGet) {
        NodeList elementList = document.getElementsByTagName(elementName);
        int i = 0;
        while (i < elementList.getLength()) {
            Element element = (Element)elementList.item(i);
            if (element.getAttribute(attributeToCheck).equals(attributeValueToCheck)) {
                return element.getAttribute(attributeToGet);
            }
            ++i;
        }
        return "";
    }

    public static String getAttributeOfElement(Document document, String elementName, String attributeName, int index) {
        String attributeValue = "";
        NodeList elementList = document.getElementsByTagName(elementName);
        if (index < elementList.getLength()) {
            Element element = (Element)elementList.item(index);
            attributeValue = element.getAttribute(attributeName);
        }
        return attributeValue;
    }

    public static String getElementValue(Document document, String elementName, int index) {
        Element element = AdminUtil.getElement(document, elementName, index);
        return element.getFirstChild().getNodeValue();
    }

    public static Element getElement(Document document, String elementName, int index) {
        NodeList elementList = document.getElementsByTagName(elementName);
        Element element = null;
        if (index < elementList.getLength()) {
            element = (Element)elementList.item(index);
        }
        return element;
    }

    public static GridData createFill() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createHorizontalFill() {
        return new GridData(4, -1, true, false);
    }

    public static GridData createVerticalFill() {
        return new GridData(-1, 4, false, true);
    }

    public static File[] getIACPlugins() {
        ArrayList<File> configJars = new ArrayList<File>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers.length == 0) {
            Bundle b = Platform.getBundle((String)"org.eclipse.update.configurator");
            try {
                if (b != null) {
                    b.start(1);
                }
            }
            catch (Exception exception) {}
            providers = Platform.getBundleGroupProviders();
        }
        int i = 0;
        while (i < providers.length) {
            IBundleGroupProvider provider = providers[i];
            IBundleGroup[] groups = provider.getBundleGroups();
            int j = 0;
            while (j < groups.length) {
                IBundleGroup group = groups[j];
                Bundle[] bundles = group.getBundles();
                int k = 0;
                while (k < bundles.length) {
                    Bundle bundle = bundles[k];
                    File configJar = AdminUtil.getConfigJar(bundle);
                    if (configJar != null) {
                        configJars.add(configJar);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return configJars.toArray(new File[0]);
    }

    private static File getConfigJar(Bundle bundle) {
        File configJar = null;
        try {
            URL rootEntry = bundle.getEntry("/");
            rootEntry = FileLocator.resolve((URL)rootEntry);
            if ("file".equals(rootEntry.getProtocol())) {
                configJar = new File(rootEntry.getPath(), "config.jar");
                configJar = !configJar.exists() ? null : configJar.getParentFile();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
        }
        return configJar;
    }

    public static void generateConfigFile(boolean invokedFromWorkbench) {
        if (!AdminUtil.isIACConfigFileWritable(invokedFromWorkbench)) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.CONFIG_FILE_ACCESS_DENIED);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        ConfigGenerator configGenerator = new ConfigGenerator();
        String iacHome = AdminUtil.getIACHome();
        if (iacHome == null) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.AC_HOME_NULL);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        AdminPlugin adminPlugin = AdminPlugin.getDefault();
        String javaExecutable = adminPlugin.getString(PreferenceMessages.JAVA_EXECUTABLE);
        String allowedHosts = adminPlugin.getString(PreferenceMessages.ALLOWED_HOSTS);
        String hostList = adminPlugin.getString(PreferenceMessages.HOST_LIST_LABEL);
        boolean security = adminPlugin.getBoolean(PreferenceMessages.AC_SECURITY);
        String usertype = adminPlugin.getString(PreferenceMessages.ALLOWED_USERS);
        String userList = adminPlugin.getString(PreferenceMessages.USER_LIST_LABEL);
        configGenerator.generateConfiguration(iacHome, javaExecutable, AdminUtil.getPluginsFolder(), AdminUtil.getIACPlugins(), security, usertype, userList, allowedHosts, hostList);
    }

    public static String getIACHome() {
        Bundle iacBundle;
        String iacHome;
        block7: {
            String iacPluginId = "org.eclipse.tptp.platform.ac.";
            iacHome = null;
            String platformSymbolicName = AdminUtil.getPlatformSymbolicName();
            if (platformSymbolicName == null) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.CANT_SOLVE_PLATFORM) + CommonConstants.OPERATING_SYSTEM + ":" + CommonConstants.SYSTEM_ARCH);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
                return null;
            }
            iacPluginId = String.valueOf(iacPluginId) + platformSymbolicName;
            try {
                iacBundle = Platform.getBundle((String)iacPluginId);
                if (iacBundle != null) break block7;
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.CANT_SOLVE_BUNDLE) + iacPluginId);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
                return null;
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
                return null;
            }
        }
        iacHome = FileLocator.resolve((URL)iacBundle.getEntry("/")).getPath();
        if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1 && iacHome.startsWith("/")) {
            iacHome = iacHome.substring(1);
        }
        iacHome = String.valueOf(iacHome) + "agent_controller";
        if (CommonConstants.FILE_SEPARATOR.equals("\\")) {
            iacHome = iacHome.replaceAll("/", "\\\\");
        }
        if (!new File(iacHome).exists()) {
            return null;
        }
        return iacHome;
    }

    public static String getPluginsFolder() {
        String iacHome = AdminUtil.getIACHome();
        String iacPluginsFolder = null;
        if (iacHome != null) {
            iacPluginsFolder = iacHome.substring(0, iacHome.indexOf("org.eclipse.tptp.platform.ac") - 1);
        } else {
            String workbenchPluginsFolder = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "plugins";
            if (workbenchPluginsFolder.charAt(0) == '/' || workbenchPluginsFolder.charAt(0) == '\\') {
                workbenchPluginsFolder = workbenchPluginsFolder.substring(1);
            }
            iacPluginsFolder = workbenchPluginsFolder;
        }
        if (CommonConstants.FILE_SEPARATOR.equals("\\")) {
            iacPluginsFolder = iacPluginsFolder.replaceAll("/", "\\\\");
        }
        return iacPluginsFolder;
    }

    public static boolean isConfigEmpty(boolean invokedFromWorkbench) {
        String iacConfigFileLocation = AdminUtil.getIACConfigFile(invokedFromWorkbench);
        if (iacConfigFileLocation == null) {
            return true;
        }
        File configFile = new File(iacConfigFileLocation);
        return !AdminUtil.checkFileValidity(configFile);
    }

    private static boolean checkFileValidity(File configFile) {
        return configFile.exists() && configFile.length() > 0L;
    }

    public static String getJVMExecutable() {
        String jvmExecutable = null;
        String jvmLocation = JavaRuntime.getDefaultVMInstall().getInstallLocation().getPath();
        if (AdminUtil.isJVMEEType(JavaRuntime.getDefaultVMInstall())) {
            VMStandin vms = new VMStandin(JavaRuntime.getDefaultVMInstall());
            jvmExecutable = vms.getAttribute("-Dee.executable");
        }
        if (jvmExecutable == null) {
            return AdminUtil.getJVMExecutable(jvmLocation);
        }
        return jvmExecutable;
    }

    private static boolean isJVMEEType(IVMInstall vm) {
        String vmType = vm.getVMInstallType().toString();
        return vmType.indexOf(JVM_EE_TYPE) != -1;
    }

    public static String getJVMExecutable(String jvmLocation) {
        String jvmExecutable = String.valueOf(jvmLocation) + CommonConstants.FILE_SEPARATOR + "jre" + CommonConstants.FILE_SEPARATOR + "bin" + CommonConstants.FILE_SEPARATOR + CommonConstants.JAVA_EXECUTABLE_NAME + CommonConstants.EXECUTABLE_EXTENSION;
        if (!new File(jvmExecutable).exists() && !new File(jvmExecutable = String.valueOf(jvmLocation) + CommonConstants.FILE_SEPARATOR + "bin" + CommonConstants.FILE_SEPARATOR + CommonConstants.JAVA_EXECUTABLE_NAME + CommonConstants.EXECUTABLE_EXTENSION).exists()) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.CANT_FIND_JAVA) + jvmLocation);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
        }
        return jvmExecutable;
    }

    public static String getIACExecutable() {
        String[] iacExecutableArray = AdminUtil.getIACExecutableArray();
        String iacExecutable = null;
        if (iacExecutableArray == null) {
            return null;
        }
        int i = 0;
        while (i < iacExecutableArray.length) {
            iacExecutable = String.valueOf(iacExecutable) + " " + iacExecutableArray[i];
            ++i;
        }
        return iacExecutable;
    }

    public static String[] getIACExecutableArray() {
        ArrayList<String> iacExecutableList = new ArrayList<String>();
        iacExecutableList.add(AdminUtil.getIACBinFolder());
        String iacExecutable = (String)iacExecutableList.get(0);
        if (iacExecutable == null) {
            return null;
        }
        if (CommonConstants.OPERATING_SYSTEM.indexOf("linux") != -1) {
            iacExecutableList.set(0, String.valueOf(iacExecutable) + CommonConstants.FILE_SEPARATOR + "ACStart.sh");
        } else if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1) {
            iacExecutableList.set(0, String.valueOf(iacExecutable) + CommonConstants.FILE_SEPARATOR + "ACServer");
        } else {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.CANT_SOLVE_PLATFORM) + CommonConstants.OPERATING_SYSTEM);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        String configDir = new IACConfigUtil().getACConfigDirectory(AdminUtil.getIACHome(), true, true).getAbsolutePath();
        iacExecutableList.add("-d");
        iacExecutableList.add(configDir);
        return iacExecutableList.toArray(new String[iacExecutableList.size()]);
    }

    public static String getShutdownCommand() {
        String[] commandArray = AdminUtil.getShutdownCommandArray();
        String command = null;
        if (commandArray == null) {
            return null;
        }
        int i = 0;
        while (i < commandArray.length) {
            command = String.valueOf(command) + " " + commandArray[i];
            ++i;
        }
        return command;
    }

    public static String[] getShutdownCommandArray() {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(AdminUtil.getIACBinFolder());
        String command = (String)commandList.get(0);
        if (command == null) {
            return null;
        }
        if (CommonConstants.OPERATING_SYSTEM.indexOf("linux") != -1) {
            commandList.set(0, String.valueOf(command) + CommonConstants.FILE_SEPARATOR + "ACStop.sh");
        } else if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1) {
            commandList.set(0, String.valueOf(command) + CommonConstants.FILE_SEPARATOR + "ACServer");
            commandList.add("-shutdown");
        } else {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.CANT_SOLVE_PLATFORM) + CommonConstants.OPERATING_SYSTEM);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            command = null;
        }
        if (command != null) {
            String configDir = new IACConfigUtil().getACConfigDirectory(AdminUtil.getIACHome(), true, true).getAbsolutePath();
            commandList.add("-d");
            commandList.add(configDir);
        }
        return commandList.toArray(new String[commandList.size()]);
    }

    public static String getIACConfigFile(boolean invokedFromWorkbench) {
        String iacHome = AdminUtil.getIACHome();
        if (iacHome == null) {
            return null;
        }
        String iacConfigFile = !invokedFromWorkbench ? String.valueOf(iacHome) + CommonConstants.FILE_SEPARATOR + "config" + CommonConstants.FILE_SEPARATOR + "serviceconfig.xml" : new IACConfigUtil().getACConfigDirectory(iacHome, true, true) + CommonConstants.FILE_SEPARATOR + "serviceconfig.xml";
        return iacConfigFile;
    }

    public static boolean isIACConfigFileWritable(boolean invokedFromWorkbench) {
        String configFileName = AdminUtil.getIACConfigFile(invokedFromWorkbench);
        if (configFileName == null) {
            return false;
        }
        File configFile = new File(configFileName);
        if (configFile.exists()) {
            return configFile.canWrite() && configFile.canRead();
        }
        try {
            return configFile.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getIACBinFolder() {
        String iacHome = AdminUtil.getIACHome();
        if (iacHome == null) {
            return iacHome;
        }
        return String.valueOf(iacHome) + CommonConstants.FILE_SEPARATOR + "bin";
    }

    public static MessageDialog getConfirmationDialog(Shell parentShell, String title, String message) {
        return new MessageDialog(parentShell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
    }

    public static String getProbekitNativePath() {
        String probekitNativePath = null;
        Bundle probekitBundle = Platform.getBundle((String)"org.eclipse.hyades.probekit");
        if (probekitBundle == null) {
            return probekitNativePath;
        }
        try {
            probekitNativePath = FileLocator.resolve((URL)probekitBundle.getEntry("/")).getPath();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1 && probekitNativePath.startsWith("/")) {
            probekitNativePath = String.valueOf(probekitNativePath) + File.separatorChar + "os" + File.separatorChar + "win32" + File.separatorChar + "x86";
        } else if (CommonConstants.OPERATING_SYSTEM.indexOf("linux") != -1 && probekitNativePath.startsWith("/")) {
            probekitNativePath = String.valueOf(probekitNativePath) + File.separatorChar + "os" + File.separatorChar + "linux" + File.separatorChar + "x86";
        }
        if (CommonConstants.FILE_SEPARATOR.equals("\\")) {
            probekitNativePath = probekitNativePath.replaceAll("/", "\\\\");
        }
        return probekitNativePath;
    }

    public static String getJvmtiNativePath() {
        String jvmtiNativePath = null;
        String platformSymbolicName = AdminUtil.getPlatformSymbolicName();
        Bundle jvmtiBundle = Platform.getBundle((String)"org.eclipse.tptp.platform.jvmti.runtime");
        if (jvmtiBundle == null || platformSymbolicName == null) {
            return jvmtiNativePath;
        }
        try {
            jvmtiNativePath = String.valueOf(FileLocator.resolve((URL)jvmtiBundle.getEntry("/")).getPath()) + "agent_files" + CommonConstants.FILE_SEPARATOR + platformSymbolicName;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1 && jvmtiNativePath.startsWith("/")) {
            jvmtiNativePath = jvmtiNativePath.substring(1);
        }
        if (CommonConstants.FILE_SEPARATOR.equals("\\")) {
            jvmtiNativePath = jvmtiNativePath.replaceAll("/", "\\\\");
        }
        return jvmtiNativePath;
    }

    private static String getPlatformSymbolicName() {
        String platformSymbolicName = null;
        if (CommonConstants.OPERATING_SYSTEM.indexOf("windows") != -1) {
            if (CommonConstants.SYSTEM_ARCH.indexOf("x86") != -1) {
                platformSymbolicName = "win_ia32";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("x86_64") != -1) {
                platformSymbolicName = "win_em64t";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("amd64") != -1) {
                platformSymbolicName = "win_em64t";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("ia64") != -1) {
                platformSymbolicName = "win_ipf";
            }
        } else if (CommonConstants.OPERATING_SYSTEM.indexOf("linux") != -1) {
            if (CommonConstants.SYSTEM_ARCH.indexOf("x86") != -1 || CommonConstants.SYSTEM_ARCH.indexOf("i386") != -1) {
                platformSymbolicName = "linux_ia32";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("x86_64") != -1) {
                platformSymbolicName = "linux_em64t";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("amd64") != -1) {
                platformSymbolicName = "linux_em64t";
            } else if (CommonConstants.SYSTEM_ARCH.indexOf("ia64") != -1) {
                platformSymbolicName = "linux_ipf";
            }
        }
        return platformSymbolicName;
    }

    public static boolean isNeedToGenerateConfigFile(boolean invokedFromWorkbench) {
        if (!AdminUtil.isConfigurationValid(invokedFromWorkbench)) {
            return true;
        }
        String runtimeIACHome = AdminUtil.getIACHome();
        if (runtimeIACHome == null) {
            return true;
        }
        ConfigFile configFile = new ConfigFile(AdminUtil.getIACConfigFile(true));
        String configFileIACHome = configFile.getValue("RASERVER_HOME");
        return !runtimeIACHome.equalsIgnoreCase(configFileIACHome);
    }

    public static boolean isConfigurationValid(boolean invokedFromWorkbench) {
        String workbenchJVM;
        if (AdminUtil.isConfigEmpty(invokedFromWorkbench)) {
            return false;
        }
        boolean valid = false;
        File[] iacPlugins = AdminUtil.getIACPlugins();
        int i = 0;
        while (i < iacPlugins.length) {
            if (iacPlugins[i].toString().indexOf("org.eclipse.hyades.execution_") != -1) {
                valid = AdminUtil.checkFileValidity(new File(String.valueOf(iacPlugins[i].toString()) + CommonConstants.FILE_SEPARATOR + "config" + CommonConstants.FILE_SEPARATOR + "pluginconfig.xml"));
                break;
            }
            ++i;
        }
        if (!valid) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.EXECUTION_FRAMEWORK_CONFIG_FILE_INVALID);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        Document document = AdminUtil.parseFile(AdminUtil.getIACConfigFile(invokedFromWorkbench), false);
        if (document == null) {
            Status status = new Status(2, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.EXECUTION_FRAMEWORK_CONFIG_FILE_INVALID);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        String iacJVM = AdminUtil.getAttributeWithMoreDetails(document, "Variable", "name", "JAVA_PATH", "value");
        if (!iacJVM.equals(workbenchJVM = AdminUtil.getJVMExecutable())) {
            AdminPlugin.getDefault().setString(PreferenceMessages.JAVA_EXECUTABLE, workbenchJVM);
            Status status = new Status(2, "org.eclipse.tptp.platform.iac.administrator", "Execution framework config file is invalid.");
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return valid;
    }

    public static boolean isSupportedPlatform() {
        return AdminUtil.getPlatformSymbolicName() != null;
    }

    private static Shell getValidShell() {
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            if (workbench.getActiveWorkbenchWindow() != null && (shell = workbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (workbench.getWorkbenchWindows().length > 0 && (shell = workbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    public static void openErrorDialog(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Status err = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)new Exception(message));
                ErrorDialog.openError((Shell)AdminUtil.getValidShell(), (String)title, (String)PreferenceMessages.ERROR_GENERAL, (IStatus)err);
            }
        });
    }
}

