/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.preference;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.agentcontroller.config.ConfigFile;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACPluginMessages;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.PreferenceMessages;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IACPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String JRE_PAGE_ID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    private boolean iacEnabled = true;
    private String allowedHosts = "";
    private String listOfCustomHosts = "";
    private String javaExecutable = "";
    private boolean security = false;
    private String allowedUsers = "";
    private String listOfCustomUsers = "";
    private Composite composite = null;
    private Label label = null;
    private Group allowedHostsGroup = null;
    private Composite composite5 = null;
    private List listOfHosts = null;
    private Composite composite6 = null;
    private Label listOfHostLabel = null;
    private Button addHostButton = null;
    private Button removeHostButton = null;
    private Button editHostButton = null;
    private Group acSecurityGroup = null;
    private Group listOfUsersGroup = null;
    private Label listOfUsersLabel = null;
    private Composite composite1 = null;
    private List listOfUsers = null;
    private Composite composite2 = null;
    private Button addUserButton = null;
    private Button removeUserButton = null;
    private Button editUserButton = null;
    private Composite composite3 = null;
    private Button securityOnButton = null;
    private Button securityOffButton = null;
    private Composite composite4 = null;
    private Button customHostButton = null;
    private Button localHostButton = null;
    private Button allHostButton = null;
    private Composite composite8 = null;
    private Text javaPathText = null;
    private PreferenceLinkArea modifyLink = null;
    private Composite composite7 = null;
    private Button customUserButton = null;
    private Button anyUserButton = null;
    private Composite enableDisableComposite = null;
    private Label enableDisableLabel = null;
    private Button enableIACButton = null;
    private Button disableIACButton = null;
    private static AdminPlugin adminPlugin = AdminPlugin.getDefault();
    private Composite preferenceComposite = null;
    private Composite notSupportPlatformComposite = null;
    private Label notSupportPlatformMsg = null;
    private Composite accessIACConfigDeniedComposite = null;
    private Label accessIACConfigDeniedMsg = null;

    protected Control createContents(Composite parent) {
        if (!AdminUtil.isSupportedPlatform()) {
            this.createNotSupportPlatformErrorComposite(parent);
            AdminPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.NOT_SUPPORT_PLATFORM));
        } else if (!AdminUtil.isIACConfigFileWritable(true)) {
            this.createCannotAccessIACConfigFile(parent);
            AdminPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.CONFIG_FILE_ACCESS_DENIED));
        }
        this.preferenceComposite = parent;
        this.createEnableDisableComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 5;
        gridLayout.numColumns = 1;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.horizontalAlignment = 1;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalIndent = 0;
        gridData1.grabExcessVerticalSpace = false;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        this.label = new Label(this.composite, 0);
        this.label.setText(PreferenceMessages.JAVA_EXECUTABLE);
        this.label.setLayoutData((Object)gridData1);
        this.createJavaExecutableText();
        this.createAllowedHostsGroup();
        this.createAcSecurityGroup();
        if (AdminUtil.isConfigurationValid(true)) {
            this.refreshValuesFromConfigFile();
        } else {
            this.refreshValuesFromPreference();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.enableIACButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.disableIACButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.modifyLink.getControl(), "org.eclipse.tptp.platform.iac.administrator.iacpp0003");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.localHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0004");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.customHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0005");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.allHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0006");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0007");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0008");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editHostButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0009");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.securityOnButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0010");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.securityOffButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0011");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.customUserButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0012");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.anyUserButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0013");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addUserButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0014");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeUserButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0015");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editUserButton, "org.eclipse.tptp.platform.iac.administrator.iacpp0016");
        if (!AdminUtil.isSupportedPlatform()) {
            this.enableIACButton.setSelection(false);
            this.disableIACButton.setSelection(false);
            this.enableIACButton.setEnabled(false);
            this.disableIACButton.setEnabled(false);
            this.setIACEnable(false);
        }
        if (!AdminUtil.isIACConfigFileWritable(true)) {
            this.disableIACButton.setEnabled(false);
            this.enableIACButton.setEnabled(false);
            if (!AdminUtil.isConfigurationValid(true)) {
                this.enableIACButton.setSelection(false);
                this.disableIACButton.setSelection(true);
            } else {
                this.enableIACButton.setSelection(true);
                this.disableIACButton.setSelection(false);
            }
            this.setIACEnable(false);
        }
        return this.composite;
    }

    private void refreshValuesFromPreference() {
        this.iacEnabled = adminPlugin.getBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL);
        this.allowedHosts = adminPlugin.getString(PreferenceMessages.ALLOWED_HOSTS);
        this.javaExecutable = adminPlugin.getString(PreferenceMessages.JAVA_EXECUTABLE);
        this.listOfCustomHosts = adminPlugin.getString(PreferenceMessages.HOST_LIST_LABEL);
        this.security = adminPlugin.getBoolean(PreferenceMessages.AC_SECURITY);
        this.allowedUsers = adminPlugin.getString(PreferenceMessages.ALLOWED_USERS);
        this.listOfCustomUsers = adminPlugin.getString(PreferenceMessages.USER_LIST_LABEL);
        this.updateWidgets(true);
    }

    private void refreshValuesFromConfigFile() {
        ConfigFile configFile = new ConfigFile(AdminUtil.getIACConfigFile(true));
        this.iacEnabled = adminPlugin.getBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL);
        this.javaExecutable = configFile.getValue("JAVA_PATH");
        adminPlugin.setString(PreferenceMessages.JAVA_EXECUTABLE, this.javaExecutable);
        String s = configFile.getValue("SECURITY");
        this.security = "TRUE".equalsIgnoreCase(s);
        adminPlugin.setBoolean(PreferenceMessages.AC_SECURITY, this.security);
        this.allowedHosts = configFile.getValue("TYPE");
        if (this.allowedHosts.equalsIgnoreCase("ALL")) {
            this.allowedHosts = PreferenceMessages.ALL_HOSTS;
        } else if (this.allowedHosts.equalsIgnoreCase("LOCAL")) {
            this.allowedHosts = PreferenceMessages.LOCALHOST;
        } else {
            this.allowedHosts = PreferenceMessages.CUSTOM_HOSTS;
            this.listOfCustomHosts = configFile.getValue("HOSTS");
        }
        adminPlugin.setString(PreferenceMessages.ALLOWED_HOSTS, this.allowedHosts);
        adminPlugin.setString(PreferenceMessages.HOST_LIST_LABEL, this.listOfCustomHosts);
        if (this.security) {
            this.allowedUsers = configFile.getValue("USERTYPE");
            if (this.allowedUsers.equalsIgnoreCase("ANY")) {
                this.allowedUsers = PreferenceMessages.ANY_USER;
            } else {
                this.allowedUsers = PreferenceMessages.CUSTOM_USER;
                this.listOfCustomUsers = configFile.getValue("USERLIST");
            }
        } else {
            this.allowedUsers = PreferenceMessages.ANY_USER;
        }
        adminPlugin.setString(PreferenceMessages.ALLOWED_USERS, this.allowedUsers);
        adminPlugin.setString(PreferenceMessages.USER_LIST_LABEL, this.listOfCustomUsers);
        this.updateWidgets(true);
    }

    private void restoreValuesFromPreferenceDefault() {
        this.iacEnabled = adminPlugin.getDefaultBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL);
        this.allowedHosts = adminPlugin.getDefaultString(PreferenceMessages.ALLOWED_HOSTS);
        this.javaExecutable = adminPlugin.getDefaultString(PreferenceMessages.JAVA_EXECUTABLE);
        this.listOfCustomHosts = adminPlugin.getDefaultString(PreferenceMessages.HOST_LIST_LABEL);
        this.security = adminPlugin.getDefaultBoolean(PreferenceMessages.AC_SECURITY);
        this.allowedUsers = adminPlugin.getDefaultString(PreferenceMessages.ALLOWED_USERS);
        this.listOfCustomUsers = adminPlugin.getDefaultString(PreferenceMessages.USER_LIST_LABEL);
        this.updateWidgets(false);
    }

    private void updateWidgets(boolean restoreLists) {
        this.enableIACButton.setSelection(this.iacEnabled);
        this.disableIACButton.setSelection(!this.iacEnabled);
        this.setIACEnable(this.iacEnabled);
        this.javaPathText.setText(this.javaExecutable);
        this.localHostButton.setSelection(this.allowedHosts.equals(PreferenceMessages.LOCALHOST));
        this.allHostButton.setSelection(this.allowedHosts.equals(PreferenceMessages.ALL_HOSTS));
        this.customHostButton.setSelection(this.allowedHosts.equals(PreferenceMessages.CUSTOM_HOSTS));
        if (restoreLists) {
            StringTokenizer stListOfHosts = new StringTokenizer(this.listOfCustomHosts, ",");
            while (stListOfHosts.hasMoreElements()) {
                this.listOfHosts.add(stListOfHosts.nextToken());
            }
        }
        this.setEnableListOfHosts(this.iacEnabled && this.allowedHosts.equals(PreferenceMessages.CUSTOM_HOSTS));
        this.securityOnButton.setSelection(this.security);
        this.securityOffButton.setSelection(!this.security);
        this.setEnableSecurityButtons(this.iacEnabled && this.security);
        this.anyUserButton.setSelection(this.allowedUsers.equals(PreferenceMessages.ANY_USER));
        this.customUserButton.setSelection(this.allowedUsers.equals(PreferenceMessages.CUSTOM_USER));
        if (restoreLists) {
            StringTokenizer stListOfUsers = new StringTokenizer(this.listOfCustomUsers, ",");
            while (stListOfUsers.hasMoreElements()) {
                this.listOfUsers.add(stListOfUsers.nextToken());
            }
        }
        this.setEnableListOfUsers(this.iacEnabled && this.security && this.allowedUsers.equals(PreferenceMessages.CUSTOM_USER));
    }

    private void createAllowedHostsGroup() {
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        GridData gridData18 = new GridData();
        gridData18.horizontalIndent = 20;
        GridData gridData3 = new GridData();
        gridData3.horizontalIndent = 0;
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        this.allowedHostsGroup = new Group(this.composite, 0);
        this.allowedHostsGroup.setText(PreferenceMessages.ALLOWED_HOSTS);
        this.allowedHostsGroup.setLayout((Layout)gridLayout2);
        this.allowedHostsGroup.setLayoutData((Object)gridData3);
        this.createAllowedHostButtons();
        this.listOfHostLabel = new Label((Composite)this.allowedHostsGroup, 0);
        this.listOfHostLabel.setText(PreferenceMessages.HOST_LIST_LABEL);
        this.listOfHostLabel.setLayoutData((Object)gridData18);
        this.createListOfHosts();
    }

    private void createListOfHosts() {
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        GridData gridData19 = new GridData();
        gridData19.heightHint = 75;
        gridData19.horizontalIndent = 5;
        gridData19.grabExcessHorizontalSpace = true;
        gridData19.horizontalAlignment = 4;
        gridData19.widthHint = 80;
        GridData gridData11 = new GridData();
        gridData11.grabExcessHorizontalSpace = true;
        gridData11.horizontalIndent = 10;
        gridData11.horizontalAlignment = 4;
        this.composite5 = new Composite((Composite)this.allowedHostsGroup, 0);
        this.composite5.setLayoutData((Object)gridData11);
        this.composite5.setLayout((Layout)gridLayout3);
        this.listOfHosts = new List(this.composite5, 2562);
        this.listOfHosts.setLayoutData((Object)gridData19);
        this.listOfHosts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IACPreferencePage.this.listOfHosts.getSelectionCount() > 0) {
                    IACPreferencePage.this.removeHostButton.setEnabled(true);
                    if (IACPreferencePage.this.listOfHosts.getSelectionCount() == 1) {
                        IACPreferencePage.this.editHostButton.setEnabled(true);
                    } else {
                        IACPreferencePage.this.editHostButton.setEnabled(false);
                    }
                } else {
                    IACPreferencePage.this.removeHostButton.setEnabled(false);
                    IACPreferencePage.this.editHostButton.setEnabled(false);
                }
            }
        });
        this.listOfHosts.setData((Object)"hostList");
        this.createHostListButtons();
    }

    private void createHostListButtons() {
        GridData gridData20 = new GridData();
        gridData20.horizontalAlignment = 4;
        gridData20.grabExcessHorizontalSpace = false;
        this.composite6 = new Composite(this.composite5, 0);
        this.composite6.setLayout((Layout)new GridLayout());
        this.composite6.setLayoutData((Object)gridData20);
        this.addHostButton = new Button(this.composite6, 0);
        this.addHostButton.setText(PreferenceMessages.ADD_BUTTON);
        this.addHostButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.addHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.addToList(IACPreferencePage.this.listOfHosts, PreferenceMessages.ADD_HOST, PreferenceMessages.HOST_NAME);
            }
        });
        this.removeHostButton = new Button(this.composite6, 0);
        this.removeHostButton.setText(PreferenceMessages.REMOVE_BUTTON);
        this.removeHostButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.removeHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.removeFromList(IACPreferencePage.this.listOfHosts);
            }
        });
        this.editHostButton = new Button(this.composite6, 0);
        this.editHostButton.setText(PreferenceMessages.EDIT_BUTTON);
        this.editHostButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.editHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.editList(IACPreferencePage.this.listOfHosts, PreferenceMessages.EDIT_HOST, PreferenceMessages.HOST_NAME);
            }
        });
    }

    private void createAcSecurityGroup() {
        GridData gridData4 = new GridData();
        gridData4.widthHint = 290;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalAlignment = 4;
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.numColumns = 1;
        this.acSecurityGroup = new Group(this.composite, 0);
        this.acSecurityGroup.setText(PreferenceMessages.AC_SECURITY);
        this.createSecurityButtons();
        this.acSecurityGroup.setLayout((Layout)gridLayout4);
        this.acSecurityGroup.setLayoutData((Object)gridData4);
        this.createListOfUsersGroup();
    }

    private void createListOfUsersGroup() {
        GridLayout gridLayout7 = new GridLayout();
        gridLayout7.numColumns = 1;
        GridData gridData12 = new GridData();
        gridData12.horizontalIndent = 5;
        GridData gridData7 = new GridData();
        gridData7.horizontalIndent = 10;
        gridData7.horizontalAlignment = 4;
        gridData7.grabExcessHorizontalSpace = true;
        this.listOfUsersGroup = new Group((Composite)this.acSecurityGroup, 0);
        this.listOfUsersGroup.setText(PreferenceMessages.ALLOWED_USERS);
        this.listOfUsersGroup.setLayout((Layout)gridLayout7);
        this.listOfUsersGroup.setLayoutData((Object)gridData7);
        this.createCustomAnyButtons();
        this.listOfUsersLabel = new Label((Composite)this.listOfUsersGroup, 0);
        this.listOfUsersLabel.setText(PreferenceMessages.USER_LIST_LABEL);
        this.listOfUsersLabel.setLayoutData((Object)gridData12);
        this.createListOfUsers();
    }

    private void createListOfUsers() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        GridData gridData8 = new GridData();
        gridData8.widthHint = 80;
        gridData8.horizontalIndent = 5;
        gridData8.grabExcessHorizontalSpace = true;
        gridData8.horizontalAlignment = 4;
        gridData8.heightHint = 75;
        GridData gridData13 = new GridData();
        gridData13.horizontalAlignment = 4;
        gridData13.grabExcessHorizontalSpace = true;
        this.composite1 = new Composite((Composite)this.listOfUsersGroup, 0);
        this.composite1.setLayoutData((Object)gridData13);
        this.composite1.setLayout((Layout)gridLayout1);
        this.listOfUsers = new List(this.composite1, 2562);
        this.listOfUsers.setLayoutData((Object)gridData8);
        this.listOfUsers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IACPreferencePage.this.listOfUsers.getSelectionCount() > 0) {
                    IACPreferencePage.this.removeUserButton.setEnabled(true);
                    if (IACPreferencePage.this.listOfUsers.getSelectionCount() == 1) {
                        IACPreferencePage.this.editUserButton.setEnabled(true);
                    } else {
                        IACPreferencePage.this.editUserButton.setEnabled(false);
                    }
                } else {
                    IACPreferencePage.this.removeUserButton.setEnabled(false);
                    IACPreferencePage.this.editUserButton.setEnabled(false);
                }
            }
        });
        this.listOfUsers.setData((Object)"userList");
        this.createUserListButtons();
    }

    private void createUserListButtons() {
        GridData gridData14 = new GridData();
        gridData14.grabExcessHorizontalSpace = false;
        gridData14.horizontalAlignment = 1;
        this.composite2 = new Composite(this.composite1, 0);
        this.composite2.setLayoutData((Object)gridData14);
        this.composite2.setLayout((Layout)new GridLayout());
        this.addUserButton = new Button(this.composite2, 0);
        this.addUserButton.setText(PreferenceMessages.ADD_BUTTON2);
        this.addUserButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.addUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.addToList(IACPreferencePage.this.listOfUsers, PreferenceMessages.ADD_USER, PreferenceMessages.USER_NAME);
            }
        });
        this.removeUserButton = new Button(this.composite2, 0);
        this.removeUserButton.setText(PreferenceMessages.REMOVE_BUTTON2);
        this.removeUserButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.removeUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.removeFromList(IACPreferencePage.this.listOfUsers);
            }
        });
        this.editUserButton = new Button(this.composite2, 0);
        this.editUserButton.setText(PreferenceMessages.EDIT_BUTTON2);
        this.editUserButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.editUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.editList(IACPreferencePage.this.listOfUsers, PreferenceMessages.ADD_USER, PreferenceMessages.USER_NAME);
            }
        });
    }

    private void createSecurityButtons() {
        GridData gridData5 = new GridData();
        gridData5.horizontalIndent = 15;
        GridLayout gridLayout5 = new GridLayout();
        gridLayout5.numColumns = 2;
        GridData gridData15 = new GridData();
        gridData15.horizontalIndent = 10;
        GridData gridData6 = new GridData();
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.horizontalIndent = 5;
        gridData6.horizontalAlignment = 4;
        this.composite3 = new Composite((Composite)this.acSecurityGroup, 0);
        this.composite3.setLayoutData((Object)gridData6);
        this.composite3.setLayout((Layout)gridLayout5);
        this.securityOnButton = new Button(this.composite3, 16);
        this.securityOnButton.setText(PreferenceMessages.SECURITY_ON);
        this.securityOnButton.setSelection(false);
        this.securityOnButton.setLayoutData((Object)gridData15);
        this.securityOnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.security = true;
                if (IACPreferencePage.this.customUserButton.getSelection()) {
                    IACPreferencePage.this.setEnableListOfUsers(true);
                }
                IACPreferencePage.this.setEnableSecurityButtons(true);
            }
        });
        this.securityOffButton = new Button(this.composite3, 16);
        this.securityOffButton.setText(PreferenceMessages.SECURITY_OFF);
        this.securityOffButton.setLayoutData((Object)gridData5);
        this.securityOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.security = false;
                if (IACPreferencePage.this.customUserButton.getSelection()) {
                    IACPreferencePage.this.setEnableListOfUsers(false);
                }
                IACPreferencePage.this.setEnableSecurityButtons(false);
            }
        });
    }

    private void createAllowedHostButtons() {
        GridData gridData24 = new GridData();
        gridData24.horizontalIndent = 5;
        GridData gridData22 = new GridData();
        gridData22.horizontalIndent = 5;
        GridLayout gridLayout6 = new GridLayout();
        gridLayout6.numColumns = 3;
        GridData gridData17 = new GridData();
        gridData17.horizontalIndent = 15;
        GridData gridData21 = new GridData();
        gridData21.grabExcessHorizontalSpace = true;
        gridData21.horizontalIndent = 0;
        gridData21.horizontalAlignment = 4;
        this.composite4 = new Composite((Composite)this.allowedHostsGroup, 0);
        this.composite4.setLayoutData((Object)gridData21);
        this.composite4.setLayout((Layout)gridLayout6);
        this.customHostButton = new Button(this.composite4, 16);
        this.customHostButton.setText(PreferenceMessages.CUSTOM_HOSTS);
        this.customHostButton.setLayoutData((Object)gridData17);
        this.customHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.allowedHosts = PreferenceMessages.CUSTOM_HOSTS;
                IACPreferencePage.this.setEnableListOfHosts(true);
            }
        });
        this.localHostButton = new Button(this.composite4, 16);
        this.localHostButton.setText(PreferenceMessages.LOCALHOST);
        this.localHostButton.setLayoutData((Object)gridData22);
        this.localHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.allowedHosts = PreferenceMessages.LOCALHOST;
                IACPreferencePage.this.setEnableListOfHosts(false);
            }
        });
        this.allHostButton = new Button(this.composite4, 16);
        this.allHostButton.setText(PreferenceMessages.ALL_HOSTS);
        this.allHostButton.setLayoutData((Object)gridData24);
        this.allHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.allowedHosts = PreferenceMessages.ALL_HOSTS;
                IACPreferencePage.this.setEnableListOfHosts(false);
            }
        });
    }

    private void createJavaExecutableText() {
        GridData gridData16 = new GridData();
        gridData16.horizontalIndent = 0;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 240;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        GridLayout gridLayout8 = new GridLayout();
        gridLayout8.numColumns = 2;
        GridData gridData23 = new GridData();
        gridData23.grabExcessHorizontalSpace = true;
        gridData23.horizontalAlignment = 4;
        this.composite8 = new Composite(this.composite, 0);
        this.composite8.setLayoutData((Object)gridData23);
        this.composite8.setLayout((Layout)gridLayout8);
        this.javaPathText = new Text(this.composite8, 2048);
        this.javaPathText.setEditable(false);
        this.javaPathText.setLayoutData((Object)gridData2);
        this.modifyLink = new PreferenceLinkArea(this.composite8, 64, JRE_PAGE_ID, PreferenceMessages.MODIFY_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        this.modifyLink.getControl().setLayoutData((Object)gridData16);
    }

    private void createCustomAnyButtons() {
        GridData gridData10 = new GridData();
        gridData10.horizontalIndent = 10;
        GridData gridData9 = new GridData();
        gridData9.horizontalIndent = 0;
        GridData gridData25 = new GridData();
        gridData25.grabExcessHorizontalSpace = true;
        gridData25.horizontalAlignment = 4;
        GridLayout gridLayout9 = new GridLayout();
        gridLayout9.numColumns = 2;
        this.composite7 = new Composite((Composite)this.listOfUsersGroup, 0);
        this.composite7.setLayout((Layout)gridLayout9);
        this.composite7.setLayoutData((Object)gridData25);
        this.customUserButton = new Button(this.composite7, 16);
        this.customUserButton.setText(PreferenceMessages.CUSTOM_USER);
        this.customUserButton.setLayoutData((Object)gridData9);
        this.customUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.allowedUsers = PreferenceMessages.CUSTOM_USER;
                IACPreferencePage.this.setEnableListOfUsers(true);
            }
        });
        this.anyUserButton = new Button(this.composite7, 16);
        this.anyUserButton.setText(PreferenceMessages.ANY_USER);
        this.anyUserButton.setLayoutData((Object)gridData10);
        this.anyUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.allowedUsers = PreferenceMessages.ANY_USER;
                IACPreferencePage.this.setEnableListOfUsers(false);
            }
        });
    }

    private void createNotSupportPlatformErrorComposite(Composite parent) {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 17;
        this.notSupportPlatformComposite = new Composite(parent, 0);
        this.notSupportPlatformComposite.setLayout((Layout)gridLayout2);
        this.notSupportPlatformComposite.setLayoutData((Object)gridData1);
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = false;
        gridData3.horizontalAlignment = 1;
        this.notSupportPlatformMsg = new Label(this.notSupportPlatformComposite, 0);
        this.notSupportPlatformMsg.setText(PreferenceMessages.NOT_SUPPORT_PLATFORM);
        this.notSupportPlatformMsg.setSize(150, 20);
        this.notSupportPlatformMsg.setForeground(new Color(null, 255, 0, 0));
        this.notSupportPlatformMsg.setLayoutData((Object)gridData3);
    }

    private void createCannotAccessIACConfigFile(Composite parent) {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 17;
        this.accessIACConfigDeniedComposite = new Composite(parent, 0);
        this.accessIACConfigDeniedComposite.setLayout((Layout)gridLayout2);
        this.accessIACConfigDeniedComposite.setLayoutData((Object)gridData1);
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = false;
        gridData3.horizontalAlignment = 1;
        this.accessIACConfigDeniedMsg = new Label(this.accessIACConfigDeniedComposite, 0);
        if (AdminUtil.isConfigurationValid(true)) {
            this.accessIACConfigDeniedMsg.setText(PreferenceMessages.ACCESS_TO_IAC_CONFIG_DENIED_WITH_VALID_CONFIG);
        } else {
            this.accessIACConfigDeniedMsg.setText(PreferenceMessages.ACCESS_TO_IAC_CONFIG_DENIED_WITH_INVALID_CONFIG);
        }
        this.accessIACConfigDeniedMsg.setSize(150, 20);
        this.accessIACConfigDeniedMsg.setForeground(new Color(null, 255, 0, 0));
        this.accessIACConfigDeniedMsg.setLayoutData((Object)gridData3);
    }

    private void createEnableDisableComposite(Composite parent) {
        GridData gridData31 = new GridData();
        gridData31.grabExcessHorizontalSpace = false;
        gridData31.horizontalAlignment = 1;
        GridData gridData30 = new GridData();
        gridData30.horizontalAlignment = 3;
        gridData30.verticalAlignment = 2;
        gridData30.horizontalSpan = 15;
        gridData30.grabExcessHorizontalSpace = false;
        GridData gridData29 = new GridData();
        gridData29.horizontalAlignment = 1;
        gridData29.grabExcessHorizontalSpace = true;
        GridData gridData28 = new GridData();
        gridData28.grabExcessHorizontalSpace = true;
        gridData28.horizontalAlignment = 4;
        GridLayout gridLayout10 = new GridLayout();
        gridLayout10.numColumns = 17;
        this.enableDisableComposite = new Composite(parent, 0);
        this.enableDisableComposite.setLayout((Layout)gridLayout10);
        this.enableDisableComposite.setLayoutData((Object)gridData28);
        this.enableDisableLabel = new Label(this.enableDisableComposite, 0);
        this.enableDisableLabel.setText(PreferenceMessages.ENABLE_DISABLE_LABEL);
        this.enableDisableLabel.setLayoutData((Object)gridData31);
        this.enableIACButton = new Button(this.enableDisableComposite, 16);
        this.enableIACButton.setText(PreferenceMessages.ENABLE_IAC);
        this.enableIACButton.setLayoutData((Object)gridData30);
        this.enableIACButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.iacEnabled = true;
                IACPreferencePage.this.setIACEnable(true);
            }
        });
        this.disableIACButton = new Button(this.enableDisableComposite, 16);
        this.disableIACButton.setText(PreferenceMessages.DISABLE_IAC);
        this.disableIACButton.setLayoutData((Object)gridData29);
        this.disableIACButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACPreferencePage.this.iacEnabled = false;
                IACPreferencePage.this.setIACEnable(false);
            }
        });
    }

    private void setIACEnable(boolean enabled) {
        this.label.setEnabled(enabled);
        this.javaPathText.setEnabled(enabled);
        this.modifyLink.getControl().setEnabled(enabled);
        this.customHostButton.setEnabled(enabled);
        this.localHostButton.setEnabled(enabled);
        this.allHostButton.setEnabled(enabled);
        if (enabled && this.customHostButton.getSelection() || !enabled) {
            this.listOfHosts.setEnabled(enabled);
            this.listOfHostLabel.setEnabled(enabled);
            this.addHostButton.setEnabled(enabled);
            if (this.listOfHosts.getSelectionCount() > 0 || !enabled) {
                this.removeHostButton.setEnabled(enabled);
                this.editHostButton.setEnabled(enabled);
            }
        }
        this.securityOnButton.setEnabled(enabled);
        this.securityOffButton.setEnabled(enabled);
        if (enabled && this.securityOnButton.getSelection() || !enabled) {
            this.customUserButton.setEnabled(enabled);
            this.anyUserButton.setEnabled(enabled);
            if (this.customUserButton.getSelection() || !enabled) {
                this.listOfUsersLabel.setEnabled(enabled);
                this.listOfUsers.setEnabled(enabled);
                this.addUserButton.setEnabled(enabled);
                if (this.listOfUsers.getSelectionCount() > 0 || !enabled) {
                    this.removeUserButton.setEnabled(enabled);
                    this.editUserButton.setEnabled(enabled);
                }
            }
        }
    }

    private void addToList(List list, String title, String entryLabel) {
        HostUserDialog dialog = new HostUserDialog(title, entryLabel, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String entry = dialog.getEntry();
            list.add(entry);
            if (((String)list.getData()).equals("hostList")) {
                if (!this.listOfCustomHosts.trim().equals("")) {
                    this.listOfCustomHosts = String.valueOf(this.listOfCustomHosts) + ",";
                }
                this.listOfCustomHosts = String.valueOf(this.listOfCustomHosts) + entry;
            } else {
                if (!this.listOfCustomUsers.trim().equals("")) {
                    this.listOfCustomUsers = String.valueOf(this.listOfCustomUsers) + ",";
                }
                this.listOfCustomUsers = String.valueOf(this.listOfCustomUsers) + entry;
            }
        }
    }

    private void removeFromList(List list) {
        String listData;
        list.remove(list.getSelectionIndices());
        if (list.getSelectionCount() <= 0) {
            String listDataItem = (String)list.getData();
            if (listDataItem.equals("hostList")) {
                this.removeHostButton.setEnabled(false);
                this.editHostButton.setEnabled(false);
            } else {
                this.removeUserButton.setEnabled(false);
                this.editUserButton.setEnabled(false);
            }
        }
        if ((listData = (String)list.getData()).equals("hostList")) {
            this.updateHostStringList();
        } else {
            this.updateUserStringList();
        }
    }

    private void editList(List list, String title, String entryLabel) {
        String listData;
        HostUserDialog dialog = new HostUserDialog(title, entryLabel, list.getSelection()[0]);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            list.setItem(list.getSelectionIndex(), dialog.getEntry());
        }
        if ((listData = (String)list.getData()).equals("hostList")) {
            this.updateHostStringList();
        } else {
            this.updateUserStringList();
        }
    }

    private void updateHostStringList() {
        if (this.listOfHosts.getItemCount() > 0) {
            this.listOfCustomHosts = this.listOfHosts.getItem(0);
            int i = 1;
            while (i < this.listOfHosts.getItemCount()) {
                this.listOfCustomHosts = String.valueOf(this.listOfCustomHosts) + "," + this.listOfHosts.getItem(i);
                ++i;
            }
        } else {
            this.listOfCustomHosts = "";
        }
    }

    private void updateUserStringList() {
        if (this.listOfUsers.getItemCount() > 0) {
            this.listOfCustomUsers = this.listOfUsers.getItem(0);
            int i = 1;
            while (i < this.listOfUsers.getItemCount()) {
                this.listOfCustomUsers = String.valueOf(this.listOfCustomUsers) + "," + this.listOfUsers.getItem(i);
                ++i;
            }
        } else {
            this.listOfCustomUsers = "";
        }
    }

    private boolean isItemInList(List list, String itemToCheck) {
        String[] items = list.getItems();
        int i = 0;
        while (i < items.length) {
            if (itemToCheck.equals(items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setEnableListOfUsers(boolean enable) {
        this.listOfUsersLabel.setEnabled(enable);
        this.listOfUsers.setEnabled(enable);
        this.addUserButton.setEnabled(enable);
        if (this.listOfUsers.getSelectionCount() > 0) {
            this.removeUserButton.setEnabled(true);
            if (this.listOfUsers.getSelectionCount() == 1) {
                this.editUserButton.setEnabled(true);
            }
        } else {
            this.removeUserButton.setEnabled(false);
            this.editUserButton.setEnabled(false);
        }
        if (!enable) {
            this.editUserButton.setEnabled(false);
            this.removeUserButton.setEnabled(false);
        }
    }

    private void setEnableListOfHosts(boolean enable) {
        this.listOfHostLabel.setEnabled(enable);
        this.listOfHosts.setEnabled(enable);
        this.addHostButton.setEnabled(enable);
        if (this.listOfHosts.getSelectionCount() > 0) {
            this.removeHostButton.setEnabled(true);
            if (this.listOfHosts.getSelectionCount() == 1) {
                this.editHostButton.setEnabled(true);
            }
        } else {
            this.removeHostButton.setEnabled(false);
            this.editHostButton.setEnabled(false);
        }
        if (!enable) {
            this.editHostButton.setEnabled(false);
            this.removeHostButton.setEnabled(false);
        }
    }

    private void setEnableSecurityButtons(boolean enable) {
        this.customUserButton.setEnabled(enable);
        this.anyUserButton.setEnabled(enable);
    }

    public Point computeSize() {
        Point p = super.computeSize();
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.restoreValuesFromPreferenceDefault();
        super.performDefaults();
    }

    protected void performApply() {
        if (!this.hasPrefernceChanged()) {
            return;
        }
        adminPlugin.setBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL, this.iacEnabled);
        adminPlugin.setString(PreferenceMessages.ALLOWED_HOSTS, this.allowedHosts);
        adminPlugin.setString(PreferenceMessages.HOST_LIST_LABEL, this.listOfCustomHosts);
        adminPlugin.setBoolean(PreferenceMessages.AC_SECURITY, this.security);
        adminPlugin.setString(PreferenceMessages.ALLOWED_USERS, this.allowedUsers);
        adminPlugin.setString(PreferenceMessages.USER_LIST_LABEL, this.listOfCustomUsers);
        boolean stopIAC = false;
        if (AutoStartStop.getIACStarted()) {
            if (this.iacEnabled) {
                MessageDialog confirmationDialog = AdminUtil.getConfirmationDialog(this.preferenceComposite.getShell(), PreferenceMessages.CONFIRMATION_TITLE, PreferenceMessages.CONFIRMATION_MESSAGE);
                stopIAC = confirmationDialog.open() == 0;
            } else {
                MessageDialog confirmationDialog = AdminUtil.getConfirmationDialog(this.preferenceComposite.getShell(), PreferenceMessages.CONFIRMATION_TITLE, PreferenceMessages.CONFIRMATION_STOP_MESSAGE);
                boolean bl = stopIAC = confirmationDialog.open() == 0;
            }
        }
        if (stopIAC) {
            AutoStartStop.stopIAC();
        }
        if (this.iacEnabled) {
            AdminUtil.generateConfigFile(true);
        }
    }

    private boolean hasPrefernceChanged() {
        if (adminPlugin.getBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL) != this.iacEnabled) {
            return true;
        }
        if (!adminPlugin.getString(PreferenceMessages.ALLOWED_HOSTS).equals(this.allowedHosts)) {
            return true;
        }
        if (!adminPlugin.getString(PreferenceMessages.HOST_LIST_LABEL).equals(this.listOfCustomHosts)) {
            return true;
        }
        if (adminPlugin.getBoolean(PreferenceMessages.AC_SECURITY) != this.security) {
            return true;
        }
        if (!adminPlugin.getString(PreferenceMessages.ALLOWED_USERS).equals(this.allowedUsers)) {
            return true;
        }
        return !adminPlugin.getString(PreferenceMessages.USER_LIST_LABEL).equals(this.listOfCustomUsers);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    class HostUserDialog
    extends Dialog
    implements ModifyListener {
        private Text entryText;
        private String entryString;
        private String title;
        private String entryLabel;
        private Label errorLabel;

        public HostUserDialog(String title, String entryLabel, String entryString) {
            super(Display.getCurrent().getActiveShell());
            this.title = title;
            this.entryString = entryString;
            this.entryLabel = entryLabel;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = AdminUtil.createFill();
            data.widthHint = 300;
            result.setLayoutData((Object)data);
            Composite errorComposite = new Composite(result, 0);
            GridLayout layoutForErrorComposite = new GridLayout();
            GridData dataForErrorComposite = new GridData();
            layoutForErrorComposite.numColumns = 2;
            dataForErrorComposite.horizontalAlignment = 4;
            dataForErrorComposite.grabExcessHorizontalSpace = true;
            dataForErrorComposite.horizontalSpan = 2;
            errorComposite.setLayout((Layout)layoutForErrorComposite);
            errorComposite.setLayoutData((Object)dataForErrorComposite);
            this.errorLabel = new Label(errorComposite, 0);
            this.errorLabel.setLayoutData((Object)AdminUtil.createHorizontalFill());
            this.errorLabel.setText("");
            Label label = new Label(result, 0);
            label.setText(this.entryLabel);
            this.entryText = new Text(result, 2048);
            this.entryText.setLayoutData((Object)AdminUtil.createHorizontalFill());
            this.entryText.addModifyListener((ModifyListener)this);
            if (this.entryString != null) {
                this.entryText.setText(this.entryString);
            }
            this.entryText.setFocus();
            this.entryText.selectAll();
            return result;
        }

        protected void okPressed() {
            this.entryString = this.entryText.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this.entryText.getText().trim().length() > 0);
            return result;
        }

        public String getEntry() {
            return this.entryString;
        }

        public void modifyText(ModifyEvent e) {
            if (this.getButton(0) != null) {
                String entryString;
                List list = null;
                list = this.entryLabel.equalsIgnoreCase(PreferenceMessages.HOST_NAME) ? IACPreferencePage.this.listOfHosts : IACPreferencePage.this.listOfUsers;
                boolean itemAlreadyInList = IACPreferencePage.this.isItemInList(list, entryString = this.entryText.getText().trim());
                if (itemAlreadyInList) {
                    this.errorLabel.setText(PreferenceMessages.ITEM_ALREADY_IS_IN_LIST);
                } else {
                    this.errorLabel.setText("");
                }
                this.getButton(0).setEnabled(entryString.length() > 0 && !itemAlreadyInList);
            }
        }
    }
}

