/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.startstop;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.common.CommonConstants;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACPluginMessages;
import org.eclipse.tptp.platform.iac.administrator.internal.config.ConfigGenerator;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.PreferenceMessages;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.CommandExecutor;

public class AutoStartStop {
    private static boolean iacStarted = false;
    private static boolean shownNotSupportPlatformError = false;
    private static AdminPlugin adminPlugin = AdminPlugin.getDefault();

    public static synchronized int startIAC() {
        if (adminPlugin == null) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.IAC_PLUGIN_NULL);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            return 1;
        }
        if (!AdminUtil.isSupportedPlatform() && !shownNotSupportPlatformError) {
            AdminUtil.openErrorDialog(PreferenceMessages.ERROR_DIALOG_TITLE, PreferenceMessages.NOT_SUPPORT_PLATFORM);
            shownNotSupportPlatformError = true;
        }
        if (!adminPlugin.getBoolean(PreferenceMessages.ENABLE_DISABLE_LABEL)) {
            return 0;
        }
        Process process = null;
        int result = 0;
        if (!AutoStartStop.isIACRunning()) {
            Status status;
            if (AdminUtil.getIACHome() == null) {
                Status status2 = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.IAC_NOT_FOUND);
                AdminPlugin.getDefault().getLog().log((IStatus)status2);
                return 1;
            }
            if (AdminUtil.isNeedToGenerateConfigFile(true)) {
                AdminUtil.generateConfigFile(true);
                if (!AdminUtil.isConfigurationValid(true)) {
                    Status status3 = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.CANT_START_IAC_CONFIG_FILE_INVALID);
                    AdminPlugin.getDefault().getLog().log((IStatus)status3);
                    return 1;
                }
            }
            Runtime rt = Runtime.getRuntime();
            String[] acExecutable = AdminUtil.getIACExecutableArray();
            try {
                process = rt.exec(acExecutable, null, new File(AdminUtil.getIACBinFolder()));
                AutoStartStop autoStartStop = new AutoStartStop();
                autoStartStop.getClass();
                autoStartStop.new ProcessOutputReader(process.getErrorStream(), "Error Stream").start();
                AutoStartStop autoStartStop2 = new AutoStartStop();
                autoStartStop2.getClass();
                autoStartStop2.new ProcessOutputReader(process.getInputStream(), "Output Stream").start();
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
                result = 1;
            }
            if (AutoStartStop.hasProcessTerminated(process)) {
                ConfigGenerator configGenerator = new ConfigGenerator();
                String iacHome = AdminUtil.getIACHome();
                if (iacHome == null) {
                    return 2;
                }
                configGenerator.setUpLocallyWithNoSecurity(iacHome, AdminUtil.getJVMExecutable(), AdminUtil.getPluginsFolder(), AdminUtil.getIACPlugins());
                try {
                    process = rt.exec(acExecutable);
                    AutoStartStop autoStartStop = new AutoStartStop();
                    autoStartStop.getClass();
                    autoStartStop.new ProcessOutputReader(process.getErrorStream(), "Error Stream").start();
                    AutoStartStop autoStartStop3 = new AutoStartStop();
                    autoStartStop3.getClass();
                    autoStartStop3.new ProcessOutputReader(process.getInputStream(), "Output Stream").start();
                }
                catch (Exception e) {
                    Status status4 = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                    AdminPlugin.getDefault().getLog().log((IStatus)status4);
                    result = 1;
                }
                if (AutoStartStop.hasProcessTerminated(process)) {
                    result = 2;
                }
            }
            if (result == 0) {
                while (!AutoStartStop.isIACRunning() && !AutoStartStop.hasProcessTerminated(process)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                        AdminPlugin.getDefault().getLog().log((IStatus)status);
                        result = 1;
                    }
                }
            }
            if (result == 0) {
                iacStarted = true;
            }
        }
        return result;
    }

    public static synchronized int stopIAC() {
        int result = 0;
        if (!iacStarted) {
            return result;
        }
        CommandExecutor commandExecutor = new CommandExecutor();
        String[] command = AdminUtil.getShutdownCommandArray();
        StringBuffer stdOut = new StringBuffer();
        StringBuffer stdErr = new StringBuffer();
        commandExecutor.executeCommand(command, null, AdminUtil.getIACBinFolder(), stdOut, stdErr);
        if (stdErr.length() != 0) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.IAC_SHUTDOWN_ERROR) + stdErr);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            result = 1;
        }
        if (result == 0) {
            while (AutoStartStop.isIACRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, String.valueOf(IACPluginMessages.IAC_SHUTDOWN_ERROR) + e.getMessage(), (Throwable)e);
                    AdminPlugin.getDefault().getLog().log((IStatus)status);
                    result = 1;
                }
            }
            iacStarted = false;
        }
        return result;
    }

    public static boolean isIACRunning() {
        boolean result = true;
        Socket socket = null;
        try {
            socket = new Socket("localhost", 10002);
            socket.close();
        }
        catch (UnknownHostException e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
            result = false;
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    public static int restartIAC() {
        int result = AutoStartStop.stopIAC();
        if (result != 0) {
            return result;
        }
        result = AutoStartStop.startIAC();
        return result;
    }

    private static boolean hasProcessTerminated(Process process) {
        block3: {
            try {
                if (process != null) break block3;
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
        process.exitValue();
        return true;
    }

    public static boolean getIACStarted() {
        return iacStarted;
    }

    class ProcessOutputReader
    extends Thread {
        private BufferedReader reader;
        private String line = "";
        private String streamName = "";

        public ProcessOutputReader(InputStream inputStream, String stream) {
            this.setName(stream);
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.streamName = stream;
        }

        public void run() {
            try {
                while ((this.line = this.reader.readLine()) != null) {
                    if (this.line.indexOf("started successfully") != -1 || this.line.indexOf("Starting Agent Controller") != -1 || this.line.indexOf("ACServer stopped") != -1 || this.line.indexOf("Shutting down the Agent Controller") != -1) continue;
                    this.line = String.valueOf(this.line.trim()) + CommonConstants.LINE_SEPARATOR;
                    Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.IAC_PROCESS_ERROR) + " [" + this.streamName + "]:" + this.line);
                    AdminPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", e.getMessage());
                AdminPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

