/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.startstop;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACPluginMessages;

public final class CommandExecutor {
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;

    public static void main(String[] args) {
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        CommandExecutor ce = new CommandExecutor();
        ce.executeCommand("dir ../..", null, null, stdout, stderr);
        if (stderr.length() != 0) {
            System.err.println("Command generated error(s): " + stderr.toString());
        }
        System.out.println("Ouptut: " + stdout.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(String[] command, String[] environmentVars, String workingDirectory, StringBuffer stdout, StringBuffer stderr) {
        try {
            File workingDirectoryFile = null;
            if (workingDirectory != null && !(workingDirectoryFile = new File(workingDirectory)).exists()) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", String.valueOf(IACPluginMessages.DIRECTORY_NOT_EXIST) + workingDirectory);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
            }
            Process process = Runtime.getRuntime().exec(command, environmentVars, workingDirectoryFile);
            new ProcessOutputReader(process.getErrorStream(), stderr, "Error Stream").start();
            new ProcessOutputReader(process.getInputStream(), stdout, "Output Stream").start();
            Object object = this.currentThreadLock;
            synchronized (object) {
                this.currentThreadLock.wait();
            }
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", IACPluginMessages.PROCESS_ERROR);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
            AdminPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void executeCommand(String command, String[] environmentVars, String workingDirectory, StringBuffer stdout, StringBuffer stderr) {
        String[] commandArray = new String[]{command};
        this.executeCommand(commandArray, environmentVars, workingDirectory, stdout, stderr);
    }

    class ProcessOutputReader
    extends Thread {
        private BufferedReader reader;
        private StringBuffer output;

        public ProcessOutputReader(InputStream inputStream, StringBuffer output, String streamName) {
            String platform = System.getProperty("os.name").toLowerCase();
            if (platform.indexOf("os/400") != -1) {
                try {
                    this.reader = new BufferedReader(new InputStreamReader(inputStream, "Cp037"));
                }
                catch (UnsupportedEncodingException e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                    AdminPlugin.getDefault().getLog().log((IStatus)status);
                }
            } else {
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
            }
            this.output = output;
            this.setName(streamName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String newline = System.getProperty("line.separator");
                String line = "";
                while ((line = this.reader.readLine()) != null) {
                    this.output.append(String.valueOf(line) + newline);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.iac.administrator", 0, e.getMessage(), (Throwable)e);
                AdminPlugin.getDefault().getLog().log((IStatus)status);
            }
            Object object = CommandExecutor.this.currentThreadLock;
            synchronized (object) {
                CommandExecutor commandExecutor = CommandExecutor.this;
                int n = commandExecutor.childThreadsDone + 1;
                commandExecutor.childThreadsDone = n;
                if (n == 2) {
                    CommandExecutor.this.currentThreadLock.notify();
                }
            }
        }
    }
}

